/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.Tracer;

public class TraceClientInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TraceClientInterceptor.class);
    private Tracer tracer;
    private final SpanInjector<Metadata> spanInjector;

    public TraceClientInterceptor(Tracer tracer, SpanInjector<Metadata> spanInjector) {
        this.tracer = tracer;
        this.spanInjector = spanInjector;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) throws StatusException {
                final Span span = TraceClientInterceptor.this.tracer.createSpan("grpc:" + method.getFullMethodName());
                TraceClientInterceptor.this.spanInjector.inject(span, (Object)headers);
                ForwardingClientCallListener.SimpleForwardingClientCallListener tracingResponseListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onClose(Status status, Metadata trailers) {
                        if (status.getCode().value() == 0) {
                            log.debug("Call finish success");
                        } else {
                            log.warn("Call finish failed", (Object)status.getDescription());
                        }
                        TraceClientInterceptor.this.tracer.close(span);
                        this.delegate().onClose(status, trailers);
                    }
                };
                this.delegate().start((ClientCall.Listener)tracingResponseListener, headers);
            }
        };
    }
}

