/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import com.google.common.collect.Lists;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.devh.springboot.autoconfigure.grpc.client.GlobalClientInterceptorRegistry;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelFactory;
import net.devh.springboot.autoconfigure.grpc.client.GrpcClient;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class GrpcClientBeanPostProcessor
implements BeanPostProcessor {
    private Map<String, List<Class>> beansToProcess = new HashMap<String, List<Class>>();
    @Autowired
    private DefaultListableBeanFactory beanFactory;
    @Autowired
    private GrpcChannelFactory channelFactory;
    @Autowired
    private GlobalClientInterceptorRegistry globalClientInterceptorRegistry;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(GrpcClient.class)) continue;
                if (!this.beansToProcess.containsKey(beanName)) {
                    this.beansToProcess.put(beanName, new ArrayList());
                }
                this.beansToProcess.get(beanName).add(clazz);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        List<ClientInterceptor> globalInterceptorList = this.globalClientInterceptorRegistry.getClientInterceptors();
        if (this.beansToProcess.containsKey(beanName)) {
            Object target = this.getTargetBean(bean);
            for (Class clazz : this.beansToProcess.get(beanName)) {
                for (Field field : clazz.getDeclaredFields()) {
                    GrpcClient annotation = (GrpcClient)AnnotationUtils.getAnnotation((AnnotatedElement)field, GrpcClient.class);
                    if (null == annotation) continue;
                    Channel channel = this.beanFactory.containsBean(field.getName()) ? (Channel)this.beanFactory.getBean(field.getName()) : this.channelFactory.createChannel(annotation.value());
                    ReflectionUtils.makeAccessible((Field)field);
                    channel = this.bindInterceptors(channel, annotation, globalInterceptorList);
                    ReflectionUtils.setField((Field)field, (Object)target, (Object)channel);
                }
            }
        }
        return bean;
    }

    private Channel bindInterceptors(Channel channel, GrpcClient grpcClient, List<ClientInterceptor> globalInterceptorList) {
        HashSet<ClientInterceptor> interceptorSet = new HashSet<ClientInterceptor>();
        interceptorSet.addAll(globalInterceptorList);
        for (Class<? extends ClientInterceptor> clientInterceptorClass : grpcClient.interceptors()) {
            ClientInterceptor clientInterceptor;
            if (this.beanFactory.getBeanNamesForType(ClientInterceptor.class).length > 0) {
                clientInterceptor = (ClientInterceptor)this.beanFactory.getBean(clientInterceptorClass);
            } else {
                try {
                    clientInterceptor = clientInterceptorClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new BeanCreationException("Failed to create interceptor instance", (Throwable)e);
                }
            }
            interceptorSet.add(clientInterceptor);
        }
        return ClientInterceptors.intercept((Channel)channel, (List)Lists.newArrayList(interceptorSet));
    }

    private Object getTargetBean(Object bean) {
        Object target = bean;
        while (AopUtils.isAopProxy((Object)target)) {
            target = ((Advised)target).getTargetSource().getTarget();
        }
        return target;
    }
}

