/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import io.grpc.Channel;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.devh.springboot.autoconfigure.grpc.client.DiscoveryClientResolverFactory;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelFactory;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelsProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class DiscoveryClientChannelFactory
implements GrpcChannelFactory {
    private final GrpcChannelsProperties properties;
    private final DiscoveryClient client;
    private final LoadBalancer.Factory loadBalancerFactory;
    private static Map<String, ManagedChannel> channelMap = new ConcurrentHashMap<String, ManagedChannel>();

    public DiscoveryClientChannelFactory(GrpcChannelsProperties properties, DiscoveryClient client, LoadBalancer.Factory loadBalancerFactory) {
        this.properties = properties;
        this.client = client;
        this.loadBalancerFactory = loadBalancerFactory;
    }

    @Override
    public Channel createChannel(String name) {
        ManagedChannel channel = channelMap.get(name);
        if (channel == null) {
            ManagedChannel newChannel = ManagedChannelBuilder.forTarget((String)name).loadBalancerFactory(this.loadBalancerFactory).nameResolverFactory((NameResolver.Factory)new DiscoveryClientResolverFactory(this.client)).usePlaintext(this.properties.getChannel(name).isPlaintext()).build();
            channel = channelMap.putIfAbsent(name, newChannel) == null ? newChannel : channelMap.get(name);
        }
        return channel;
    }
}

