/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.base;

import com.kscs.util.plugins.xjc.base.AbstractPlugin;
import com.sun.xml.bind.api.impl.NameConverter;
import java.lang.reflect.Field;

public abstract class Option<T> {
    protected final AbstractPlugin plugin;
    protected final Field field;
    protected final String name;
    protected final String choice;
    protected static final NameConverter NAME_CONVERTER = new NameConverter.Standard();

    protected Option(String name, AbstractPlugin plugin, Field field, String choice) {
        this.name = name;
        this.plugin = plugin;
        this.field = field;
        this.choice = choice;
    }

    public String getName() {
        return this.name;
    }

    public abstract void setStringValue(String var1);

    public abstract String getStringValue();

    public void set(T v) {
        this.field.setAccessible(true);
        try {
            this.field.set((Object)this.plugin, v);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getChoice() {
        return this.choice;
    }

    public T get() {
        try {
            this.field.setAccessible(true);
            Object val = this.field.get((Object)this.plugin);
            return (T)val;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public boolean matches(String arg) {
        return arg.startsWith("-") && (this.name.equalsIgnoreCase(arg.substring(1)) || this.name.equals(NAME_CONVERTER.toVariableName(arg.substring(1))));
    }

    public boolean tryParse(String arg) {
        int equalsIndex = arg.indexOf("=");
        if (arg.startsWith("-") && equalsIndex > 0 && (this.name.equalsIgnoreCase(arg.substring(1, equalsIndex)) || this.name.equals(NAME_CONVERTER.toVariableName(arg.substring(1, equalsIndex))))) {
            this.setStringValue(arg.substring(equalsIndex + 1));
            return true;
        }
        return false;
    }
}

