/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.base;

import com.kscs.util.plugins.xjc.base.Option;
import com.kscs.util.plugins.xjc.base.PluginUsageBuilder;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class HtmlUsageBuilder
extends PluginUsageBuilder {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final DocumentBuilder DOCUMENT_BUILDER;
    private static final String NAMESPACE = "http://www.w3.org/1999/xhtml";
    private final Document document = DOCUMENT_BUILDER.newDocument();
    private Element dl = null;
    private String pluginName = null;

    public HtmlUsageBuilder(ResourceBundle baseResourceBundle, ResourceBundle resourceBundle) {
        super(baseResourceBundle, resourceBundle);
        this.document.setXmlStandalone(true);
        HtmlUsageBuilder.newElement(this.document, "section");
    }

    public static Element createBody(String title, String css, boolean linkCss) {
        Document document = DOCUMENT_BUILDER.newDocument();
        document.setXmlStandalone(true);
        Element html = HtmlUsageBuilder.newElement(document, "html");
        html.setAttribute("lang", Locale.getDefault().getLanguage());
        html.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", Locale.getDefault().getLanguage());
        Element head = HtmlUsageBuilder.newElement(html, "head");
        HtmlUsageBuilder.newElement(head, "title", title);
        if (linkCss) {
            Element link = HtmlUsageBuilder.newElement(head, "link");
            link.setAttribute("type", "text/css");
            link.setAttribute("rel", "stylesheet");
            link.setAttribute("href", css);
        } else {
            Element style = HtmlUsageBuilder.newElement(head, "style", css);
            style.setAttribute("type", "text/css");
        }
        return HtmlUsageBuilder.newElement(html, "body");
    }

    private static Element newElement(Node parent, String name, String textContent) {
        Element el = HtmlUsageBuilder.newElement(parent, name);
        el.setTextContent(textContent);
        return el;
    }

    private static Text newText(Node parent, String textContent) {
        Text text = parent.getOwnerDocument().createTextNode(textContent);
        parent.appendChild(text);
        return text;
    }

    private static Element newElement(Node parent, String name) {
        Element el = (parent instanceof Document ? (Document)parent : parent.getOwnerDocument()).createElementNS(NAMESPACE, name);
        parent.appendChild(el);
        return el;
    }

    @Override
    public HtmlUsageBuilder addMain(String optionName) {
        this.pluginName = optionName;
        this.newElement("a").setAttribute("name", optionName);
        Element h1 = this.newElement("h1");
        HtmlUsageBuilder.newText(h1, optionName);
        Element p = this.newElement("p");
        p.setTextContent(this.resourceBundle.getString(this.keyBase));
        return this;
    }

    @Override
    public <T> HtmlUsageBuilder addOption(Option<?> option) {
        if (this.dl == null) {
            Element h2 = this.newElement("h2");
            h2.setTextContent(this.baseResourceBundle.getString(this.keyBase + ".options"));
            this.dl = this.newElement("dl");
        }
        String key = this.keyBase + "." + HtmlUsageBuilder.transformName(option.getName());
        Element dt = HtmlUsageBuilder.newElement(this.dl, "dt");
        HtmlUsageBuilder.newElement(dt, "a").setAttribute("name", this.pluginName + "." + option.getName());
        HtmlUsageBuilder.newText(dt, "-" + option.getName() + "=");
        HtmlUsageBuilder.newElement(dt, "span", option.getChoice()).setAttribute("class", "choice");
        HtmlUsageBuilder.newElement(dt, "span", option.getStringValue()).setAttribute("class", "default");
        HtmlUsageBuilder.newElement(this.dl, "dd", this.resourceBundle.getString(key));
        return this;
    }

    public Document build(Node parent) {
        Node importedNode = parent.getOwnerDocument().importNode(this.document.getDocumentElement(), true);
        parent.appendChild(importedNode);
        return parent.getOwnerDocument();
    }

    private Element newElement(String name) {
        Element el = this.document.createElementNS(NAMESPACE, name);
        this.document.getDocumentElement().appendChild(el);
        return el;
    }

    static {
        try {
            DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
            DOCUMENT_BUILDER = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

