/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.gradle.api.Project;

public class ByteBuddyLogHandler
extends Handler {
    private final Project project;
    private final Logger logger;
    private final boolean useParentHandlers;

    protected ByteBuddyLogHandler(Project project, Logger logger, boolean useParentHandlers) {
        this.project = project;
        this.logger = logger;
        this.useParentHandlers = useParentHandlers;
        this.setFormatter(new SimpleFormatter());
    }

    public static ByteBuddyLogHandler initialize(Project project) {
        Logger logger = Logger.getLogger("net.bytebuddy");
        ByteBuddyLogHandler handler = new ByteBuddyLogHandler(project, logger, logger.getUseParentHandlers());
        try {
            logger.setUseParentHandlers(false);
            logger.addHandler(handler);
        }
        catch (SecurityException exception) {
            project.getLogger().warn("Cannot configure Byte Buddy logging", (Throwable)exception);
        }
        return handler;
    }

    public void reset() {
        try {
            this.logger.setUseParentHandlers(this.useParentHandlers);
            this.logger.removeHandler(this);
        }
        catch (SecurityException exception) {
            this.project.getLogger().warn("Cannot configure Byte Buddy logging", (Throwable)exception);
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (this.project.getLogger().isDebugEnabled()) {
            this.project.getLogger().debug(this.getFormatter().format(record));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "ByteBuddyLogHandler{project=" + this.project + " ,logger=" + this.logger + " ,useParentHandlers=" + this.useParentHandlers + '}';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteBuddyLogHandler)) {
            return false;
        }
        ByteBuddyLogHandler other = (ByteBuddyLogHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Project this$project = this.project;
        Project other$project = other.project;
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        Logger this$logger = this.logger;
        Logger other$logger = other.logger;
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        return this.useParentHandlers == other.useParentHandlers;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ByteBuddyLogHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Project $project = this.project;
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        Logger $logger = this.logger;
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        result = result * 59 + (this.useParentHandlers ? 79 : 97);
        return result;
    }
}

