/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle.android;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.gradle.android.PluginArgument;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.nullability.UnknownNull;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class Transformation {
    @UnknownNull
    private final transient Project project;
    private final List<PluginArgument> arguments;
    @MaybeNull
    private Class<? extends Plugin> plugin;
    @MaybeNull
    private String pluginName;

    public Transformation() {
        this.project = null;
        this.arguments = new ArrayList<PluginArgument>();
    }

    @Inject
    public Transformation(Project project) {
        this.project = project;
        this.arguments = new ArrayList<PluginArgument>();
    }

    @Input
    public List<PluginArgument> getArguments() {
        return this.arguments;
    }

    public void argument(Closure<?> closure) {
        this.getArguments().add((PluginArgument)this.project.configure((Object)new PluginArgument(this.getArguments().size()), closure));
    }

    public void argument(Action<PluginArgument> action) {
        PluginArgument argument = new PluginArgument(this.getArguments().size());
        action.execute((Object)argument);
        this.getArguments().add(argument);
    }

    @Input
    @MaybeNull
    @Optional
    public Class<? extends Plugin> getPlugin() {
        return this.plugin;
    }

    public void setPlugin(@MaybeNull Class<? extends Plugin> plugin) {
        this.plugin = plugin;
    }

    @Input
    @MaybeNull
    @Optional
    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(@MaybeNull String pluginName) {
        this.pluginName = pluginName;
    }

    protected Object resolve() {
        try {
            Class<?> type = Class.forName("net.bytebuddy.build.gradle.Transformation");
            Object instance = type.getConstructor(Project.class).newInstance(this.project);
            List arguments = (List)type.getMethod("getArguments", new Class[0]).invoke(instance, new Object[0]);
            for (PluginArgument argument : this.arguments) {
                arguments.add(argument.resolve());
            }
            type.getMethod("setPlugin", new Class[0]).invoke(instance, this.plugin);
            type.getMethod("setPluginName", String.class).invoke(instance, this.pluginName);
            return instance;
        }
        catch (Exception exception) {
            throw new GradleException("Could not resolve plugin argument", (Throwable)exception);
        }
    }
}

