/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle.android;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.gradle.android.ByteBuddyLocalClassesEnhancerTask;
import net.bytebuddy.build.gradle.android.Discovery;
import net.bytebuddy.build.gradle.android.Transformation;
import net.bytebuddy.utility.nullability.MaybeNull;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;

public class ByteBuddyAndroidTaskExtension {
    private final Project project;
    private final List<Transformation> transformations;
    private EntryPoint entryPoint;
    private String suffix;
    private boolean failOnLiveInitializer;
    private boolean warnOnEmptyTypeSet;
    private boolean failFast;
    private boolean extendedParsing;
    private Discovery discovery;
    private int threads;
    @MaybeNull
    private FileCollection discoverySet;

    public ByteBuddyAndroidTaskExtension(Project project) {
        this.project = project;
        this.transformations = new ArrayList<Transformation>();
        this.entryPoint = new EntryPoint.Unvalidated((EntryPoint)EntryPoint.Default.DECORATE);
        this.suffix = "";
        this.failOnLiveInitializer = true;
        this.warnOnEmptyTypeSet = true;
        this.failFast = true;
        this.discovery = Discovery.EMPTY;
    }

    public List<Transformation> getTransformations() {
        return this.transformations;
    }

    public void transformation(Closure<Transformation> closure) {
        this.transformations.add((Transformation)this.project.configure((Object)new Transformation(this.project), closure));
    }

    public void transformation(Action<Transformation> action) {
        Transformation transformation = new Transformation(this.project);
        action.execute((Object)transformation);
        this.transformations.add(transformation);
    }

    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(EntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isFailOnLiveInitializer() {
        return this.failOnLiveInitializer;
    }

    public void setFailOnLiveInitializer(boolean failOnLiveInitializer) {
        this.failOnLiveInitializer = failOnLiveInitializer;
    }

    public boolean isWarnOnEmptyTypeSet() {
        return this.warnOnEmptyTypeSet;
    }

    public void setWarnOnEmptyTypeSet(boolean warnOnEmptyTypeSet) {
        this.warnOnEmptyTypeSet = warnOnEmptyTypeSet;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public boolean isExtendedParsing() {
        return this.extendedParsing;
    }

    public void setExtendedParsing(boolean extendedParsing) {
        this.extendedParsing = extendedParsing;
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(Discovery discovery) {
        this.discovery = discovery;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    @MaybeNull
    public FileCollection getDiscoverySet() {
        return this.discoverySet;
    }

    public void setDiscoverySet(@MaybeNull FileCollection discoverySet) {
        this.discoverySet = discoverySet;
    }

    protected void configure(ByteBuddyLocalClassesEnhancerTask task) {
        task.getTransformations().convention(this.getTransformations());
        task.getEntryPoint().convention((Object)this.getEntryPoint());
        task.getSuffix().convention((Object)this.getSuffix());
        task.getFailOnLiveInitializer().convention((Object)this.isFailOnLiveInitializer());
        task.getWarnOnEmptyTypeSet().convention((Object)this.isWarnOnEmptyTypeSet());
        task.getFailFast().convention((Object)this.isFailFast());
        task.getExtendedParsing().convention((Object)this.isExtendedParsing());
        task.getDiscovery().convention((Object)this.getDiscovery());
        task.getThreads().convention((Object)this.getThreads());
        task.getDiscoverySet().setFrom((Iterable)this.getDiscoverySet());
    }
}

