/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.gradle.AbstractByteBuddyTask;
import net.bytebuddy.build.gradle.Adjustment;
import net.bytebuddy.build.gradle.Discovery;
import net.bytebuddy.build.gradle.ObjectFactory;
import net.bytebuddy.build.gradle.Transformation;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.nullability.UnknownNull;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractByteBuddyTaskExtension<T extends AbstractByteBuddyTask> {
    private final Project project;
    private final List<Transformation> transformations;
    private EntryPoint entryPoint;
    private String suffix;
    private boolean failOnLiveInitializer;
    private boolean warnOnEmptyTypeSet;
    private boolean failFast;
    private boolean extendedParsing;
    private Discovery discovery;
    private Adjustment adjustment;
    private Adjustment.ErrorHandler adjustmentErrorHandler;
    private Action<Task> adjustmentPostProcessor;
    private int threads;
    private boolean lazy;
    @MaybeNull
    private ClassFileVersion classFileVersion;
    @MaybeNull
    private ClassFileVersion multiReleaseClassFileVersion;

    protected AbstractByteBuddyTaskExtension(@UnknownNull Project project) {
        this.project = project;
        this.transformations = new ArrayList<Transformation>();
        this.entryPoint = EntryPoint.Default.REBASE;
        this.suffix = "";
        this.failOnLiveInitializer = true;
        this.warnOnEmptyTypeSet = true;
        this.failFast = true;
        this.discovery = Discovery.EMPTY;
        this.adjustment = Adjustment.FULL;
        this.adjustmentErrorHandler = Adjustment.ErrorHandler.WARN;
        this.adjustmentPostProcessor = Adjustment.NoOpPostProcessor.INSTANCE;
    }

    public List<Transformation> getTransformations() {
        return this.transformations;
    }

    public void transformation(Closure<Transformation> closure) {
        Transformation transformation = ObjectFactory.newInstance(this.project, Transformation.class, this.project);
        if (transformation == null) {
            transformation = new Transformation(this.project);
        }
        this.transformations.add((Transformation)this.project.configure((Object)transformation, closure));
    }

    public void transformation(Action<Transformation> action) {
        Transformation transformation = ObjectFactory.newInstance(this.project, Transformation.class, this.project);
        if (transformation == null) {
            transformation = new Transformation(this.project);
        }
        action.execute((Object)transformation);
        this.transformations.add(transformation);
    }

    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(EntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isFailOnLiveInitializer() {
        return this.failOnLiveInitializer;
    }

    public void setFailOnLiveInitializer(boolean failOnLiveInitializer) {
        this.failOnLiveInitializer = failOnLiveInitializer;
    }

    public boolean isWarnOnEmptyTypeSet() {
        return this.warnOnEmptyTypeSet;
    }

    public void setWarnOnEmptyTypeSet(boolean warnOnEmptyTypeSet) {
        this.warnOnEmptyTypeSet = warnOnEmptyTypeSet;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public boolean isExtendedParsing() {
        return this.extendedParsing;
    }

    public void setExtendedParsing(boolean extendedParsing) {
        this.extendedParsing = extendedParsing;
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(Discovery discovery) {
        this.discovery = discovery;
    }

    public Adjustment getAdjustment() {
        return this.adjustment;
    }

    public void setAdjustment(Adjustment adjustment) {
        this.adjustment = adjustment;
    }

    public Adjustment.ErrorHandler getAdjustmentErrorHandler() {
        return this.adjustmentErrorHandler;
    }

    public void setAdjustmentErrorHandler(Adjustment.ErrorHandler adjustmentErrorHandler) {
        this.adjustmentErrorHandler = adjustmentErrorHandler;
    }

    public Action<Task> getAdjustmentPostProcessor() {
        return this.adjustmentPostProcessor;
    }

    public void setAdjustmentPostProcessor(Action<Task> adjustmentPostProcessor) {
        this.adjustmentPostProcessor = adjustmentPostProcessor;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    @MaybeNull
    public ClassFileVersion getClassFileVersion() {
        return this.classFileVersion;
    }

    public void setClassFileVersion(@MaybeNull ClassFileVersion classFileVersion) {
        this.classFileVersion = classFileVersion;
    }

    @MaybeNull
    public ClassFileVersion getMultiReleaseClassFileVersion() {
        return this.multiReleaseClassFileVersion;
    }

    public void setMultiReleaseClassFileVersion(@MaybeNull ClassFileVersion multiReleaseClassFileVersion) {
        this.multiReleaseClassFileVersion = multiReleaseClassFileVersion;
    }

    protected void resolve(JavaVersion version) {
        if (this.classFileVersion == null) {
            this.classFileVersion = ClassFileVersion.ofJavaVersion((int)Integer.parseInt(version.getMajorVersion()));
        }
    }

    protected abstract boolean isEmptyDiscovery();

    protected abstract void doConfigure(T var1);

    protected void configure(T task) {
        ((AbstractByteBuddyTask)((Object)task)).getTransformations().addAll(this.getTransformations());
        ((AbstractByteBuddyTask)((Object)task)).setEntryPoint(this.getEntryPoint());
        ((AbstractByteBuddyTask)((Object)task)).setSuffix(this.getSuffix());
        ((AbstractByteBuddyTask)((Object)task)).setFailOnLiveInitializer(this.isFailOnLiveInitializer());
        ((AbstractByteBuddyTask)((Object)task)).setWarnOnEmptyTypeSet(this.isWarnOnEmptyTypeSet());
        ((AbstractByteBuddyTask)((Object)task)).setFailFast(this.isFailFast());
        ((AbstractByteBuddyTask)((Object)task)).setExtendedParsing(this.isExtendedParsing());
        ((AbstractByteBuddyTask)((Object)task)).setDiscovery(this.getDiscovery());
        ((AbstractByteBuddyTask)((Object)task)).setThreads(this.getThreads());
        ((AbstractByteBuddyTask)((Object)task)).setClassFileVersion(this.getClassFileVersion());
        ((AbstractByteBuddyTask)((Object)task)).setMultiReleaseClassFileVersion(this.getMultiReleaseClassFileVersion());
        this.doConfigure(task);
    }

    protected abstract void discoverySet(FileCollection var1);

    protected abstract Class<? extends T> toType();
}

