/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle.android;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.bytebuddy.build.gradle.android.ByteBuddyAndroidPlugin;
import org.gradle.api.Action;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;

public abstract class AarGradleTransformAction
implements TransformAction<TransformParameters.None> {
    private static final String AAR_FILE_EXTENSION = "aar";

    @InputArtifact
    public abstract Provider<FileSystemLocation> getInputArtifact();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(TransformOutputs transformOutputs) {
        File input = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        String outputName = input.getName().replaceAll("\\.aar$", ".jar");
        try (ZipFile zipFile = new ZipFile(input);){
            ZipEntry entry = zipFile.getEntry("classes.jar");
            try (InputStream inputStream = zipFile.getInputStream(entry);
                 FileOutputStream outputStream = new FileOutputStream(transformOutputs.file((Object)outputName));){
                int length;
                byte[] buffer = new byte[8192];
                while ((length = inputStream.read(buffer)) != -1) {
                    ((OutputStream)outputStream).write(buffer, 0, length);
                }
            }
        }
        catch (IOException exception) {
            throw new IllegalStateException("Failed to transform " + this.getInputArtifact(), exception);
        }
    }

    protected static class ConfigurationAction
    implements Action<TransformSpec<TransformParameters.None>> {
        protected ConfigurationAction() {
        }

        public void execute(TransformSpec<TransformParameters.None> spec) {
            spec.getFrom().attribute(ByteBuddyAndroidPlugin.ARTIFACT_TYPE_ATTRIBUTE, (Object)AarGradleTransformAction.AAR_FILE_EXTENSION);
            spec.getTo().attribute(ByteBuddyAndroidPlugin.ARTIFACT_TYPE_ATTRIBUTE, (Object)"bytebuddy-jar");
        }
    }
}

