/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility.visitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.OpenedClassReader;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackAwareMethodVisitor
extends MethodVisitor {
    private static final int[] SIZE_CHANGE = new int[202];
    private List<StackSize> current = new ArrayList<StackSize>();
    private final Map<Label, List<StackSize>> sizes = new HashMap<Label, List<StackSize>>();
    private int freeIndex;

    public StackAwareMethodVisitor(MethodVisitor methodVisitor, MethodDescription instrumentedMethod) {
        super(OpenedClassReader.ASM_API, methodVisitor);
        this.freeIndex = instrumentedMethod.getStackSize();
    }

    private void adjustStack(int delta) {
        this.adjustStack(delta, 0);
    }

    private void adjustStack(int delta, int offset) {
        if (delta > 2) {
            throw new IllegalStateException("Cannot push multiple values onto the operand stack: " + delta);
        }
        if (delta > 0) {
            int position = this.current.size();
            while (offset > 0 && position > 0) {
                offset -= this.current.get(--position).getSize();
            }
            if (offset < 0) {
                throw new IllegalStateException("Unexpected offset underflow: " + offset);
            }
            this.current.add(position, StackSize.of(delta));
        } else {
            if (offset != 0) {
                throw new IllegalStateException("Cannot specify non-zero offset " + offset + " for non-incrementing value: " + delta);
            }
            while (delta < 0) {
                if (this.current.isEmpty()) {
                    return;
                }
                delta += this.current.remove(this.current.size() - 1).getSize();
            }
            if (delta == 1) {
                this.current.add(StackSize.SINGLE);
            } else if (delta != 0) {
                throw new IllegalStateException("Unexpected remainder on the operand stack: " + delta);
            }
        }
    }

    public void drainStack() {
        this.doDrain(this.current);
    }

    public int drainStack(int store, int load, StackSize size) {
        int difference = this.current.get(this.current.size() - 1).getSize() - size.getSize();
        if (this.current.size() == 1 && difference == 0) {
            return 0;
        }
        super.visitVarInsn(store, this.freeIndex);
        if (difference == 1) {
            super.visitInsn(87);
        } else if (difference != 0) {
            throw new IllegalStateException("Unexpected remainder on the operand stack: " + difference);
        }
        this.doDrain(this.current.subList(0, this.current.size() - 1));
        super.visitVarInsn(load, this.freeIndex);
        return this.freeIndex + size.getSize();
    }

    private void doDrain(List<StackSize> stackSizes) {
        ListIterator<StackSize> iterator = stackSizes.listIterator(stackSizes.size());
        block4: while (iterator.hasPrevious()) {
            StackSize current = iterator.previous();
            switch (current) {
                case SINGLE: {
                    super.visitInsn(87);
                    continue block4;
                }
                case DOUBLE: {
                    super.visitInsn(88);
                    continue block4;
                }
            }
            throw new IllegalStateException("Unexpected stack size: " + (Object)((Object)current));
        }
    }

    public void register(Label label, List<StackSize> stackSizes) {
        this.sizes.put(label, stackSizes);
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                this.current.clear();
                break;
            }
            case 90: 
            case 93: {
                this.adjustStack(SIZE_CHANGE[opcode], SIZE_CHANGE[opcode] + 1);
                break;
            }
            case 91: 
            case 94: {
                this.adjustStack(SIZE_CHANGE[opcode], SIZE_CHANGE[opcode] + 2);
                break;
            }
            case 136: 
            case 137: 
            case 142: 
            case 144: {
                this.adjustStack(-2);
                this.adjustStack(1);
                break;
            }
            case 133: 
            case 135: 
            case 140: 
            case 141: {
                this.adjustStack(-1);
                this.adjustStack(2);
                break;
            }
            case 47: 
            case 49: {
                this.adjustStack(-2);
                this.adjustStack(2);
                break;
            }
            default: {
                this.adjustStack(SIZE_CHANGE[opcode]);
            }
        }
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.adjustStack(SIZE_CHANGE[opcode]);
        super.visitIntInsn(opcode, operand);
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="No default behavior is applied")
    public void visitVarInsn(int opcode, int variable) {
        switch (opcode) {
            case 54: 
            case 56: 
            case 58: {
                this.freeIndex = Math.max(this.freeIndex, variable + 1);
                break;
            }
            case 55: 
            case 57: {
                this.freeIndex = Math.max(this.freeIndex, variable + 2);
                break;
            }
            case 169: {
                this.current.clear();
            }
        }
        this.adjustStack(SIZE_CHANGE[opcode]);
        super.visitVarInsn(opcode, variable);
    }

    public void visitTypeInsn(int opcode, String type) {
        this.adjustStack(SIZE_CHANGE[opcode]);
        super.visitTypeInsn(opcode, type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        int baseline = Type.getType((String)descriptor).getSize();
        switch (opcode) {
            case 180: {
                this.adjustStack(-1);
                this.adjustStack(baseline);
                break;
            }
            case 178: {
                this.adjustStack(baseline);
                break;
            }
            case 181: {
                this.adjustStack(-baseline - 1);
                break;
            }
            case 179: {
                this.adjustStack(-baseline);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected opcode: " + opcode);
            }
        }
        super.visitFieldInsn(opcode, owner, name, descriptor);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        int baseline = Type.getArgumentsAndReturnSizes((String)descriptor);
        this.adjustStack(-(baseline >> 2) + (opcode == 184 ? 1 : 0));
        this.adjustStack(baseline & 3);
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrap, Object ... bootstrapArguments) {
        int baseline = Type.getArgumentsAndReturnSizes((String)descriptor);
        this.adjustStack(-(baseline >> 2) + 1);
        this.adjustStack(baseline & 3);
        super.visitInvokeDynamicInsn(name, descriptor, bootstrap, bootstrapArguments);
    }

    public void visitLdcInsn(Object value) {
        this.adjustStack(value instanceof Long || value instanceof Double ? 2 : 1);
        super.visitLdcInsn(value);
    }

    public void visitMultiANewArrayInsn(String descriptor, int dimension) {
        this.adjustStack(1 - dimension);
        super.visitMultiANewArrayInsn(descriptor, dimension);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.adjustStack(SIZE_CHANGE[opcode]);
        this.sizes.put(label, new ArrayList<StackSize>(opcode == 168 ? CompoundList.of(this.current, StackSize.SINGLE) : this.current));
        if (opcode == 167) {
            this.current.clear();
        }
        super.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        List<StackSize> current = this.sizes.get(label);
        if (current != null) {
            this.current = new ArrayList<StackSize>(current);
        }
        super.visitLabel(label);
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
    }

    public void visitTableSwitchInsn(int minimum, int maximum, Label defaultOption, Label ... option) {
        this.adjustStack(-1);
        ArrayList<StackSize> current = new ArrayList<StackSize>(this.current);
        this.sizes.put(defaultOption, current);
        for (Label label : option) {
            this.sizes.put(label, current);
        }
        super.visitTableSwitchInsn(minimum, maximum, defaultOption, option);
    }

    public void visitLookupSwitchInsn(Label defaultOption, int[] key, Label[] option) {
        this.adjustStack(-1);
        ArrayList<StackSize> current = new ArrayList<StackSize>(this.current);
        this.sizes.put(defaultOption, current);
        for (Label label : option) {
            this.sizes.put(label, current);
        }
        super.visitLookupSwitchInsn(defaultOption, key, option);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.sizes.put(handler, Collections.singletonList(StackSize.SINGLE));
        super.visitTryCatchBlock(start, end, handler, type);
    }

    static {
        String encoded = "EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEEEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        for (int index = 0; index < SIZE_CHANGE.length; ++index) {
            StackAwareMethodVisitor.SIZE_CHANGE[index] = encoded.charAt(index) - 69;
        }
    }
}

