/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.util.schema.impl;

import javax.xml.namespace.QName;
import net.bpelunit.toolsupport.util.schema.SchemaElementManager;
import net.bpelunit.toolsupport.util.schema.impl.SchemaElementManagerImpl;
import net.bpelunit.toolsupport.util.schema.nodes.ComplexType;
import net.bpelunit.toolsupport.util.schema.nodes.Element;
import net.bpelunit.toolsupport.util.schema.nodes.SimpleType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaElementManagerImplTest {
    private SchemaElementManager manager;

    @Before
    public void setUp() throws Exception {
        this.manager = new SchemaElementManagerImpl();
    }

    @Test
    public void testGetSimpleTypeByQName() {
        String localPart = "string";
        SimpleType simple = this.manager.getSimpleType(new QName("http://www.w3.org/2001/XMLSchema", localPart));
        Assert.assertNotNull((String)"If this SimpleType does not exists the manager has to create one", (Object)simple);
        Assert.assertEquals((Object)new QName("http://www.w3.org/2001/XMLSchema", localPart), (Object)simple.getQName());
        Assert.assertSame((String)"a further call has to return the same SimpleType", (Object)simple, (Object)this.manager.getSimpleType(new QName("http://www.w3.org/2001/XMLSchema", localPart)));
        Assert.assertSame((String)"a further call has to return the same SimpleType", (Object)simple, (Object)this.manager.getSimpleType("http://www.w3.org/2001/XMLSchema", localPart));
        Assert.assertSame((String)"a further call has to return the same SimpleType", (Object)simple, (Object)this.manager.getSimpleType(localPart));
    }

    @Test
    public void testGetSimpleTypeByLocalPart() throws Exception {
        String localPart = "integer";
        SimpleType simple = this.manager.getSimpleType(localPart);
        Assert.assertNotNull((String)"If this SimpleType does not exists the manager has to create one", (Object)simple);
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)simple.getNamespace());
        Assert.assertEquals((Object)localPart, (Object)simple.getLocalPart());
        Assert.assertSame((String)"a further call has to return the same SimpleType", (Object)simple, (Object)this.manager.getSimpleType(localPart));
        Assert.assertSame((String)"a further call has to return the same SimpleType", (Object)simple, (Object)this.manager.getSimpleType("http://www.w3.org/2001/XMLSchema", localPart));
        Assert.assertSame((String)"a further call has to return the same SimpleType", (Object)simple, (Object)this.manager.getSimpleType(new QName("http://www.w3.org/2001/XMLSchema", localPart)));
    }

    @Test
    public void testGetSimpleTypeByTargetNamespaceAndLocalPart() throws Exception {
        String localPart = "bool";
        String targetNs = "http://my.own.namespace.org";
        SimpleType simple = this.manager.getSimpleType(targetNs, localPart);
        Assert.assertNotNull((String)"If this SimpleType does not exists the manager has to create one", (Object)simple);
        Assert.assertEquals((Object)targetNs, (Object)simple.getNamespace());
        Assert.assertEquals((Object)localPart, (Object)simple.getLocalPart());
        Assert.assertSame((String)"a further call has to return the same SimpleType", (Object)simple, (Object)this.manager.getSimpleType(targetNs, localPart));
        Assert.assertSame((String)"a further call has to return the same SimpleType", (Object)simple, (Object)this.manager.getSimpleType(new QName(targetNs, localPart)));
    }

    @Test
    public void testGetComplexTypeByQName() {
        QName qName = new QName("http://my.own.namespace.org", "PersonType");
        ComplexType complex = this.manager.getComplexType(qName);
        Assert.assertNotNull((String)"If this ComplexType does not exists the manager has to create one", (Object)complex);
        Assert.assertEquals((Object)qName, (Object)complex.getQName());
        Assert.assertSame((String)"a further call has to return the same ComplexType", (Object)complex, (Object)this.manager.getComplexType(qName));
        Assert.assertSame((String)"a further call has to return the same ComplexType", (Object)complex, (Object)this.manager.getComplexType(qName.getNamespaceURI(), qName.getLocalPart()));
    }

    @Test
    public void testGetComplexTypeByTargetNamespaceAndLocalPart() {
        String targetNs = "http://my.own.namespace.org";
        String localPart = "PersonType";
        ComplexType complex = this.manager.getComplexType(targetNs, localPart);
        Assert.assertNotNull((String)"If this ComplexType does not exists the manager has to create one", (Object)complex);
        Assert.assertEquals((Object)targetNs, (Object)complex.getNamespace());
        Assert.assertEquals((Object)localPart, (Object)complex.getLocalPart());
        Assert.assertSame((String)"a further call has to return the same ComplexType", (Object)complex, (Object)this.manager.getComplexType(targetNs, localPart));
        Assert.assertSame((String)"a further call has to return the same ComplexType", (Object)complex, (Object)this.manager.getComplexType(new QName(targetNs, localPart)));
    }

    @Test
    public void testGetElementByQName() {
        QName qName = new QName("http://my.own.namespace.org", "person");
        Element element = this.manager.getElement(qName);
        Assert.assertNotNull((String)"If this Element does not exists the manager has to create one", (Object)element);
        Assert.assertEquals((Object)qName, (Object)element.getQName());
        Assert.assertSame((String)"a further call has to return the same Element", (Object)element, (Object)this.manager.getElement(qName));
        Assert.assertSame((String)"a further call has to return the same Element", (Object)element, (Object)this.manager.getElement(qName.getNamespaceURI(), qName.getLocalPart()));
    }

    @Test
    public void testGetElementByTargetNamespaceAndLocalPart() {
        String targetNs = "http://my.own.namespace.org";
        String localPart = "person";
        Element element = this.manager.getElement(targetNs, localPart);
        Assert.assertNotNull((String)"If this Element does not exists the manager has to create one", (Object)element);
        Assert.assertEquals((Object)targetNs, (Object)element.getNamespace());
        Assert.assertEquals((Object)localPart, (Object)element.getLocalPart());
        Assert.assertSame((String)"a further call has to return the same Element", (Object)element, (Object)this.manager.getElement(targetNs, localPart));
        Assert.assertSame((String)"a further call has to return the same Element", (Object)element, (Object)this.manager.getElement(new QName(targetNs, localPart)));
    }

    @Test
    public void testWasLastComplexCreated() throws Exception {
        this.manager.getComplexType("http://my.own.namespace.org", "person");
        Assert.assertTrue((boolean)this.manager.wasLastComplexNewCreated());
        this.manager.getComplexType("http://my.own.namespace.org", "person");
        Assert.assertFalse((boolean)this.manager.wasLastComplexNewCreated());
        this.manager.getComplexType("http://my.own.namespace.org", "person2");
        Assert.assertTrue((boolean)this.manager.wasLastComplexNewCreated());
        this.manager.getComplexType("http://my.own.namespace.org", "person2");
        Assert.assertFalse((boolean)this.manager.wasLastComplexNewCreated());
        this.manager.getComplexType("http://my.own.namespace.org", "person");
        Assert.assertFalse((boolean)this.manager.wasLastComplexNewCreated());
    }
}

