/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.fields;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeItemToolTip
implements Listener {
    private Shell tip = null;
    private Label label = null;
    private Listener labelListener;
    protected Tree tree;
    private String text = "";

    public TreeItemToolTip(Tree tree) {
        this.tree = tree;
        this.labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TreeItem)label.getData("_TABLEITEM");
                        TreeItemToolTip.this.tree.setSelection((TreeItem)e.item);
                        TreeItemToolTip.this.tree.notifyListeners(13, e);
                        shell.dispose();
                        TreeItemToolTip.this.tree.setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
    }

    public void handleEvent(Event event) {
        if ("".equals(this.text) || this.text == null) {
            return;
        }
        switch (event.type) {
            case 1: 
            case 5: 
            case 12: {
                if (this.tip == null) break;
                this.tip.dispose();
                this.tip = null;
                this.label = null;
                break;
            }
            case 32: {
                TreeItem item = this.tree.getItem(new Point(event.x, event.y));
                if (item == null) break;
                if (this.tip != null && !this.tip.isDisposed()) {
                    this.tip.dispose();
                }
                this.tip = new Shell(this.tree.getShell(), 540676);
                this.tip.setBackground(this.tree.getDisplay().getSystemColor(29));
                FillLayout layout = new FillLayout();
                layout.marginWidth = 2;
                this.tip.setLayout((Layout)layout);
                this.label = new Label((Composite)this.tip, 0);
                this.label.setForeground(this.tree.getDisplay().getSystemColor(28));
                this.label.setBackground(this.tree.getDisplay().getSystemColor(29));
                this.label.setData("_TABLEITEM", (Object)item);
                this.label.setText(this.getText());
                this.label.addListener(7, this.labelListener);
                this.label.addListener(3, this.labelListener);
                Point size = this.tip.computeSize(-1, -1);
                Point pt = this.tree.toDisplay(event.x, event.y);
                this.tip.setBounds(pt.x, pt.y + 20, size.x, size.y);
                this.tip.setVisible(true);
            }
        }
    }

    private String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

