/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.transform.TransformerException;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.xml.suite.XMLDeploymentSection;
import net.bpelunit.framework.xml.suite.XMLPartnerDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLPartnerTrack;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.framework.xml.suite.XMLTestSuiteDocument;
import net.bpelunit.framework.xml.suite.XMLTrack;
import net.bpelunit.toolsupport.ToolSupportActivator;
import net.bpelunit.toolsupport.editors.IModelChangedListener;
import net.bpelunit.toolsupport.editors.TestSuitePage;
import net.bpelunit.toolsupport.editors.src.XMLEditor;
import net.bpelunit.toolsupport.util.WSDLReadingException;
import net.bpelunit.toolsupport.util.schema.WSDLParser;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.xml.sax.SAXException;

public class BPELUnitEditor
extends FormEditor {
    private static final int VISUAL_PAGE = 0;
    private static final int SOURCE_PAGE = 1;
    private XMLTestSuiteDocument fDocument;
    private TestSuitePage fTestSuitePage;
    private XMLEditor fXmlEditorPage;
    private List<IModelChangedListener> fListeners = new ArrayList<IModelChangedListener>();
    private IProject fCurrentProject;
    private IContainer fCurrentDirectory;
    private Map<IFile, Definition> fWSDLDefinitions;
    private Map<Definition, WSDLParser> fWSDLParser;
    private int fFirstPage;

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        IFile baseFile = ((IFileEditorInput)editorInput).getFile();
        this.fCurrentProject = baseFile.getProject();
        this.fCurrentDirectory = baseFile.getParent();
        this.fWSDLDefinitions = new HashMap<IFile, Definition>();
        this.fWSDLParser = new HashMap<Definition, WSDLParser>();
        this.setPartName(baseFile.getName());
        if (!baseFile.exists()) {
            throw new PartInitException("Invalid Input: File " + baseFile + " does not exist.");
        }
        try {
            this.fDocument = XMLTestSuiteDocument.Factory.parse((Reader)new InputStreamReader(baseFile.getContents(), baseFile.getCharset()));
            if (this.needsBasicRestructuring(this.fDocument)) {
                this.fTestSuitePage.markDirty();
            }
            this.fFirstPage = 0;
        }
        catch (Exception exception) {
            this.fFirstPage = 1;
        }
        super.init(site, editorInput);
    }

    protected void addPages() {
        try {
            this.fTestSuitePage = new TestSuitePage(this, "testSuitePage", "Test Suite");
            this.addPage((IFormPage)this.fTestSuitePage);
            this.fXmlEditorPage = new XMLEditor();
            int index = this.addPage((IEditorPart)this.fXmlEditorPage, this.getEditorInput());
            this.setPageText(index, "Source");
            this.setActivePage(this.fFirstPage);
        }
        catch (PartInitException e) {
            ToolSupportActivator.log(e);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.preSave();
        this.fXmlEditorPage.doSave(monitor);
        this.postSave();
        super.editorDirtyStateChanged();
    }

    public void doSaveAs() {
        this.preSave();
        this.fXmlEditorPage.doSaveAs();
        this.setInput(this.fXmlEditorPage.getEditorInput());
        this.postSave();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        boolean canChange = true;
        if (newPageIndex == 1) {
            this.model2src(false);
        }
        if (newPageIndex == 0) {
            canChange = this.src2model(false);
        }
        if (canChange) {
            super.pageChange(newPageIndex);
        } else {
            this.setActivePage(1);
        }
    }

    private void postSave() {
        if (this.getCurrentPage() == 1) {
            this.src2model(true);
        }
    }

    private void preSave() {
        if (this.getCurrentPage() == 0) {
            this.fTestSuitePage.doSave((IProgressMonitor)new NullProgressMonitor());
            this.model2src(true);
        }
    }

    public XMLTestSuite getTestSuite() {
        XMLTestSuite testSuite = this.fDocument.getTestSuite();
        if (testSuite == null) {
            testSuite = this.fDocument.addNewTestSuite();
        }
        return testSuite;
    }

    private boolean src2model(boolean force) {
        if (force || this.isDirty() || this.fDocument == null) {
            IDocument document = this.fXmlEditorPage.getDocumentProvider().getDocument((Object)this.getEditorInput());
            String string = document.get();
            try {
                this.fDocument = XMLTestSuiteDocument.Factory.parse((String)string);
                if (this.needsBasicRestructuring(this.fDocument)) {
                    this.fTestSuitePage.markDirty();
                }
                for (IModelChangedListener listener : this.fListeners) {
                    listener.modelChanged();
                }
            }
            catch (Exception e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"Trouble parsing XML", (String)e.getMessage(), (IStatus)ToolSupportActivator.getErrorStatus(e));
                return false;
            }
        }
        return true;
    }

    private boolean needsBasicRestructuring(XMLTestSuiteDocument document) {
        XMLDeploymentSection deployment;
        XMLTestSuite suite;
        boolean changed = false;
        if (document.getTestSuite() == null) {
            document.addNewTestSuite();
            changed = true;
        }
        if ((suite = document.getTestSuite()).getDeployment() == null) {
            suite.addNewDeployment();
            changed = true;
        }
        if (suite.getTestCases() == null) {
            suite.addNewTestCases();
            changed = true;
        }
        if ((deployment = suite.getDeployment()).getPut() == null) {
            deployment.addNewPut();
            changed = true;
        }
        return changed;
    }

    private Shell getShell() {
        return this.fXmlEditorPage.getSite().getShell();
    }

    private void model2src(boolean force) {
        if ((force || this.isDirty()) && this.fDocument != null) {
            IDocument document = this.fXmlEditorPage.getDocumentProvider().getDocument((Object)this.getEditorInput());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                this.fDocument.save((OutputStream)output, BPELUnitUtil.getDefaultXMLOptions());
                document.set(output.toString());
            }
            catch (IOException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Error writing XML model to file", (IStatus)ToolSupportActivator.getErrorStatus(e));
            }
        }
    }

    public IProject getCurrentProject() {
        return this.fCurrentProject;
    }

    public IContainer getCurrentDirectory() {
        return this.fCurrentDirectory;
    }

    private String getPartnerWSDLString(XMLTrack track) {
        if (track instanceof XMLPartnerTrack) {
            XMLPartnerTrack partner = (XMLPartnerTrack)track;
            List partnerList = this.getTestSuite().getDeployment().getPartnerList();
            for (XMLPartnerDeploymentInformation information : partnerList) {
                if (!information.getName().equals(partner.getName())) continue;
                return information.getPartnerWsdl();
            }
        } else {
            return this.getTestSuite().getDeployment().getPut().getPartnerWSDL();
        }
        return null;
    }

    private String getWSDLString(XMLTrack track) {
        if (track instanceof XMLPartnerTrack) {
            XMLPartnerTrack partner = (XMLPartnerTrack)track;
            List partnerList = this.getTestSuite().getDeployment().getPartnerList();
            for (XMLPartnerDeploymentInformation information : partnerList) {
                if (!information.getName().equals(partner.getName())) continue;
                return information.getWsdl();
            }
        } else {
            return this.getTestSuite().getDeployment().getPut().getWsdl();
        }
        return null;
    }

    public Definition getWsdlForPartner(XMLTrack track) throws WSDLReadingException {
        String wsdl = this.getWSDLString(track);
        if (wsdl == null || "".equals(wsdl)) {
            return null;
        }
        return this.getWsdlForFile(wsdl);
    }

    public Definition getPartnerWsdlForPartner(XMLTrack track) throws WSDLReadingException {
        String wsdl = this.getPartnerWSDLString(track);
        if (wsdl == null || "".equals(wsdl)) {
            return null;
        }
        return this.getWsdlForFile(wsdl);
    }

    public Definition getWsdlForFile(String wsdl) throws WSDLReadingException {
        Path path = new Path(wsdl);
        IResource resource = null;
        resource = this.getCurrentDirectory().findMember(wsdl);
        if (this.notFound(resource)) {
            resource = this.getCurrentProject().findMember((IPath)path);
        }
        if (this.notFound(resource)) {
            resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        }
        if (this.notFound(resource)) {
            throw new WSDLReadingException("Cannot find WSDL file with file path " + wsdl);
        }
        IFile file = (IFile)resource;
        Definition definition = this.fWSDLDefinitions.get(file);
        if (definition == null) {
            String fileName = file.getRawLocation().toFile().toString();
            try {
                WSDLFactory factory = WSDLFactory.newInstance();
                WSDLReader reader = factory.newWSDLReader();
                definition = reader.readWSDL(null, fileName);
                this.fWSDLDefinitions.put(file, definition);
                WSDLParser parser = new WSDLParser(definition);
                this.fWSDLParser.put(definition, parser);
            }
            catch (WSDLException e) {
                throw new WSDLReadingException("Error loading WSDL file for partner", e);
            }
            catch (SAXException e) {
                MessageDialog dialog = new MessageDialog(this.getShell(), "Invalid Schema", null, e.getMessage(), 1, new String[]{"OK"}, 0);
                dialog.open();
                throw new WSDLReadingException("Error reading Schemata in WSDL: " + e.getMessage(), e);
            }
            catch (TransformerException e) {
                MessageDialog dialog = new MessageDialog(this.getShell(), "Invalid Schema", null, e.getMessage(), 1, new String[]{"OK"}, 0);
                dialog.open();
                throw new WSDLReadingException("Error reading Schemata in WSDL: " + e.getMessage(), e);
            }
        }
        return definition;
    }

    public WSDLParser getWSDLParserForDefinition(Definition definition) {
        return this.fWSDLParser.get(definition);
    }

    private boolean notFound(IResource resource) {
        return resource == null || !resource.exists() || !(resource instanceof IFile);
    }

    public void addModelChangedListener(IModelChangedListener listener) {
        this.fListeners.add(listener);
    }

    public void removeModelChangedListener(IModelChangedListener listener) {
        this.fListeners.remove(listener);
    }

    public void refresh() {
        if (this.getActivePage() == 0) {
            IFormPart[] iFormPartArray = this.fTestSuitePage.getManagedForm().getParts();
            int n = iFormPartArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPart part = iFormPartArray[n2];
                part.refresh();
                ++n2;
            }
        }
    }
}

