/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxEvent;
import com.box.boxjavalibv2.dao.BoxEventCollection;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.interfaces.IBoxJSONParser;
import com.box.boxjavalibv2.interfaces.IBoxResourceHub;
import com.box.boxjavalibv2.requests.EventOptionsRequest;
import com.box.boxjavalibv2.requests.GetEventsRequest;
import com.box.boxjavalibv2.requests.requestobjects.BoxDefaultRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxEventRequestObject;
import com.box.boxjavalibv2.resourcemanagers.BoxResourceManager;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxConfig;
import com.box.restclientv2.interfaces.IBoxRESTClient;
import com.box.restclientv2.interfaces.IBoxRequestAuth;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxEventsManager
extends BoxResourceManager {
    public BoxEventsManager(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, auth, restClient);
    }

    public BoxEventCollection getEvents(BoxEventRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetEventsRequest request = new GetEventsRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxEventCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.EVENTS, this.getJSONParser());
    }

    public BoxCollection getEventOptions(BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        EventOptionsRequest request = new EventOptionsRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.ITEMS, this.getJSONParser());
    }

    public static List<BoxEvent> getEvents(BoxCollection collection) {
        ArrayList<BoxEvent> events = new ArrayList<BoxEvent>();
        ArrayList<BoxTypedObject> list = collection.getEntries();
        for (BoxTypedObject object : list) {
            if (!(object instanceof BoxEvent)) continue;
            events.add((BoxEvent)object);
        }
        return events;
    }
}

