/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.requests.requestobjects;

import com.box.boxjavalibv2.exceptions.BoxJSONException;
import com.box.boxjavalibv2.httpentities.MultipartEntityWithProgressListener;
import com.box.boxjavalibv2.interfaces.IBoxJSONParser;
import com.box.boxjavalibv2.interfaces.IFileTransferListener;
import com.box.boxjavalibv2.jsonentities.MapJSONStringEntity;
import com.box.boxjavalibv2.requests.requestobjects.BoxDefaultRequestObject;
import com.box.boxjavalibv2.utils.ISO8601DateParser;
import com.box.restclientv2.exceptions.BoxRestException;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;

public class BoxFileUploadRequestObject
extends BoxDefaultRequestObject {
    private static final String METADATA = "metadata";
    private MultipartEntityWithProgressListener entity = null;
    private static final String KEY_PARENT = "parent";
    private static final String KEY_NAME = "name";
    private static final String KEY_FILE_NAME = "filename";
    private static final String KEY_CONTENT_CREATED_AT = "content_created_at";
    private static final String KEY_CONTENT_MODIFIED_AT = "content_modified_at";

    private BoxFileUploadRequestObject() {
    }

    public static BoxFileUploadRequestObject uploadFileRequestObject(String parentId, String fileName, File file, IBoxJSONParser parser) throws BoxRestException, BoxJSONException {
        try {
            BoxFileUploadRequestObject requestObject = new BoxFileUploadRequestObject();
            return requestObject.setMultipartMIME(BoxFileUploadRequestObject.getNewFileMultipartEntity(parentId, fileName, file, parser));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public static BoxFileUploadRequestObject uploadFileRequestObject(String parentId, String fileName, InputStream inputStream) throws BoxRestException {
        try {
            return new BoxFileUploadRequestObject().setMultipartMIME(BoxFileUploadRequestObject.getNewFileMultipartEntity(parentId, inputStream, fileName));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public static BoxFileUploadRequestObject uploadNewVersionRequestObject(String name, File file) throws BoxRestException {
        try {
            return new BoxFileUploadRequestObject().setMultipartMIME(BoxFileUploadRequestObject.getNewVersionMultipartEntity(name, file));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public static BoxFileUploadRequestObject uploadNewVersionRequestObject(String name, InputStream inputStream) throws BoxRestException {
        try {
            return new BoxFileUploadRequestObject().setMultipartMIME(BoxFileUploadRequestObject.getNewVersionMultipartEntity(name, inputStream));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public BoxFileUploadRequestObject setMultipartMIME(MultipartEntityWithProgressListener mime) throws BoxRestException {
        this.entity = mime;
        return this;
    }

    public BoxFileUploadRequestObject setListener(IFileTransferListener listener) {
        this.entity.setListener(listener);
        return this;
    }

    public BoxFileUploadRequestObject setContentMD5(String sha1) {
        this.addHeader("Content-MD5", sha1);
        return this;
    }

    public BoxFileUploadRequestObject setLocalFileCreatedAt(Date createdAt) throws UnsupportedEncodingException {
        this.entity.addPart(KEY_CONTENT_CREATED_AT, (ContentBody)new StringBody(ISO8601DateParser.toString(createdAt)));
        return this;
    }

    public BoxFileUploadRequestObject setLocalFileLastModifiedAt(Date modifiedAt) throws UnsupportedEncodingException {
        this.entity.addPart(KEY_CONTENT_MODIFIED_AT, (ContentBody)new StringBody(ISO8601DateParser.toString(modifiedAt)));
        return this;
    }

    public BoxFileUploadRequestObject setIfMatch(String etag) {
        this.addHeader("If-Match", etag);
        return this;
    }

    public HttpEntity getEntity() {
        this.entity.prepareParts();
        return this.entity;
    }

    private static MultipartEntityWithProgressListener getNewFileMultipartEntity(String parentId, InputStream inputStream, String fileName) throws BoxRestException, UnsupportedEncodingException {
        MultipartEntityWithProgressListener me = new MultipartEntityWithProgressListener(HttpMultipartMode.BROWSER_COMPATIBLE);
        me.addPart("folder_id", (ContentBody)new StringBody(parentId));
        String date = ISO8601DateParser.toString(new Date());
        if (me.getPart(KEY_CONTENT_CREATED_AT) == null) {
            me.addPart(KEY_CONTENT_CREATED_AT, (ContentBody)new StringBody(date));
        }
        if (me.getPart(KEY_CONTENT_MODIFIED_AT) == null) {
            me.addPart(KEY_CONTENT_MODIFIED_AT, (ContentBody)new StringBody(date));
        }
        me.addPart(fileName, (ContentBody)new InputStreamBody(inputStream, fileName));
        return me;
    }

    private static MultipartEntityWithProgressListener getNewFileMultipartEntity(String parentId, String name, File file, IBoxJSONParser parser) throws BoxRestException, UnsupportedEncodingException, BoxJSONException {
        MultipartEntityWithProgressListener me = new MultipartEntityWithProgressListener(HttpMultipartMode.BROWSER_COMPATIBLE);
        me.addPart("folder_id", (ContentBody)new StringBody(parentId));
        me.addPart(KEY_FILE_NAME, (ContentBody)new FileBody(file, KEY_FILE_NAME, "", "UTF-8"));
        me.addPart(METADATA, (ContentBody)BoxFileUploadRequestObject.getMetadataBody(parentId, name, parser));
        String date = ISO8601DateParser.toString(new Date(file.lastModified()));
        if (me.getPart(KEY_CONTENT_CREATED_AT) == null) {
            me.addPart(KEY_CONTENT_CREATED_AT, (ContentBody)new StringBody(date));
        }
        if (me.getPart(KEY_CONTENT_MODIFIED_AT) == null) {
            me.addPart(KEY_CONTENT_MODIFIED_AT, (ContentBody)new StringBody(date));
        }
        return me;
    }

    private static StringBody getMetadataBody(String parentId, String name, IBoxJSONParser parser) throws UnsupportedEncodingException, BoxRestException, BoxJSONException {
        MapJSONStringEntity parentEntity = new MapJSONStringEntity();
        parentEntity.put("id", parentId);
        MapJSONStringEntity entity = new MapJSONStringEntity();
        entity.put(KEY_PARENT, parentEntity);
        entity.put(KEY_NAME, name);
        return new StringBody(entity.toJSONString(parser), Charset.forName("UTF-8"));
    }

    private static MultipartEntityWithProgressListener getNewVersionMultipartEntity(String name, File file) throws UnsupportedEncodingException {
        MultipartEntityWithProgressListener me = new MultipartEntityWithProgressListener(HttpMultipartMode.BROWSER_COMPATIBLE);
        me.addPart(name, (ContentBody)new FileBody(file, name, "", "UTF-8"));
        if (me.getPart(KEY_CONTENT_MODIFIED_AT) == null) {
            me.addPart(KEY_CONTENT_MODIFIED_AT, (ContentBody)new StringBody(ISO8601DateParser.toString(new Date(file.lastModified()))));
        }
        return me;
    }

    private static MultipartEntityWithProgressListener getNewVersionMultipartEntity(String name, InputStream inputStream) throws UnsupportedEncodingException {
        MultipartEntityWithProgressListener me = new MultipartEntityWithProgressListener(HttpMultipartMode.BROWSER_COMPATIBLE);
        me.addPart(name, (ContentBody)new InputStreamBody(inputStream, name));
        if (me.getPart(KEY_CONTENT_MODIFIED_AT) == null) {
            me.addPart(KEY_CONTENT_MODIFIED_AT, (ContentBody)new StringBody(ISO8601DateParser.toString(new Date())));
        }
        return me;
    }
}

