/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.dao;

import com.box.boxjavalibv2.dao.BoxFolder;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import com.box.boxjavalibv2.dao.BoxUser;
import com.box.boxjavalibv2.dao.BoxUserBase;
import com.box.boxjavalibv2.interfaces.IBoxParcelWrapper;
import com.box.boxjavalibv2.utils.ISO8601DateParser;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxCollaboration
extends BoxTypedObject {
    public static final String FIELD_CREATED_BY = "created_by";
    public static final String FIELD_EXPIRES_AT = "expires_at";
    public static final String FIELD_ACCESSIBLE_BY = "accessible_by";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_ACKNOWLEGED_AT = "acknowledged_at";
    public static final String FIELD_FOLDER = "item";
    public static final String FIELD_ROLE = "role";
    public static final String STATUS_ACCEPTED = "accepted";
    public static final String STATUS_PENDING = "pending";
    public static final String STATUS_REJECTED = "rejected";

    public BoxCollaboration() {
        this.setType(BoxResourceType.COLLABORATION.toString());
    }

    public BoxCollaboration(BoxCollaboration obj) {
        super(obj);
    }

    public BoxCollaboration(Map<String, Object> map) {
        super(map);
    }

    @JsonProperty(value="created_by")
    public BoxUser getCreatedBy() {
        return (BoxUser)this.getValue(FIELD_CREATED_BY);
    }

    @JsonProperty(value="created_by")
    private void setCreatedBy(BoxUser createdBy) {
        this.put(FIELD_CREATED_BY, createdBy);
    }

    @JsonProperty(value="accessible_by")
    private void setAccessibleBy(BoxUserBase accessibleBy) {
        this.put(FIELD_ACCESSIBLE_BY, accessibleBy);
    }

    @JsonProperty(value="accessible_by")
    public BoxUserBase getAccessibleBy() {
        return (BoxUserBase)this.getValue(FIELD_ACCESSIBLE_BY);
    }

    @JsonProperty(value="expires_at")
    public String getExpiresAt() {
        return (String)this.getValue(FIELD_EXPIRES_AT);
    }

    public Date dateExpiresAt() throws ParseException {
        return ISO8601DateParser.parseSilently(this.getExpiresAt());
    }

    @JsonProperty(value="expires_at")
    private void setExpiresAt(String expiresAt) {
        this.put(FIELD_EXPIRES_AT, expiresAt);
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return (String)this.getValue(FIELD_STATUS);
    }

    @JsonProperty(value="status")
    private void setStatus(String status) {
        this.put(FIELD_STATUS, status);
    }

    @JsonProperty(value="role")
    public String getRole() {
        return (String)this.getValue(FIELD_ROLE);
    }

    @JsonProperty(value="role")
    private void setRole(String role) {
        this.put(FIELD_ROLE, role);
    }

    @JsonProperty(value="acknowledged_at")
    public String getAcknowledgedAt() {
        return (String)this.getValue(FIELD_ACKNOWLEGED_AT);
    }

    @JsonProperty(value="acknowledged_at")
    private void setAcknowledgedAt(String acknowledgedAt) {
        this.put(FIELD_ACKNOWLEGED_AT, acknowledgedAt);
    }

    @JsonProperty(value="item")
    public BoxFolder getFolder() {
        return (BoxFolder)this.getValue(FIELD_FOLDER);
    }

    @JsonProperty(value="item")
    private void setFolder(BoxFolder item) {
        this.put(FIELD_FOLDER, item);
    }

    public BoxCollaboration(IBoxParcelWrapper in) {
        super(in);
    }
}

