/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2;

import com.box.restclientv2.interfaces.IBoxConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxConfig
implements IBoxConfig {
    private static final String API_URL_SCHEME = "https";
    private static final String API_URL_AUTHORITY = "api.box.com";
    private static final String API_URL_PATH = "/2.0";
    private static final String UPLOAD_URL_SCHEME = "https";
    private static final String UPLOAD_URL_AUTHORITY = "upload.box.com";
    private static final String UPLOAD_URL_PATH = "/api/2.0";
    private static final String OAUTH_URL_SCHEME = "https";
    private static final String OAUTH_URL_AUTHORITY = "www.box.com";
    private static final String OAUTH_API_URL_PATH = "/api";
    private static final String OAUTH_WEB_URL_PATH = "/api/oauth2/authorize";
    private static final String DOWNLOAD_URL_SCHEME = "https";
    private static final String DOWNLOAD_URL_AUTHORITY = "api.box.com";
    private static final String DOWNLOAD_URL_PATH = "/2.0";
    private static final String USER_AGENT = "BoxJavaLibraryV2";
    private String mOAuthUrlScheme = "https";
    private String mOAuthUrlAuthority = "www.box.com";
    private String mOAuthApiUrlPath = "/api";
    private String mOAuthWebUrlPath = "/api/oauth2/authorize";
    private String mApiUrlScheme = "https";
    private String mApiUrlAuthority = "api.box.com";
    private String mApiUrlPath = "/2.0";
    private String mUploadUrlScheme = "https";
    private String mUploadUrlAuthority = "upload.box.com";
    private String mUploadUrlPath = "/api/2.0";
    private String mDownloadUrlScheme = "https";
    private String mDownloadUrlAuthority = "api.box.com";
    private String mDownloadUrlPath = "/2.0";
    private String mUserAgent = "BoxJavaLibraryV2";
    private boolean mEnableHttpLogging = false;
    private static int mConnectionTimout = 0;
    private final List<BasicNameValuePair> mCustomQueryParams = new ArrayList<BasicNameValuePair>();
    private static BoxConfig mInstance;
    private static final String ENGLISH_ACCEPT_LANGUAGE = "en-us";

    protected BoxConfig() {
    }

    public static BoxConfig getInstance() {
        if (mInstance == null) {
            mInstance = new BoxConfig();
        }
        return mInstance;
    }

    public void setApiUrlScheme(String scheme) {
        this.mApiUrlScheme = scheme;
    }

    @Override
    public String getApiUrlScheme() {
        return this.mApiUrlScheme;
    }

    public void setApiUrlAuthority(String authority) {
        this.mApiUrlAuthority = authority;
    }

    @Override
    public String getApiUrlAuthority() {
        return this.mApiUrlAuthority;
    }

    public void setApiUrlPath(String path) {
        this.mApiUrlPath = path;
    }

    @Override
    public String getApiUrlPath() {
        return this.mApiUrlPath;
    }

    public void setUploadUrlScheme(String scheme) {
        this.mUploadUrlScheme = scheme;
    }

    @Override
    public String getUploadUrlScheme() {
        return this.mUploadUrlScheme;
    }

    public void setUploadUrlAuthority(String authority) {
        this.mUploadUrlAuthority = authority;
    }

    @Override
    public String getUploadUrlAuthority() {
        return this.mUploadUrlAuthority;
    }

    public void setDownloadUrlScheme(String scheme) {
        this.mDownloadUrlScheme = scheme;
    }

    @Override
    public String getDownloadUrlScheme() {
        return this.mDownloadUrlScheme;
    }

    public void setDownloadUrlAuthority(String authority) {
        this.mDownloadUrlAuthority = authority;
    }

    @Override
    public String getDownloadUrlAuthority() {
        return this.mDownloadUrlAuthority;
    }

    public void setConnectionTimeOut(int timeout) {
        mConnectionTimout = timeout;
    }

    @Override
    public int getConnectionTimeOut() {
        return mConnectionTimout;
    }

    public void setUserAgent(String agent) {
        this.mUserAgent = agent;
    }

    @Override
    public String getUserAgent() {
        return this.mUserAgent;
    }

    @Override
    public String getOAuthUrlScheme() {
        return this.mOAuthUrlScheme;
    }

    public void setAuthUrlScheme(String oAuthUrlScheme) {
        this.mOAuthUrlScheme = oAuthUrlScheme;
    }

    @Override
    public String getOAuthUrlAuthority() {
        return this.mOAuthUrlAuthority;
    }

    public void setOAuthUrlAuthority(String oAuthUrlAuthority) {
        this.mOAuthUrlAuthority = oAuthUrlAuthority;
    }

    @Override
    public String getOAuthWebUrlPath() {
        return this.mOAuthWebUrlPath;
    }

    public void setOAuthUrlPath(String oAuthUrlPath) {
        this.mOAuthWebUrlPath = oAuthUrlPath;
    }

    public void appendCustomQueryParameterToAllRequests(String key, String value) {
        this.mCustomQueryParams.add(new BasicNameValuePair(key, value));
    }

    public void clearCustomQueryParameters() {
        this.mCustomQueryParams.clear();
    }

    public List<BasicNameValuePair> getCustomQueryParameters() {
        return Collections.unmodifiableList(this.mCustomQueryParams);
    }

    public void setEnableHttpLogging(boolean flag) {
        this.mEnableHttpLogging = flag;
    }

    public boolean getHttpLoggingEnabled() {
        return this.mEnableHttpLogging;
    }

    @Override
    public String getAcceptLanguage() {
        if (Locale.getDefault() == null) {
            return ENGLISH_ACCEPT_LANGUAGE;
        }
        StringBuffer sb = new StringBuffer();
        String language = Locale.getDefault().getLanguage().toLowerCase().trim();
        if (language.length() > 0) {
            sb.append(language);
            String country = Locale.getDefault().getCountry().toLowerCase().trim();
            if (country.length() > 0) {
                sb.append("-");
                sb.append(country);
            }
        }
        if (sb.length() == 0) {
            sb.append(ENGLISH_ACCEPT_LANGUAGE);
        } else if (!sb.toString().equals(ENGLISH_ACCEPT_LANGUAGE)) {
            sb.append(", ");
            sb.append(ENGLISH_ACCEPT_LANGUAGE);
        }
        return sb.toString();
    }

    @Override
    public String getOAuthApiUrlPath() {
        return this.mOAuthApiUrlPath;
    }

    public void setOAuthApiUrlPath(String oAuthApiUrlPath) {
        this.mOAuthApiUrlPath = oAuthApiUrlPath;
    }

    @Override
    public String getUploadUrlPath() {
        return this.mUploadUrlPath;
    }

    public void setUploadUrlPath(String uploadUrlPath) {
        this.mUploadUrlPath = uploadUrlPath;
    }

    @Override
    public String getDownloadUrlPath() {
        return this.mDownloadUrlPath;
    }

    public void setDownloadUrlPath(String downloadUrlPath) {
        this.mDownloadUrlPath = downloadUrlPath;
    }
}

