/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.authorize.util.LogHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtility {
    private static Logger logger = LogManager.getLogger(XmlUtility.class);
    private static final String XmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    private static JAXBContext request_ctx = null;
    private static JAXBContext response_ctx = null;
    private static HashMap<String, JAXBContext> jaxbContext = new HashMap();

    private XmlUtility() {
    }

    public static synchronized <T extends Serializable> String getXml(T entity) throws IOException, JAXBException {
        StringWriter sw = new StringWriter();
        if (null != entity) {
            if (!jaxbContext.containsKey(entity.getClass().toString())) {
                request_ctx = JAXBContext.newInstance((Class[])new Class[]{entity.getClass()});
                jaxbContext.put(entity.getClass().toString(), request_ctx);
            } else {
                request_ctx = jaxbContext.get(entity.getClass().toString());
            }
            if (request_ctx != null) {
                Marshaller m = request_ctx.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)true);
                m.marshal(entity, (Writer)sw);
            }
        }
        sw.flush();
        sw.close();
        return sw.toString();
    }

    public static synchronized <T extends Serializable> T create(String xml, Class<T> classType) throws ParserConfigurationException, SAXException, JAXBException {
        Serializable entity = null;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(true);
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        SAXSource xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(new StringReader(xml)));
        if (null != xml && !xml.trim().isEmpty()) {
            if (!jaxbContext.containsKey(classType.toString())) {
                response_ctx = JAXBContext.newInstance((Class[])new Class[]{classType});
                jaxbContext.put(classType.toString(), response_ctx);
            } else {
                response_ctx = jaxbContext.get(classType.toString());
            }
            if (response_ctx != null) {
                Unmarshaller um = response_ctx.createUnmarshaller();
                try {
                    Object unmarshaled = um.unmarshal((Source)xmlSource);
                    if (null != unmarshaled) {
                        try {
                            entity = (Serializable)classType.cast(unmarshaled);
                        }
                        catch (ClassCastException cce) {
                            JAXBElement element;
                            if (unmarshaled instanceof JAXBElement && null != (element = (JAXBElement)unmarshaled).getValue() && element.getValue().getClass() == classType) {
                                entity = (Serializable)element.getValue();
                            }
                        }
                    }
                }
                catch (JAXBException jaxbe) {
                    LogHelper.info(logger, "Exception - while deserializing text:'%s' ", xml);
                    LogHelper.warn(logger, "Exception Details-> Code:'%s', Message:'%s'", jaxbe.getErrorCode(), jaxbe.getMessage());
                    throw jaxbe;
                }
            }
        }
        return (T)entity;
    }

    public static String escapeStringForXml(String valueToSerialize) {
        String retVal = valueToSerialize;
        if (null != valueToSerialize && valueToSerialize.length() > 0) {
            try {
                XmlString value = new XmlString(valueToSerialize);
                String xmlString = XmlUtility.getXml(value);
                int begin = xmlString.indexOf("<xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>") + "<xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>".length();
                int end = xmlString.indexOf("</xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>");
                if (begin >= 0 && end >= 0) {
                    retVal = xmlString.substring(begin, end);
                }
            }
            catch (Exception e) {
                LogHelper.warn(logger, "Error encoding to XML, value: '%s', ErrorMessage: '%s'", valueToSerialize, e.getMessage());
                retVal = valueToSerialize;
            }
        }
        return retVal;
    }

    public static String descapeStringForXml(String valueToDeserialize) {
        String retVal = valueToDeserialize;
        if (null != valueToDeserialize && valueToDeserialize.length() > 0) {
            try {
                StringBuilder value = new StringBuilder();
                value.append("<xmlString>").append("<xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>");
                value.append(valueToDeserialize);
                value.append("</xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>").append("</xmlString>");
                XmlString xmlString = XmlUtility.create(value.toString(), XmlString.class);
                if (null != xmlString) {
                    retVal = xmlString.getXmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue();
                }
            }
            catch (Exception e) {
                LogHelper.warn(logger, "Error decoding from XML, value: '%s', ErrorMessage: '%s'", valueToDeserialize, e.getMessage());
                retVal = valueToDeserialize;
            }
        }
        return retVal;
    }

    public static <T extends Serializable> String getRootElementXml(T entity) {
        String rootElementXml;
        try {
            String xml = XmlUtility.getXml(entity);
            rootElementXml = XmlUtility.getRootElementXml(xml);
        }
        catch (Exception e) {
            LogHelper.warn(logger, "Unable to serialize into xml: '%s'", entity);
            rootElementXml = String.format("<%s/>", entity.getClass().getSimpleName());
        }
        return rootElementXml;
    }

    public static String getRootElementXml(String xmlString) {
        return xmlString.replace(XmlHeader, "");
    }

    @XmlRootElement
    static class XmlString
    implements Serializable {
        public static final String VALUE_BEGIN = "<xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>";
        public static final String VALUE_END = "</xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue>";
        public static final String CLASS_BEGIN = "<xmlString>";
        public static final String CLASS_END = "</xmlString>";
        private static final long serialVersionUID = 1L;
        String xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue = null;

        XmlString() {
        }

        XmlString(String value) {
            this.setXmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue(value);
        }

        public String getXmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue() {
            return this.xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue;
        }

        public void setXmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue(String value) {
            this.xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue = value;
        }

        public String toString() {
            return this.xmlStringValueUnlikelyToBeElementUsedInRealXmlStringValue;
        }
    }
}

