/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import net.authorize.Environment;
import net.authorize.util.LogHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;

public class HttpClient {
    private static Log logger = LogFactory.getLog(HttpClient.class);
    public static final String ENCODING = "UTF-8";
    static boolean proxySet = false;
    static boolean UseProxy = Environment.getBooleanProperty("https.proxyUse");
    static String ProxyHost = Environment.getProperty("https.proxyHost");
    static int ProxyPort = Environment.getIntProperty("https.proxyPort");
    static String proxyUsername = Environment.getProperty("https.proxyUsername");
    static String proxyPassword = Environment.getProperty("https.proxyPassword");
    static int httpConnectionTimeout = Environment.getIntProperty("http.ConnectionTimeout");
    static int httpReadTimeout = Environment.getIntProperty("http.ReadTimeout");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Deprecated
    public static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block23: {
            BufferedReader reader;
            block21: {
                String line;
                reader = new BufferedReader(new InputStreamReader(is));
                sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                if (null == reader) break block21;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LogHelper.warn(logger, "Exception closing BufferedReader: '%s'", e.getMessage());
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LogHelper.warn(logger, "Exception closing InputStream: '%s'", e.getMessage());
                }
            }
            break block23;
            catch (IOException e) {
                block22: {
                    try {
                        LogHelper.warn(logger, "Exception reading data from Stream: '%s'", e.getMessage());
                        if (null == reader) break block22;
                    }
                    catch (Throwable throwable) {
                        if (null != reader) {
                            try {
                                reader.close();
                            }
                            catch (IOException e2) {
                                LogHelper.warn(logger, "Exception closing BufferedReader: '%s'", e2.getMessage());
                            }
                        }
                        if (null != is) {
                            try {
                                is.close();
                            }
                            catch (IOException e3) {
                                LogHelper.warn(logger, "Exception closing InputStream: '%s'", e3.getMessage());
                            }
                        }
                        throw throwable;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException e4) {
                        LogHelper.warn(logger, "Exception closing BufferedReader: '%s'", e4.getMessage());
                    }
                }
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException e5) {
                        LogHelper.warn(logger, "Exception closing InputStream: '%s'", e5.getMessage());
                    }
                }
            }
        }
        return sb.toString();
    }

    private static SSLContext getSSLContext() {
        try {
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            sc.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
            return sc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static CloseableHttpClient getHttpsClient() throws Exception {
        SSLContext sslcontext = HttpClient.getSSLContext();
        try {
            CloseableHttpClient httpClient;
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(httpConnectionTimeout).build();
            if (UseProxy && ProxyHost != null) {
                HttpClientBuilder hcBuilder;
                if (proxyUsername != null && proxyPassword != null) {
                    LogHelper.info(logger, "Setting up proxy to URL with Authentication: '%s://%s@%s:%d'", "http", proxyUsername, ProxyHost, ProxyPort);
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    AuthScope proxyScope = new AuthScope(ProxyHost, ProxyPort);
                    UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                    credsProvider.setCredentials(proxyScope, (Credentials)proxyCreds);
                    hcBuilder = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setDefaultRequestConfig(requestConfig).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                } else {
                    LogHelper.info(logger, "Setting up proxy to URL: '%s://%s:%d'", "http", ProxyHost, ProxyPort);
                    hcBuilder = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setDefaultRequestConfig(requestConfig).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
                }
                HttpHost httpProxy = new HttpHost(ProxyHost, ProxyPort, "http");
                hcBuilder.setProxy(httpProxy);
                httpClient = hcBuilder.build();
                proxySet = true;
            } else {
                LogHelper.warn(logger, "Defaulting to non-proxy environment", new Object[0]);
                httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setDefaultRequestConfig(requestConfig).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
            }
            return httpClient;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        LogHelper.info(logger, "Use Proxy: '%s'", UseProxy);
        httpConnectionTimeout = httpConnectionTimeout == 0 ? 30000 : httpConnectionTimeout;
        httpReadTimeout = httpReadTimeout == 0 ? 30000 : httpReadTimeout;
    }
}

