/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.sim;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.authorize.AuthNetField;
import net.authorize.Environment;
import net.authorize.Merchant;
import net.authorize.TransactionType;
import net.authorize.sim.Fingerprint;
import net.authorize.sim.button.Button;
import net.authorize.sim.button.ImageButton;
import net.authorize.sim.button.TextButton;
import net.authorize.sim.data.HostedPaymentFormSettings;
import net.authorize.sim.data.HostedReceiptPageSettings;
import net.authorize.util.LogHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class Transaction
extends net.authorize.aim.Transaction {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(Transaction.class);
    public static final int MAX_RECEIPT_LINK_TEXT_LENGTH = 50;
    public static final String PAYMENT_FORM = "PAYMENT_FORM";
    private LinkedHashMap<String, String> formInputMap = new LinkedHashMap();
    private Map<String, String> fieldsToRename = new HashMap<String, String>();
    private Fingerprint fingerprint;
    private HostedPaymentFormSettings hostedPaymentFormSettings;
    private HostedReceiptPageSettings hostedReceiptPageSettings;
    private Environment environment;

    protected Transaction(Merchant merchant, TransactionType transactionType, BigDecimal amount) {
        super(merchant, transactionType, amount);
        this.requestMap.remove(AuthNetField.X_TRAN_KEY.getFieldName());
        this.requestMap.put(AuthNetField.X_DELIM_DATA.getFieldName(), "FALSE");
        this.environment = merchant.getEnvironment();
    }

    public static Transaction createTransaction(Merchant merchant, TransactionType transactionType, long fingerPrintSequence, BigDecimal amount) {
        Transaction transaction = new Transaction(merchant, transactionType, amount);
        transaction.fingerprint = Fingerprint.createFingerprint(merchant, fingerPrintSequence, amount);
        transaction.requestMap.put(AuthNetField.X_FP_SEQUENCE.getFieldName(), Long.toString(transaction.fingerprint.getSequence()));
        transaction.requestMap.put(AuthNetField.X_FP_TIMESTAMP.getFieldName(), Long.toString(transaction.fingerprint.getTimeStamp()));
        transaction.requestMap.put(AuthNetField.X_FP_HASH.getFieldName(), transaction.fingerprint.getFingerprintHash());
        return transaction;
    }

    public Fingerprint getFingerprint() {
        return this.fingerprint;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setShowPaymentForm(boolean showForm) {
        if (showForm) {
            this.requestMap.put(AuthNetField.X_SHOW_FORM.getFieldName(), PAYMENT_FORM);
        } else {
            this.requestMap.remove(AuthNetField.X_SHOW_FORM.getFieldName());
        }
    }

    public boolean isShowPaymentForm() {
        return this.requestMap.containsKey(AuthNetField.X_SHOW_FORM.getFieldName()) && PAYMENT_FORM.equals(this.requestMap.get(AuthNetField.X_SHOW_FORM.getFieldName()));
    }

    public Map<String, String> getFormInputs() {
        return this.formInputMap;
    }

    public void addFormInput(String inputName, String htmlInputData) {
        this.formInputMap.put(inputName, htmlInputData);
    }

    public void setFormInputs(LinkedHashMap<String, String> formInputs) {
        this.formInputMap = formInputs;
    }

    public HostedPaymentFormSettings getHostedPaymentFormSettings() {
        return this.hostedPaymentFormSettings;
    }

    public void setHostedPaymentFormSettings(HostedPaymentFormSettings hostedPaymentFormSettings) {
        this.hostedPaymentFormSettings = hostedPaymentFormSettings;
        if (hostedPaymentFormSettings != null) {
            this.requestMap.put(AuthNetField.X_HEADER_HTML_PAYMENT_FORM.getFieldName(), hostedPaymentFormSettings.getHeader() != null ? hostedPaymentFormSettings.getHeader() : "");
            this.requestMap.put(AuthNetField.X_FOOTER_HTML_PAYMENT_FORM.getFieldName(), hostedPaymentFormSettings.getFooter() != null ? hostedPaymentFormSettings.getFooter() : "");
            this.requestMap.put(AuthNetField.X_COLOR_BACKGROUND.getFieldName(), hostedPaymentFormSettings.getBackgroundColor() != null ? hostedPaymentFormSettings.getBackgroundColor() : "");
            this.requestMap.put(AuthNetField.X_COLOR_LINK.getFieldName(), hostedPaymentFormSettings.getLinkColor() != null ? hostedPaymentFormSettings.getLinkColor() : "");
            this.requestMap.put(AuthNetField.X_COLOR_TEXT.getFieldName(), hostedPaymentFormSettings.getTextColor() != null ? hostedPaymentFormSettings.getTextColor() : "");
            this.requestMap.put(AuthNetField.X_LOGO_URL.getFieldName(), hostedPaymentFormSettings.getMerchantLogoUrl() != null ? hostedPaymentFormSettings.getMerchantLogoUrl() : "");
            this.requestMap.put(AuthNetField.X_BACKGROUND_URL.getFieldName(), hostedPaymentFormSettings.getBackgroundUrl() != null ? hostedPaymentFormSettings.getBackgroundUrl() : "");
        }
    }

    public Map<String, String> getFieldsToRename() {
        return this.fieldsToRename;
    }

    public void setFieldsToRename(Map<String, String> fieldsToRename) {
        this.fieldsToRename = fieldsToRename;
        this.requestMap.put(AuthNetField.X_RENAME.getFieldName(), "");
    }

    public void addFieldToRename(String fieldToRename, String replacementName) {
        this.fieldsToRename.put(fieldToRename, replacementName);
        this.requestMap.put(AuthNetField.X_RENAME.getFieldName(), "");
    }

    public HostedReceiptPageSettings getHostedReceiptPageSettings() {
        return this.hostedReceiptPageSettings;
    }

    public void setHostedReceiptPageSettings(HostedReceiptPageSettings hostedReceiptPageSettings) {
        this.hostedReceiptPageSettings = hostedReceiptPageSettings;
        if (hostedReceiptPageSettings != null) {
            if (hostedReceiptPageSettings.getLinkMethod() != null) {
                this.requestMap.put(AuthNetField.X_RECEIPT_LINK_METHOD.getFieldName(), hostedReceiptPageSettings.getLinkMethod().name());
            }
            this.requestMap.put(AuthNetField.X_RECEIPT_LINK_TEXT.getFieldName(), hostedReceiptPageSettings.getLinkText() != null ? hostedReceiptPageSettings.getLinkText() : "");
            this.requestMap.put(AuthNetField.X_RECEIPT_LINK_URL.getFieldName(), hostedReceiptPageSettings.getLinkUrl() != null ? hostedReceiptPageSettings.getLinkUrl() : "");
        }
    }

    public void setRelayResponseUrl(String relayResponseUrl) {
        if (relayResponseUrl == null || relayResponseUrl.equals("")) {
            this.requestMap.put(AuthNetField.X_RELAY_RESPONSE.getFieldName(), "FALSE");
            this.requestMap.remove(AuthNetField.X_RELAY_URL.getFieldName());
        } else {
            this.requestMap.put(AuthNetField.X_RELAY_RESPONSE.getFieldName(), "TRUE");
            this.requestMap.put(AuthNetField.X_RELAY_URL.getFieldName(), relayResponseUrl);
        }
    }

    public String getRelayResponseUrl() {
        return (String)this.requestMap.get(AuthNetField.X_RELAY_URL.getFieldName());
    }

    private HashMap<String, String> filterRequestMappings(Map<String, String> ... requestMappings) {
        HashMap<String, String> filteredRequestMap = new HashMap<String, String>();
        for (Map<String, String> requestMap : requestMappings) {
            for (String key : requestMap.keySet()) {
                if (filteredRequestMap.containsKey(key) || this.formInputMap.containsKey(key)) continue;
                filteredRequestMap.put(key, requestMap.get(key));
            }
        }
        return filteredRequestMap;
    }

    private StringBuilder prepareFormInputs(Map<String, String> ... requestMappings) {
        StringBuilder inputsBuilder = new StringBuilder();
        for (String key : this.formInputMap.keySet()) {
            String htmlInputData = this.formInputMap.get(key);
            if (htmlInputData == null) continue;
            inputsBuilder.append(htmlInputData).append("\n");
        }
        HashMap<String, String> requestMapping = this.filterRequestMappings(requestMappings);
        Set<String> keys = requestMapping.keySet();
        for (String key : keys) {
            try {
                String value = requestMapping.get(key).toString();
                boolean addBreak = false;
                if ("x_rename".equals(key)) {
                    Set<String> renameKeys = this.fieldsToRename.keySet();
                    for (String renameKey : renameKeys) {
                        String renameValue = this.fieldsToRename.get(renameKey).toString();
                        inputsBuilder.append("<INPUT TYPE='").append("HIDDEN").append("' NAME='").append(key).append("' VALUE='").append(renameKey).append(",").append(renameValue).append("'>\n");
                    }
                    continue;
                }
                inputsBuilder.append("<INPUT TYPE='").append("HIDDEN").append("' NAME='").append(key).append("' VALUE='").append(value).append("'>\n").append(addBreak ? "<BR/>" : "");
            }
            catch (Exception e) {
                LogHelper.warn(logger, "NVP encoding failed: " + e.getMessage(), new Object[0]);
            }
        }
        return inputsBuilder;
    }

    public String createForm(String formName, String formId, Button button) {
        StringBuilder htmlFormBuffer = new StringBuilder();
        if (formName == null) {
            formName = "order_form";
        }
        if (formId == null) {
            formId = formName;
        }
        htmlFormBuffer.append("<FORM NAME='").append(formName);
        htmlFormBuffer.append("' ID='").append(formId);
        htmlFormBuffer.append("' ACTION='").append(this.environment.getBaseUrl() + "/gateway/transact.dll");
        htmlFormBuffer.append("' METHOD='POST'>\n");
        htmlFormBuffer.append((CharSequence)this.prepareFormInputs(this.requestMap, this.merchantDefinedMap));
        switch (button.getButtonType()) {
            case TEXT: {
                htmlFormBuffer.append("<INPUT TYPE='SUBMIT'");
                htmlFormBuffer.append(" NAME='").append(((TextButton)button).getName()).append("'");
                htmlFormBuffer.append(" VALUE='").append(((TextButton)button).getValue()).append("'");
                htmlFormBuffer.append(" CLASS='").append(((TextButton)button).getCssClass()).append("'>\n");
                break;
            }
            case IMAGE: {
                htmlFormBuffer.append("<INPUT TYPE='IMAGE'");
                htmlFormBuffer.append(" ALT='").append(((ImageButton)button).getAlt()).append("'");
                htmlFormBuffer.append(" WIDTH='").append(((ImageButton)button).getWidth()).append("'");
                htmlFormBuffer.append(" HEIGHT='").append(((ImageButton)button).getHeight()).append("'");
                htmlFormBuffer.append(" SRC='").append(((ImageButton)button).getSrc()).append("' >\n");
                break;
            }
        }
        htmlFormBuffer.append("</FORM>\n");
        return htmlFormBuffer.toString();
    }

    public static String createRelayResponseRedirectUrl(String relayResponseUrl, Map<String, String[]> requestParameterMap) {
        StringBuilder htmlFormBuffer = new StringBuilder();
        if (requestParameterMap != null) {
            htmlFormBuffer.append("?");
            for (String fieldName : requestParameterMap.keySet()) {
                String[] value = requestParameterMap.get(fieldName);
                htmlFormBuffer.append(fieldName).append("=").append(value.length > 0 ? value[0] : "");
                htmlFormBuffer.append("&");
            }
            htmlFormBuffer.deleteCharAt(htmlFormBuffer.length() - 1);
        }
        return htmlFormBuffer.toString();
    }
}

