/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.reporting;

import net.authorize.AuthNetField;
import net.authorize.Merchant;
import net.authorize.data.xml.reporting.ReportingDetails;
import net.authorize.reporting.TransactionType;
import net.authorize.util.BasicXmlDocument;
import net.authorize.util.DateUtil;
import net.authorize.util.StringUtils;
import org.w3c.dom.Element;

@Deprecated
public class Transaction
extends net.authorize.Transaction {
    private static final long serialVersionUID = 1L;
    public static String XML_NAMESPACE = "AnetApi/xml/v1/schema/AnetApiSchema.xsd";
    private Merchant merchant;
    private TransactionType transactionType;
    private ReportingDetails reportingDetails;
    private BasicXmlDocument currentRequest = null;
    private BasicXmlDocument currentResponse = null;

    private Transaction(Merchant merchant, TransactionType transactionType) {
        this.merchant = merchant;
        this.transactionType = transactionType;
    }

    public static Transaction createTransaction(Merchant merchant, TransactionType transactionType) {
        return new Transaction(merchant, transactionType);
    }

    public static final Transaction createTransaction(Transaction transaction, BasicXmlDocument response) {
        transaction.currentResponse = response;
        return transaction;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public BasicXmlDocument getCurrentRequest() {
        return this.currentRequest;
    }

    public BasicXmlDocument getCurrentResponse() {
        return this.currentResponse;
    }

    private void addAuthentication(BasicXmlDocument document) {
        Element auth_el = document.createElement(AuthNetField.ELEMENT_MERCHANT_AUTHENTICATION.getFieldName());
        Element name_el = document.createElement(AuthNetField.ELEMENT_NAME.getFieldName());
        name_el.appendChild(document.getDocument().createTextNode(this.merchant.getLogin()));
        Element trans_key = document.createElement(AuthNetField.ELEMENT_TRANSACTION_KEY.getFieldName());
        trans_key.appendChild(document.getDocument().createTextNode(this.merchant.getTransactionKey()));
        auth_el.appendChild(name_el);
        auth_el.appendChild(trans_key);
        document.getDocumentElement().appendChild(auth_el);
    }

    private void addReportingBatchListOptions(BasicXmlDocument document) {
        if (this.reportingDetails != null) {
            Element include_statistics_el = document.createElement(AuthNetField.ELEMENT_INCLUDE_STATISTICS.getFieldName());
            include_statistics_el.appendChild(document.getDocument().createTextNode(this.reportingDetails.isBatchIncludeStatistics() ? "TRUE".toLowerCase() : "FALSE".toLowerCase()));
            document.getDocumentElement().appendChild(include_statistics_el);
            if (this.reportingDetails.getBatchFirstSettlementDate() != null) {
                Element first_settlement_date_el = document.createElement(AuthNetField.ELEMENT_FIRST_SETTLEMENT_DATE.getFieldName());
                first_settlement_date_el.appendChild(document.getDocument().createTextNode(DateUtil.getFormattedDate(this.reportingDetails.getBatchFirstSettlementDate(), ReportingDetails.DATE_FORMAT)));
                document.getDocumentElement().appendChild(first_settlement_date_el);
            }
            if (this.reportingDetails.getBatchLastSettlementDate() != null) {
                Element last_settlement_date_el = document.createElement(AuthNetField.ELEMENT_LAST_SETTLEMENT_DATE.getFieldName());
                last_settlement_date_el.appendChild(document.getDocument().createTextNode(DateUtil.getFormattedDate(this.reportingDetails.getBatchLastSettlementDate(), ReportingDetails.DATE_FORMAT)));
                document.getDocumentElement().appendChild(last_settlement_date_el);
            }
        }
    }

    private void addReportingTransactionId(BasicXmlDocument document) {
        if (this.reportingDetails != null && StringUtils.isNotEmpty(this.reportingDetails.getTransactionId())) {
            Element transid_el = document.createElement(AuthNetField.ELEMENT_TRANS_ID.getFieldName());
            transid_el.appendChild(document.getDocument().createTextNode(this.reportingDetails.getTransactionId()));
            document.getDocumentElement().appendChild(transid_el);
        }
    }

    private void addReportingBatchId(BasicXmlDocument document) {
        if (this.reportingDetails != null && StringUtils.isNotEmpty(this.reportingDetails.getBatchId())) {
            Element batchid_el = document.createElement(AuthNetField.ELEMENT_BATCH_ID.getFieldName());
            batchid_el.appendChild(document.getDocument().createTextNode(this.reportingDetails.getBatchId()));
            document.getDocumentElement().appendChild(batchid_el);
        }
    }

    public String toXMLString() {
        switch (this.transactionType) {
            case GET_SETTLED_BATCH_LIST: {
                this.getSettledBatchListRequest();
                break;
            }
            case GET_TRANSACTION_DETAILS: {
                this.getTransactionDetailsRequest();
                break;
            }
            case GET_TRANSACTION_LIST: {
                this.getTransactionListRequest();
                break;
            }
            case GET_BATCH_STATISTICS: {
                this.getBatchStatisticsRequest();
                break;
            }
            case GET_UNSETTLED_TRANSACTION_LIST: {
                this.getUnsettledTransactionListRequest();
                break;
            }
        }
        return this.currentRequest.dump();
    }

    private void getSettledBatchListRequest() {
        BasicXmlDocument document = new BasicXmlDocument();
        document.parseString("<" + TransactionType.GET_SETTLED_BATCH_LIST.getValue() + " xmlns = \"" + XML_NAMESPACE + "\" />");
        this.addAuthentication(document);
        this.addReportingBatchListOptions(document);
        this.currentRequest = document;
    }

    private void getTransactionListRequest() {
        BasicXmlDocument document = new BasicXmlDocument();
        document.parseString("<" + TransactionType.GET_TRANSACTION_LIST.getValue() + " xmlns = \"" + XML_NAMESPACE + "\" />");
        this.addAuthentication(document);
        this.addReportingBatchId(document);
        this.currentRequest = document;
    }

    private void getTransactionDetailsRequest() {
        BasicXmlDocument document = new BasicXmlDocument();
        document.parseString("<" + TransactionType.GET_TRANSACTION_DETAILS.getValue() + " xmlns = \"" + XML_NAMESPACE + "\" />");
        this.addAuthentication(document);
        this.addReportingTransactionId(document);
        this.currentRequest = document;
    }

    private void getBatchStatisticsRequest() {
        BasicXmlDocument document = new BasicXmlDocument();
        document.parseString("<" + TransactionType.GET_BATCH_STATISTICS.getValue() + " xmlns = \"" + XML_NAMESPACE + "\" />");
        this.addAuthentication(document);
        this.addReportingBatchId(document);
        this.currentRequest = document;
    }

    private void getUnsettledTransactionListRequest() {
        BasicXmlDocument document = new BasicXmlDocument();
        document.parseString("<" + TransactionType.GET_UNSETTLED_TRANSACTION_LIST.getValue() + " xmlns = \"" + XML_NAMESPACE + "\" />");
        this.addAuthentication(document);
        this.currentRequest = document;
    }

    public void setReportingDetails(ReportingDetails reportingDetails) {
        this.reportingDetails = reportingDetails;
    }

    public ReportingDetails getReportingDetails() {
        return this.reportingDetails;
    }
}

