/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import net.authorize.Environment;
import net.authorize.ResponseField;
import net.authorize.Transaction;
import net.authorize.util.BasicXmlDocument;
import net.authorize.util.LogHelper;
import net.authorize.util.ResponseParser;
import net.authorize.util.XmlUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient {
    private static Log logger = LogFactory.getLog(HttpClient.class);
    public static final String ENCODING = "UTF-8";
    static boolean proxySet = false;
    static boolean UseProxy = Environment.getBooleanProperty("https.proxyUse");
    static String ProxyHost = Environment.getProperty("https.proxyHost");
    static int ProxyPort = Environment.getIntProperty("https.proxyPort");
    static String proxyUsername = Environment.getProperty("https.proxyUsername");
    static String proxyPassword = Environment.getProperty("https.proxyPassword");
    static int httpConnectionTimeout = Environment.getIntProperty("http.ConnectionTimeout");
    static int httpReadTimeout = Environment.getIntProperty("http.ReadTimeout");

    private static HttpPost createHttpPost(Environment env, Transaction transaction) throws Exception {
        HttpPost httpPost = null;
        if (transaction instanceof net.authorize.aim.Transaction || transaction instanceof net.authorize.sim.Transaction) {
            URI postUrl = transaction instanceof net.authorize.aim.Transaction && ((net.authorize.aim.Transaction)transaction).isCardPresent() ? new URI(env.getCardPresentUrl() + "/gateway/transact.dll") : new URI(env.getBaseUrl() + "/gateway/transact.dll");
            httpPost = new HttpPost(postUrl);
            httpPost.getParams().setBooleanParameter("http.protocol.expect-continue", false);
            httpPost.getParams().setIntParameter("http.connection.timeout", httpConnectionTimeout);
            httpPost.getParams().setIntParameter("http.socket.timeout", httpReadTimeout);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            httpPost.setEntity((HttpEntity)new StringEntity(transaction.toNVPString(), ENCODING));
        } else if (transaction instanceof net.authorize.arb.Transaction || transaction instanceof net.authorize.cim.Transaction || transaction instanceof net.authorize.reporting.Transaction) {
            URI postUrl = new URI(env.getXmlBaseUrl() + "/xml/v1/request.api");
            httpPost = new HttpPost(postUrl);
            httpPost.getParams().setBooleanParameter("http.protocol.expect-continue", false);
            httpPost.getParams().setIntParameter("http.connection.timeout", httpConnectionTimeout);
            httpPost.getParams().setIntParameter("http.socket.timeout", httpReadTimeout);
            httpPost.setHeader("Content-Type", "text/xml; charset=utf-8");
            httpPost.setEntity((HttpEntity)new StringEntity(transaction.toXMLString(), ENCODING));
        }
        return httpPost;
    }

    private static Map<ResponseField, String> createResponseMap(Transaction transaction, String responseString) throws UnsupportedEncodingException {
        Map<ResponseField, String> responseMap = null;
        if (transaction instanceof net.authorize.aim.Transaction || transaction instanceof net.authorize.sim.Transaction) {
            String decodedResponseData = URLDecoder.decode(responseString, ENCODING);
            responseMap = ResponseParser.parseResponseString(decodedResponseData);
        }
        return responseMap;
    }

    public static Map<ResponseField, String> execute(Environment environment, Transaction transaction) {
        Map<ResponseField, String> responseMap = new HashMap<ResponseField, String>();
        if (environment != null && transaction != null) {
            try {
                String rawResponseString;
                CloseableHttpClient httpClient = HttpClient.getHttpsClient();
                HttpPost httpPost = HttpClient.createHttpPost(environment, transaction);
                CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                if (httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entity = httpResponse.getEntity();
                    InputStream instream = entity.getContent();
                    rawResponseString = HttpClient.convertStreamToString(instream);
                } else {
                    StringBuilder responseBuilder = new StringBuilder();
                    responseBuilder.append(3).append(net.authorize.aim.Transaction.TRANSACTION_FIELD_DELIMITER);
                    responseBuilder.append(3).append(net.authorize.aim.Transaction.TRANSACTION_FIELD_DELIMITER);
                    responseBuilder.append(22).append(net.authorize.aim.Transaction.TRANSACTION_FIELD_DELIMITER);
                    responseBuilder.append(httpResponse != null ? httpResponse.getStatusLine().getReasonPhrase() : " ");
                    rawResponseString = responseBuilder.toString();
                }
                httpClient.getConnectionManager().shutdown();
                String cleanResponseString = XmlUtility.descapeStringForXml(rawResponseString);
                responseMap = HttpClient.createResponseMap(transaction, cleanResponseString);
            }
            catch (Exception e) {
                LogHelper.warn(logger, "Exception getting response: '%s': '%s', '%s'", e.getMessage(), e.getCause(), Arrays.toString(e.getStackTrace()));
            }
        }
        return responseMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block23: {
            BufferedReader reader;
            block21: {
                String line;
                reader = new BufferedReader(new InputStreamReader(is));
                sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                if (null == reader) break block21;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LogHelper.warn(logger, "Exception closing BufferedReader: '%s'", e.getMessage());
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LogHelper.warn(logger, "Exception closing InputStream: '%s'", e.getMessage());
                }
            }
            break block23;
            catch (IOException e) {
                block22: {
                    try {
                        LogHelper.warn(logger, "Exception reading data from Stream: '%s'", e.getMessage());
                        if (null == reader) break block22;
                    }
                    catch (Throwable throwable) {
                        if (null != reader) {
                            try {
                                reader.close();
                            }
                            catch (IOException e2) {
                                LogHelper.warn(logger, "Exception closing BufferedReader: '%s'", e2.getMessage());
                            }
                        }
                        if (null != is) {
                            try {
                                is.close();
                            }
                            catch (IOException e3) {
                                LogHelper.warn(logger, "Exception closing InputStream: '%s'", e3.getMessage());
                            }
                        }
                        throw throwable;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException e4) {
                        LogHelper.warn(logger, "Exception closing BufferedReader: '%s'", e4.getMessage());
                    }
                }
                if (null != is) {
                    try {
                        is.close();
                    }
                    catch (IOException e5) {
                        LogHelper.warn(logger, "Exception closing InputStream: '%s'", e5.getMessage());
                    }
                }
            }
        }
        return sb.toString();
    }

    public static BasicXmlDocument executeXML(Environment environment, Transaction transaction) {
        BasicXmlDocument response = new BasicXmlDocument();
        if (environment != null && transaction != null) {
            try {
                String rawResponseString;
                CloseableHttpClient httpClient = HttpClient.getHttpsClient();
                HttpPost httpPost = HttpClient.createHttpPost(environment, transaction);
                CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                if (httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entity = httpResponse.getEntity();
                    InputStream instream = entity.getContent();
                    rawResponseString = HttpClient.convertStreamToString(instream);
                } else {
                    StringBuilder responseBuilder = new StringBuilder();
                    if (transaction instanceof net.authorize.arb.Transaction || transaction instanceof net.authorize.cim.Transaction || transaction instanceof net.authorize.reporting.Transaction) {
                        responseBuilder.append("<?xml version=\"1.0\" ?>");
                        responseBuilder.append("<messages><resultCode>Error</resultCode>");
                        responseBuilder.append("<message><code>E00001</code>");
                        responseBuilder.append("<text>");
                        responseBuilder.append(httpResponse != null ? httpResponse.getStatusLine().getReasonPhrase() : "");
                        responseBuilder.append("</text></message></messages>");
                    } else {
                        responseBuilder.append("<?xml version=\"1.0\" ?>");
                        responseBuilder.append("<response>");
                        responseBuilder.append("<ResponseCode>3</ResponseCode>");
                        responseBuilder.append("<Errors><Error><ErrorCode>22</ErrorCode><ErrorText><![CDATA[");
                        responseBuilder.append(httpResponse != null ? httpResponse.getStatusLine().getReasonPhrase() : "");
                        responseBuilder.append("]]></ErrorText></Error></Errors></response>");
                    }
                    rawResponseString = responseBuilder.toString();
                }
                httpClient.getConnectionManager().shutdown();
                if (rawResponseString == null) {
                    return null;
                }
                int mark = rawResponseString.indexOf("<?xml");
                if (mark == -1) {
                    return null;
                }
                response.parseString(rawResponseString.substring(mark, rawResponseString.length()));
                if (!response.IsAccessible()) {
                    return null;
                }
            }
            catch (Exception e) {
                LogHelper.warn(logger, "Exception getting response: '%s': '%s', '%s'", e.getMessage(), e.getCause(), Arrays.toString(e.getStackTrace()));
            }
        }
        return response;
    }

    private static SSLContext getSSLContext() {
        try {
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            sc.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
            return sc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static CloseableHttpClient getHttpsClient() throws Exception {
        SSLContext sslcontext = HttpClient.getSSLContext();
        try {
            CloseableHttpClient httpClient;
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(httpConnectionTimeout).build();
            if (UseProxy && ProxyHost != null) {
                HttpClientBuilder hcBuilder;
                if (proxyUsername != null && proxyPassword != null) {
                    LogHelper.info(logger, "Setting up proxy to URL with Authentication: '%s://%s@%s:%d'", "http", proxyUsername, ProxyHost, ProxyPort);
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    AuthScope proxyScope = new AuthScope(ProxyHost, ProxyPort);
                    UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                    credsProvider.setCredentials(proxyScope, (Credentials)proxyCreds);
                    hcBuilder = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setDefaultRequestConfig(requestConfig).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                } else {
                    LogHelper.info(logger, "Setting up proxy to URL: '%s://%s:%d'", "http", ProxyHost, ProxyPort);
                    hcBuilder = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setDefaultRequestConfig(requestConfig).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
                }
                HttpHost httpProxy = new HttpHost(ProxyHost, ProxyPort, "http");
                hcBuilder.setProxy(httpProxy);
                httpClient = hcBuilder.build();
                proxySet = true;
            } else {
                LogHelper.warn(logger, "Defaulting to non-proxy environment", new Object[0]);
                httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setDefaultRequestConfig(requestConfig).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
            }
            return httpClient;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        LogHelper.info(logger, "Use Proxy: '%s'", UseProxy);
        httpConnectionTimeout = httpConnectionTimeout == 0 ? 30000 : httpConnectionTimeout;
        httpReadTimeout = httpReadTimeout == 0 ? 30000 : httpReadTimeout;
    }
}

