/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.aim.cardpresent;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;
import net.authorize.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@XmlRootElement
public class PrepaidCard
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double requestedAmount = 0.0;
    private double approvedAmount = 0.0;
    private double balanceAmountOnCard = 0.0;
    private static Log logger = LogFactory.getLog(PrepaidCard.class);

    protected PrepaidCard() {
    }

    public static PrepaidCard createPrepaidCard() {
        return new PrepaidCard();
    }

    public static PrepaidCard createPrepaidCard(double requestedAmount, double approvedAmount, double balanceAmountOnCard) {
        PrepaidCard prepaidCard = new PrepaidCard();
        prepaidCard.setRequestedAmount(requestedAmount);
        prepaidCard.setApprovedAmount(approvedAmount);
        prepaidCard.setBalanceAmountOnCard(balanceAmountOnCard);
        return prepaidCard;
    }

    public static PrepaidCard createPrepaidCard(String requestedAmount, String approvedAmount, String balanceAmountOnCard) {
        PrepaidCard prepaidCard = new PrepaidCard();
        prepaidCard.setRequestedAmount(requestedAmount);
        prepaidCard.setApprovedAmount(approvedAmount);
        prepaidCard.setBalanceAmountOnCard(balanceAmountOnCard);
        return prepaidCard;
    }

    public double getRequestedAmount() {
        return this.requestedAmount;
    }

    public double getApprovedAmount() {
        return this.approvedAmount;
    }

    public double getBalanceAmountOnCard() {
        return this.balanceAmountOnCard;
    }

    public void setRequestedAmount(double requestedAmount) {
        this.requestedAmount = requestedAmount;
    }

    public void setApprovedAmount(double approvedAmount) {
        this.approvedAmount = approvedAmount;
    }

    public void setBalanceAmountOnCard(double balanceAmountOnCard) {
        this.balanceAmountOnCard = balanceAmountOnCard;
    }

    public void setRequestedAmount(String requestedAmount) {
        this.requestedAmount = StringUtils.parseDouble(requestedAmount);
    }

    public void setApprovedAmount(String approvedAmount) {
        this.approvedAmount = StringUtils.parseDouble(approvedAmount);
    }

    public void setBalanceAmountOnCard(String balanceAmountOnCard) {
        this.balanceAmountOnCard = StringUtils.parseDouble(balanceAmountOnCard);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PrepaidCard:");
        builder.append(" RequestedAmount: ").append(this.requestedAmount);
        builder.append(",ApprovedAmount: ").append(this.approvedAmount);
        builder.append(",BalanceAmountOnCard: ").append(this.balanceAmountOnCard);
        return builder.toString();
    }
}

