/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.bind.JAXBException;
import net.authorize.Environment;
import net.authorize.api.contract.v1.ANetApiRequest;
import net.authorize.api.contract.v1.ANetApiResponse;
import net.authorize.util.BOMStripperInputStream;
import net.authorize.util.HttpCallTask;
import net.authorize.util.LogHelper;
import net.authorize.util.XmlUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpUtility {
    private static Log logger = LogFactory.getLog(HttpUtility.class);

    private HttpUtility() {
    }

    static HttpPost createPostRequest(Environment env, ANetApiRequest request) throws URISyntaxException, UnsupportedEncodingException, IOException, JAXBException {
        URI postUrl = null;
        HttpPost httpPost = null;
        if (null != request) {
            postUrl = new URI(env.getXmlBaseUrl() + "/xml/v1/request.api");
            logger.info((Object)String.format("MerchantInfo->LoginId/TransactionKey: '%s':'%s'", request.getMerchantAuthentication().getName(), request.getMerchantAuthentication().getTransactionKey()));
            logger.info((Object)String.format("Posting request to Url: '%s'", postUrl));
            httpPost = new HttpPost(postUrl);
            httpPost.setHeader("Content-Type", "text/xml; charset=utf-8");
            String xmlRequest = XmlUtility.getXml(request);
            logger.info((Object)String.format("Request: '%s%s%s'", LogHelper.LineSeparator, xmlRequest, LogHelper.LineSeparator));
            httpPost.setEntity((HttpEntity)new StringEntity(xmlRequest));
        }
        return httpPost;
    }

    public static <T> ANetApiResponse postData(Environment env, ANetApiRequest request, Class<T> classType) {
        ANetApiResponse response = null;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<ANetApiResponse> future = executor.submit(new HttpCallTask(env, request, classType));
        executor.shutdown();
        try {
            response = future.get();
            logger.debug((Object)String.format("Response: '%s'", response));
        }
        catch (InterruptedException ie) {
            logger.error((Object)String.format("Http call interrupted Message: '%s'", ie.getMessage()));
        }
        catch (ExecutionException ee) {
            logger.error((Object)String.format("Execution error for http post Message: '%s'", ee.getMessage()));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) {
        BOMStripperInputStream bomStripperStream = null;
        try {
            bomStripperStream = new BOMStripperInputStream(is);
        }
        catch (NullPointerException e) {
            logger.warn((Object)String.format("Exception creating BOMStripperInputStream: '%s'", e.getMessage()));
        }
        catch (IOException e) {
            logger.warn((Object)String.format("Exception creating BOMStripperInputStream: '%s'", e.getMessage()));
        }
        if (null == bomStripperStream) {
            throw new NullPointerException("Unable to create BomStriper from the input stream");
        }
        try {
            bomStripperStream.skipBOM();
        }
        catch (IOException e) {
            logger.warn((Object)String.format("Exception setting skip for BOMStripperInputStream: '%s'", e.getMessage()));
        }
        String line = null;
        InputStreamReader isr = null;
        BufferedReader reader = null;
        StringBuilder sb = null;
        try {
            isr = new InputStreamReader(bomStripperStream);
            reader = new BufferedReader(isr);
            sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append(LogHelper.LineSeparator);
            }
        }
        catch (IOException e) {
            logger.warn((Object)String.format("Exception reading data from Stream: '%s'", e.getMessage()));
        }
        finally {
            HttpUtility.tryClose(reader);
            HttpUtility.tryClose(isr);
            HttpUtility.tryClose(bomStripperStream);
            HttpUtility.tryClose(is);
        }
        return sb.toString();
    }

    private static <T extends Closeable> void tryClose(T closableObject) {
        if (null != closableObject) {
            try {
                closableObject.close();
            }
            catch (Exception e) {
                logger.warn((Object)String.format("Exception closing '%s': '%s'", closableObject.getClass(), e.getMessage()));
            }
        }
    }
}

