/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import net.authorize.Environment;
import net.authorize.ResponseField;
import net.authorize.Transaction;
import net.authorize.util.BasicXmlDocument;
import net.authorize.util.ResponseParser;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient {
    public static final String ENCODING = "UTF-8";

    private static HttpPost createHttpPost(Environment env, Transaction transaction) throws Exception {
        URI postUrl = null;
        HttpPost httpPost = null;
        if (transaction instanceof net.authorize.aim.Transaction || transaction instanceof net.authorize.sim.Transaction) {
            postUrl = transaction instanceof net.authorize.aim.Transaction && ((net.authorize.aim.Transaction)transaction).isCardPresent() ? new URI(env.getCardPresentUrl() + "/gateway/transact.dll") : new URI(env.getBaseUrl() + "/gateway/transact.dll");
            httpPost = new HttpPost(postUrl);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            httpPost.setEntity((HttpEntity)new StringEntity(transaction.toNVPString()));
        } else if (transaction instanceof net.authorize.arb.Transaction || transaction instanceof net.authorize.cim.Transaction || transaction instanceof net.authorize.reporting.Transaction) {
            postUrl = new URI(env.getXmlBaseUrl() + "/xml/v1/request.api");
            httpPost = new HttpPost(postUrl);
            httpPost.setHeader("Content-Type", "text/xml; charset=utf-8");
            httpPost.setEntity((HttpEntity)new StringEntity(transaction.toXMLString()));
        }
        return httpPost;
    }

    private static Map<ResponseField, String> createResponseMap(Transaction transaction, String responseString) throws UnsupportedEncodingException {
        Map<ResponseField, String> responseMap = null;
        if (transaction instanceof net.authorize.aim.Transaction || transaction instanceof net.authorize.sim.Transaction) {
            String decodedResponseData = URLDecoder.decode(responseString, ENCODING);
            responseMap = ResponseParser.parseResponseString(decodedResponseData);
        }
        return responseMap;
    }

    public static Map<ResponseField, String> execute(Environment environment, Transaction transaction) {
        Map<ResponseField, String> responseMap = new HashMap<ResponseField, String>();
        if (environment != null && transaction != null) {
            try {
                DefaultHttpClient httpClient = new DefaultHttpClient();
                HttpPost httpPost = HttpClient.createHttpPost(environment, transaction);
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                String rawResponseString = "";
                if (httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entity = httpResponse.getEntity();
                    InputStream instream = entity.getContent();
                    rawResponseString = HttpClient.convertStreamToString(instream);
                } else {
                    StringBuilder responseBuilder = new StringBuilder();
                    responseBuilder.append(3).append(net.authorize.aim.Transaction.TRANSACTION_FIELD_DELIMITER);
                    responseBuilder.append(3).append(net.authorize.aim.Transaction.TRANSACTION_FIELD_DELIMITER);
                    responseBuilder.append(22).append(net.authorize.aim.Transaction.TRANSACTION_FIELD_DELIMITER);
                    responseBuilder.append(httpResponse != null ? httpResponse.getStatusLine().getReasonPhrase() : " ");
                    rawResponseString = responseBuilder.toString();
                }
                httpClient.getConnectionManager().shutdown();
                responseMap = HttpClient.createResponseMap(transaction, rawResponseString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return responseMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static BasicXmlDocument executeXML(Environment environment, Transaction transaction) {
        BasicXmlDocument response = new BasicXmlDocument();
        if (environment != null && transaction != null) {
            try {
                int mark;
                DefaultHttpClient httpClient = new DefaultHttpClient();
                HttpPost httpPost = HttpClient.createHttpPost(environment, transaction);
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                String rawResponseString = "";
                if (httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entity = httpResponse.getEntity();
                    InputStream instream = entity.getContent();
                    rawResponseString = HttpClient.convertStreamToString(instream);
                } else {
                    StringBuilder responseBuilder = new StringBuilder();
                    if (transaction instanceof net.authorize.arb.Transaction || transaction instanceof net.authorize.cim.Transaction || transaction instanceof net.authorize.reporting.Transaction) {
                        responseBuilder.append("<?xml version=\"1.0\" ?>");
                        responseBuilder.append("<messages><resultCode>Error</resultCode>");
                        responseBuilder.append("<message><code>E00001</code>");
                        responseBuilder.append("<text>");
                        responseBuilder.append(httpResponse != null ? httpResponse.getStatusLine().getReasonPhrase() : "");
                        responseBuilder.append("</text></message></messages>");
                    } else {
                        responseBuilder.append("<?xml version=\"1.0\" ?>");
                        responseBuilder.append("<response>");
                        responseBuilder.append("<ResponseCode>3</ResponseCode>");
                        responseBuilder.append("<Errors><Error><ErrorCode>22</ErrorCode><ErrorText><![CDATA[");
                        responseBuilder.append(httpResponse != null ? httpResponse.getStatusLine().getReasonPhrase() : "");
                        responseBuilder.append("]]></ErrorText></Error></Errors></response>");
                    }
                    rawResponseString = responseBuilder.toString();
                }
                httpClient.getConnectionManager().shutdown();
                if (rawResponseString == null) {
                    return null;
                }
                if (Environment.SANDBOX.equals((Object)environment) || Environment.SANDBOX_TESTMODE.equals((Object)environment)) {
                    // empty if block
                }
                if ((mark = rawResponseString.indexOf("<?xml")) == -1) {
                    return null;
                }
                response.parseString(rawResponseString.substring(mark, rawResponseString.length()));
                if (!response.IsAccessible()) {
                    return null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return response;
    }
}

