/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.data.echeck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NOCCode {
    C01("C01", "Incorrect DFI account number", "The customer's bank account number is incorrect."),
    C02("C02", "Incorrect routing number", "The bank's ABA routing number is incorrect."),
    C03("C03", "Incorrect routing number and incorrect DFI account number", "The bank's ABA routing number is incorrect and as a result the bank account number structure is also incorrect."),
    C04("C04", "Incorrect individual name / receiving company name", "The individual or company name associated with the bank account is incorrect."),
    C05("C05", "Incorrect transaction code", "The transaction was submitted to a certain account type but includes a conflicting account type code (checking / savings)."),
    C06("C06", "Incorrect DFI account number and incorrect transaction code", "The customer's bank account number is incorrect and the transaction should be submitted to a different account type (checking / savings)."),
    C07("C07", "Incorrect routing number, incorrect DFI account number, and incorrect transaction code", "The bank's ABA routing number and the bank account number are incorrect; and the transaction was submitted to a certain account type but includes a conflicting account type code (checking / savings).");

    private final String code;
    private final String nocReason;
    private final String description;

    private NOCCode(String code, String nocReason, String description) {
        this.code = code;
        this.nocReason = nocReason;
        this.description = description;
    }

    public static NOCCode findByCode(String code) {
        for (NOCCode nocCode : NOCCode.values()) {
            if (!nocCode.code.equals(code)) continue;
            return nocCode;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getNocReason() {
        return this.nocReason;
    }

    public String getDescription() {
        return this.description;
    }
}

