/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.data;

import java.io.Serializable;
import java.math.BigDecimal;
import net.authorize.util.StringUtils;

public class OrderItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAX_ITEM_ID_LENGTH = 31;
    public static final int MAX_ITEM_NAME_LENGTH = 31;
    public static final int MAX_ITEM_DESCRIPTION_LENGTH = 255;
    protected String itemId;
    protected String itemName;
    protected String itemDescription;
    protected BigDecimal itemQuantity = new BigDecimal(0.0);
    protected BigDecimal itemPrice = new BigDecimal(0.0);
    protected boolean itemTaxable = false;

    protected OrderItem() {
    }

    public static OrderItem createOrderItem() {
        OrderItem orderItem = new OrderItem();
        return orderItem;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemDescription() {
        return this.itemDescription;
    }

    public void setItemDescription(String itemDescription) {
        this.itemDescription = itemDescription;
    }

    public BigDecimal getItemQuantity() {
        return this.itemQuantity;
    }

    public void setItemQuantity(BigDecimal itemQuantity) {
        this.itemQuantity = itemQuantity;
        if (this.itemQuantity != null) {
            this.itemQuantity.setScale(4, 4);
        }
    }

    public void setItemQuantity(String itemQuantity) {
        if (StringUtils.isNotEmpty(itemQuantity)) {
            this.itemQuantity = new BigDecimal(itemQuantity).setScale(4, 4);
        }
    }

    public BigDecimal getItemPrice() {
        return this.itemPrice;
    }

    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    public void setItemPrice(String itemPrice) {
        if (StringUtils.isNotEmpty(itemPrice)) {
            this.itemPrice = new BigDecimal(itemPrice).setScale(2, 4);
        }
    }

    public boolean isItemTaxable() {
        return this.itemTaxable;
    }

    public void setItemTaxable(boolean itemTaxable) {
        this.itemTaxable = itemTaxable;
    }

    public void setItemTaxable(String itemTaxable) {
        if (StringUtils.isNotEmpty(itemTaxable)) {
            this.itemTaxable = Boolean.valueOf(itemTaxable);
        }
    }
}

