/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.ExtendedDateFormat;

public class LocalCache {
    private static final int CACHE_SIZE = 256;
    private ResourceBundle resources;
    private Locale locale;
    private TimeZone timeZone;
    private StringBuilder builderCache;
    private int stringCacheCount = 0;
    private String[] stringCache;
    private Map<String, DateFormat> dateFormatCache;
    private Map<String, NumberFormat> numberFormatCache;
    private Map<ParameterTypeKey, Type> paramTypeCache;

    public LocalCache(String bundle, Locale locale, TimeZone timeZone) {
        this.resources = ResourceBundle.getBundle(bundle, locale);
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public StringBuilder getCachedBuffer() {
        if (this.builderCache == null) {
            this.builderCache = new StringBuilder();
        } else {
            this.builderCache.setLength(0);
        }
        return this.builderCache;
    }

    public String getString(CharSequence cs) {
        if (cs.length() == 0) {
            return "";
        }
        if (cs.length() < 32 && this.stringCacheCount++ > 16) {
            String str;
            int index = this.getCacheIndex(cs);
            if (index < 0) {
                return cs.toString();
            }
            if (this.stringCache == null) {
                this.stringCache = new String[256];
            }
            if ((str = this.stringCache[index]) == null || str.length() != cs.length()) {
                this.stringCache[index] = str = cs.toString();
                return str;
            }
            for (int i = 0; i < cs.length(); ++i) {
                if (str.charAt(i) == cs.charAt(i)) continue;
                this.stringCache[index] = str = cs.toString();
                return str;
            }
            return str;
        }
        return cs.toString();
    }

    private int getCacheIndex(CharSequence cs) {
        int h = 0;
        int max = Math.min(16, cs.length());
        for (int i = 0; i < max; ++i) {
            h = h * 31 + cs.charAt(i);
        }
        return h & 0xFF;
    }

    public NumberFormat getNumberFormat(String format) {
        NumberFormat nformat = null;
        if (this.numberFormatCache == null) {
            this.numberFormatCache = new HashMap<String, NumberFormat>();
        } else {
            nformat = this.numberFormatCache.get(format);
        }
        if (nformat == null) {
            nformat = new DecimalFormat(format, new DecimalFormatSymbols(this.locale));
            this.numberFormatCache.put(format, nformat);
        }
        return nformat;
    }

    public DateFormat getDateFormat(String format) {
        DateFormat dformat = null;
        if (this.dateFormatCache == null) {
            this.dateFormatCache = new HashMap<String, DateFormat>();
        } else {
            dformat = this.dateFormatCache.get(format);
        }
        if (dformat == null) {
            dformat = new ExtendedDateFormat(format, this.locale);
            dformat.setTimeZone(this.timeZone);
            this.dateFormatCache.put(format, dformat);
        }
        return dformat;
    }

    public Type getResolvedType(Type ptype, Class<?> pcls, Type type) {
        ParameterTypeKey key = new ParameterTypeKey(ptype, pcls, type);
        Type result = null;
        if (this.paramTypeCache == null) {
            this.paramTypeCache = new HashMap<ParameterTypeKey, Type>();
        } else {
            result = this.paramTypeCache.get(key);
        }
        if (result == null) {
            result = ClassUtil.getResolvedType(ptype, pcls, type);
            this.paramTypeCache.put(key, result);
        }
        return result;
    }

    public String getMessage(String id) {
        return this.getMessage(id, null);
    }

    public String getMessage(String id, Object ... args) {
        if (args != null && args.length > 0) {
            return MessageFormat.format(this.resources.getString(id), args);
        }
        return this.resources.getString(id);
    }

    private static class ParameterTypeKey {
        private Type ptype;
        private Class<?> pcls;
        private Type type;

        public ParameterTypeKey(Type ptype, Class<?> pcls, Type type) {
            this.ptype = ptype;
            this.pcls = pcls;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.ptype == null ? 0 : this.ptype.hashCode());
            result = 31 * result + (this.pcls == null ? 0 : this.pcls.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterTypeKey other = (ParameterTypeKey)obj;
            if (this.ptype == null ? other.ptype != null : !this.ptype.equals(other.ptype)) {
                return false;
            }
            if (this.pcls == null ? other.pcls != null : !this.pcls.equals(other.pcls)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

