/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.ExtendedDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCache {
    private static final int CACHE_SIZE = 256;
    private ResourceBundle resources;
    private Locale locale;
    private TimeZone timeZone;
    private StringBuilder builderCache;
    private String[] stringCache;
    private Map<String, DateFormat> dateFormatCache;
    private Map<String, NumberFormat> numberFormatCache;
    private Map<ParameterTypeKey, Type> parameterTypeCache;

    public LocalCache(String string, Locale locale, TimeZone timeZone) {
        this.resources = ResourceBundle.getBundle(string, locale);
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public StringBuilder getCachedBuffer() {
        if (this.builderCache == null) {
            this.builderCache = new StringBuilder();
        } else {
            this.builderCache.setLength(0);
        }
        return this.builderCache;
    }

    public String getString(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return "";
        }
        if (charSequence.length() < 32) {
            String string;
            int n = this.getCacheIndex(charSequence);
            if (n < 0) {
                return charSequence.toString();
            }
            if (this.stringCache == null) {
                this.stringCache = new String[256];
            }
            if ((string = this.stringCache[n]) == null || string.length() != charSequence.length()) {
                this.stringCache[n] = string = charSequence.toString();
                return string;
            }
            for (int i = 0; i < charSequence.length(); ++i) {
                if (string.charAt(i) == charSequence.charAt(i)) continue;
                this.stringCache[n] = string = charSequence.toString();
                return string;
            }
            return string;
        }
        return charSequence.toString();
    }

    private int getCacheIndex(CharSequence charSequence) {
        int n = 0;
        int n2 = Math.min(16, charSequence.length());
        for (int i = 0; i < n2; ++i) {
            n = n * 31 + charSequence.charAt(i);
        }
        return n & 0xFF;
    }

    public NumberFormat getNumberFormat(String string) {
        NumberFormat numberFormat = null;
        if (this.numberFormatCache == null) {
            this.numberFormatCache = new HashMap<String, NumberFormat>();
        } else {
            numberFormat = this.numberFormatCache.get(string);
        }
        if (numberFormat == null) {
            numberFormat = new DecimalFormat(string, new DecimalFormatSymbols(this.locale));
            this.numberFormatCache.put(string, numberFormat);
        }
        return numberFormat;
    }

    public DateFormat getDateFormat(String string) {
        DateFormat dateFormat = null;
        if (this.dateFormatCache == null) {
            this.dateFormatCache = new HashMap<String, DateFormat>();
        } else {
            dateFormat = this.dateFormatCache.get(string);
        }
        if (dateFormat == null) {
            dateFormat = new ExtendedDateFormat(string, this.locale);
            dateFormat.setTimeZone(this.timeZone);
            this.dateFormatCache.put(string, dateFormat);
        }
        return dateFormat;
    }

    public Type getParameterType(Type type, Class<?> clazz, int n) {
        ParameterTypeKey parameterTypeKey = new ParameterTypeKey(type, clazz, n);
        Type type2 = null;
        if (this.parameterTypeCache == null) {
            this.parameterTypeCache = new HashMap<ParameterTypeKey, Type>();
        } else {
            type2 = this.parameterTypeCache.get(parameterTypeKey);
        }
        if (type2 == null) {
            type2 = ClassUtil.getParameterType(type, clazz, n);
            this.parameterTypeCache.put(parameterTypeKey, type2);
        }
        return type2;
    }

    public String getMessage(String string) {
        return this.getMessage(string, null);
    }

    public String getMessage(String string, Object ... objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            return MessageFormat.format(this.resources.getString(string), objectArray);
        }
        return this.resources.getString(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterTypeKey {
        private Type t;
        private Class<?> cls;
        private int pos;

        public ParameterTypeKey(Type type, Class<?> clazz, int n) {
            this.t = type;
            this.cls = clazz;
            this.pos = n;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.cls == null ? 0 : this.cls.hashCode());
            n = 31 * n + this.pos;
            n = 31 * n + (this.t == null ? 0 : this.t.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ParameterTypeKey parameterTypeKey = (ParameterTypeKey)object;
            if (this.cls == null ? parameterTypeKey.cls != null : !this.cls.equals(parameterTypeKey.cls)) {
                return false;
            }
            if (this.pos != parameterTypeKey.pos) {
                return false;
            }
            return !(this.t == null ? parameterTypeKey.t != null : !this.t.equals(parameterTypeKey.t));
        }
    }
}

