/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import net.arnx.jsonic.AppendableConverter;
import net.arnx.jsonic.ArrayConverter;
import net.arnx.jsonic.BigDecimalConverter;
import net.arnx.jsonic.BigIntegerConverter;
import net.arnx.jsonic.BooleanArrayFormatter;
import net.arnx.jsonic.BooleanConverter;
import net.arnx.jsonic.ByteArrayFormatter;
import net.arnx.jsonic.ByteConverter;
import net.arnx.jsonic.ByteFormatter;
import net.arnx.jsonic.CalendarConverter;
import net.arnx.jsonic.CalendarFormatter;
import net.arnx.jsonic.CharArrayFormatter;
import net.arnx.jsonic.CharSequenceConverter;
import net.arnx.jsonic.CharacterConverter;
import net.arnx.jsonic.CharsetConverter;
import net.arnx.jsonic.CharsetFormatter;
import net.arnx.jsonic.ClassConverter;
import net.arnx.jsonic.ClassFormatter;
import net.arnx.jsonic.CollectionConverter;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.DateConverter;
import net.arnx.jsonic.DateFormatter;
import net.arnx.jsonic.DoubleArrayFormatter;
import net.arnx.jsonic.DoubleConverter;
import net.arnx.jsonic.EnumConverter;
import net.arnx.jsonic.EnumFormatter;
import net.arnx.jsonic.EnumerationFormatter;
import net.arnx.jsonic.FileConverter;
import net.arnx.jsonic.FloatArrayFormatter;
import net.arnx.jsonic.FloatConverter;
import net.arnx.jsonic.FloatFormatter;
import net.arnx.jsonic.FormatConverter;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.IntArrayFormatter;
import net.arnx.jsonic.IntegerConverter;
import net.arnx.jsonic.IterableFormatter;
import net.arnx.jsonic.IteratorFormatter;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.JSONReader;
import net.arnx.jsonic.JSONWriter;
import net.arnx.jsonic.ListFormatter;
import net.arnx.jsonic.LocaleConverter;
import net.arnx.jsonic.LocaleFormatter;
import net.arnx.jsonic.LongArrayFormatter;
import net.arnx.jsonic.LongConverter;
import net.arnx.jsonic.MapConverter;
import net.arnx.jsonic.MapFormatter;
import net.arnx.jsonic.NamingStyle;
import net.arnx.jsonic.NullConverter;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.NumberFormatter;
import net.arnx.jsonic.ObjectArrayFormatter;
import net.arnx.jsonic.ObjectConverter;
import net.arnx.jsonic.ObjectFormatter;
import net.arnx.jsonic.PatternConverter;
import net.arnx.jsonic.PlainConverter;
import net.arnx.jsonic.PlainFormatter;
import net.arnx.jsonic.PropertiesConverter;
import net.arnx.jsonic.SerializableConverter;
import net.arnx.jsonic.SerializableFormatter;
import net.arnx.jsonic.ShortArrayFormatter;
import net.arnx.jsonic.ShortConverter;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.StringSerializableConverter;
import net.arnx.jsonic.StringableFormmatter;
import net.arnx.jsonic.TimeZoneConverter;
import net.arnx.jsonic.TimeZoneFormatter;
import net.arnx.jsonic.TypeReference;
import net.arnx.jsonic.URIConverter;
import net.arnx.jsonic.URLConverter;
import net.arnx.jsonic.UUIDConverter;
import net.arnx.jsonic.io.AppendableOutputSource;
import net.arnx.jsonic.io.CharSequenceInputSource;
import net.arnx.jsonic.io.OutputSource;
import net.arnx.jsonic.io.ReaderInputSource;
import net.arnx.jsonic.io.StringBufferInputSource;
import net.arnx.jsonic.io.StringBuilderInputSource;
import net.arnx.jsonic.io.StringBuilderOutputSource;
import net.arnx.jsonic.io.StringInputSource;
import net.arnx.jsonic.io.WriterOutputSource;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.LocalCache;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSON {
    public static volatile Class<? extends JSON> prototype;
    static final Character ROOT;
    private static final Map<Class<?>, Formatter> FORMAT_MAP;
    private static final List<Formatter> FORMAT_LIST;
    private static final Map<Class<?>, Converter> CONVERT_MAP;
    private static final List<Converter> CONVERT_LIST;
    Object contextObject;
    Locale locale = Locale.getDefault();
    TimeZone timeZone = TimeZone.getDefault();
    boolean prettyPrint = false;
    int initialIndent = 0;
    String indentText = "\t";
    int maxDepth = 32;
    boolean suppressNull = false;
    Mode mode = Mode.TRADITIONAL;
    String dateFormat;
    String numberFormat;
    NamingStyle propertyStyle = NamingStyle.NOOP;
    NamingStyle enumStyle = NamingStyle.NOOP;

    static Object getInstance(String string, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
            BeanInfo beanInfo = BeanInfo.get(clazz);
            PropertyInfo propertyInfo = beanInfo.getStaticProperty("INSTANCE");
            if (propertyInfo != null) {
                return propertyInfo.get(null);
            }
            return beanInfo.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    static JSON newInstance() {
        JSON jSON = null;
        try {
            jSON = prototype.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        return jSON;
    }

    public static String encode(Object object) throws JSONException {
        return JSON.encode(object, false);
    }

    public static String encode(Object object, boolean bl) throws JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setPrettyPrint(bl);
        return jSON.format(object);
    }

    public static void encode(Object object, OutputStream outputStream) throws IOException, JSONException {
        JSON.newInstance().format(object, new OutputStreamWriter(outputStream, "UTF-8"));
    }

    public static void encode(Object object, OutputStream outputStream, boolean bl) throws IOException, JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setPrettyPrint(bl);
        jSON.format(object, new OutputStreamWriter(outputStream, "UTF-8"));
    }

    public static void encode(Object object, Appendable appendable) throws IOException, JSONException {
        JSON.newInstance().format(object, appendable);
    }

    public static void encode(Object object, Appendable appendable, boolean bl) throws IOException, JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setPrettyPrint(bl);
        jSON.format(object, appendable);
    }

    public static String escapeScript(Object object) throws JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setMode(Mode.SCRIPT);
        return jSON.format(object);
    }

    public static void escapeScript(Object object, OutputStream outputStream) throws IOException, JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setMode(Mode.SCRIPT);
        jSON.format(object, outputStream);
    }

    public static void escapeScript(Object object, Appendable appendable) throws IOException, JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setMode(Mode.SCRIPT);
        jSON.format(object, appendable);
    }

    public static <T> T decode(String string) throws JSONException {
        return JSON.newInstance().parse(string);
    }

    public static <T> T decode(String string, Class<? extends T> clazz) throws JSONException {
        return JSON.newInstance().parse((CharSequence)string, clazz);
    }

    public static <T> T decode(String string, Type type) throws JSONException {
        return JSON.newInstance().parse((CharSequence)string, type);
    }

    public static <T> T decode(InputStream inputStream) throws IOException, JSONException {
        return JSON.newInstance().parse(inputStream);
    }

    public static <T> T decode(InputStream inputStream, Class<? extends T> clazz) throws IOException, JSONException {
        return JSON.newInstance().parse(inputStream, clazz);
    }

    public static <T> T decode(InputStream inputStream, Type type) throws IOException, JSONException {
        return JSON.newInstance().parse(inputStream, type);
    }

    public static <T> T decode(Reader reader) throws IOException, JSONException {
        return JSON.newInstance().parse(reader);
    }

    public static <T> T decode(Reader reader, Class<? extends T> clazz) throws IOException, JSONException {
        return JSON.newInstance().parse(reader, clazz);
    }

    public static <T> T decode(Reader reader, Type type) throws IOException, JSONException {
        return JSON.newInstance().parse(reader, type);
    }

    public static void validate(CharSequence charSequence) throws JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setMode(Mode.STRICT);
        jSON.setMaxDepth(0);
        jSON.parse(charSequence);
    }

    public static void validate(InputStream inputStream) throws IOException, JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setMode(Mode.STRICT);
        jSON.setMaxDepth(0);
        jSON.parse(inputStream);
    }

    public static void validate(Reader reader) throws IOException, JSONException {
        JSON jSON = JSON.newInstance();
        jSON.setMode(Mode.STRICT);
        jSON.setMaxDepth(0);
        jSON.parse(reader);
    }

    public JSON() {
    }

    public JSON(int n) {
        this.setMaxDepth(n);
    }

    public JSON(Mode mode) {
        this.setMode(mode);
    }

    public void setContext(Object object) {
        this.contextObject = object;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.locale = locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException();
        }
        this.timeZone = timeZone;
    }

    public void setPrettyPrint(boolean bl) {
        this.prettyPrint = bl;
    }

    public void setInitialIndent(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(this.getMessage("json.TooSmallArgumentError", "initialIndent", 0));
        }
        this.initialIndent = n;
    }

    public void setIndentText(String string) {
        this.indentText = string;
    }

    public void setMaxDepth(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(this.getMessage("json.TooSmallArgumentError", "maxDepth", 0));
        }
        this.maxDepth = n;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setSuppressNull(boolean bl) {
        this.suppressNull = bl;
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new NullPointerException();
        }
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setDateFormat(String string) {
        this.dateFormat = string;
    }

    public void setNumberFormat(String string) {
        this.numberFormat = string;
    }

    public void setPropertyStyle(NamingStyle namingStyle) {
        this.propertyStyle = namingStyle;
    }

    public void setEnumStyle(NamingStyle namingStyle) {
        this.enumStyle = namingStyle;
    }

    public String format(Object object) {
        String string = null;
        try {
            string = this.format(object, new StringBuilder(1000)).toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public OutputStream format(Object object, OutputStream outputStream) throws IOException {
        this.format(object, new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8")));
        return outputStream;
    }

    public Appendable format(Object object, Appendable appendable) throws IOException {
        OutputSource outputSource = appendable instanceof BufferedWriter ? new AppendableOutputSource(appendable) : (appendable instanceof Writer ? new WriterOutputSource((Writer)appendable) : (appendable instanceof StringBuilder ? new StringBuilderOutputSource((StringBuilder)appendable) : new AppendableOutputSource(appendable)));
        Context context = new Context();
        if (context.isPrettyPrint()) {
            context.appendIndent(outputSource, 0);
        }
        context.enter(ROOT, null);
        object = context.preformatInternal(object);
        context.formatInternal(object, outputSource);
        context.exit();
        outputSource.flush();
        return appendable;
    }

    public JSONWriter getWriter(OutputStream outputStream) throws IOException {
        return this.getWriter(new OutputStreamWriter(outputStream, "UTF-8"));
    }

    public JSONWriter getWriter(Appendable appendable) throws IOException {
        OutputSource outputSource = appendable instanceof BufferedWriter ? new AppendableOutputSource(appendable) : (appendable instanceof Writer ? new WriterOutputSource((Writer)appendable) : (appendable instanceof StringBuilder ? new StringBuilderOutputSource((StringBuilder)appendable) : new AppendableOutputSource(appendable)));
        return new JSONWriter(new Context(), outputSource);
    }

    protected Object preformat(Context context, Object object) throws Exception {
        return object;
    }

    public <T> T parse(CharSequence charSequence) throws JSONException {
        CharSequenceInputSource charSequenceInputSource = charSequence instanceof String ? new StringInputSource((String)charSequence) : (charSequence instanceof StringBuilder ? new StringBuilderInputSource((StringBuilder)charSequence) : (charSequence instanceof StringBuffer ? new StringBufferInputSource((StringBuffer)charSequence) : new CharSequenceInputSource(charSequence)));
        Object object = null;
        try {
            JSONReader jSONReader = new JSONReader(new Context(), charSequenceInputSource, false, true);
            object = jSONReader.next() != null ? jSONReader.getValue() : null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (T)object;
    }

    public <T> T parse(CharSequence charSequence, Class<? extends T> clazz) throws JSONException {
        return this.parse(charSequence, (Type)clazz);
    }

    public <T> T parse(CharSequence charSequence, Type type) throws JSONException {
        CharSequenceInputSource charSequenceInputSource = charSequence instanceof String ? new StringInputSource((String)charSequence) : (charSequence instanceof StringBuilder ? new StringBuilderInputSource((StringBuilder)charSequence) : (charSequence instanceof StringBuffer ? new StringBufferInputSource((StringBuffer)charSequence) : new CharSequenceInputSource(charSequence)));
        T t = null;
        try {
            Context context = new Context();
            JSONReader jSONReader = new JSONReader(context, charSequenceInputSource, false, true);
            Object object = jSONReader.next() != null ? jSONReader.getValue() : null;
            t = context.convertInternal(object, type);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return t;
    }

    public <T> T parse(InputStream inputStream) throws IOException, JSONException {
        JSONReader jSONReader = new JSONReader(new Context(), new ReaderInputSource(inputStream), false, true);
        return (T)(jSONReader.next() != null ? jSONReader.getValue() : null);
    }

    public <T> T parse(InputStream inputStream, Class<? extends T> clazz) throws IOException, JSONException {
        return this.parse(inputStream, (Type)clazz);
    }

    public <T> T parse(InputStream inputStream, Type type) throws IOException, JSONException {
        Context context = new Context();
        JSONReader jSONReader = new JSONReader(context, new ReaderInputSource(inputStream), false, true);
        Object object = jSONReader.next() != null ? jSONReader.getValue() : null;
        return context.convertInternal(object, type);
    }

    public <T> T parse(Reader reader) throws IOException, JSONException {
        JSONReader jSONReader = new JSONReader(new Context(), new ReaderInputSource(reader), false, true);
        return (T)(jSONReader.next() != null ? jSONReader.getValue() : null);
    }

    public <T> T parse(Reader reader, Class<? extends T> clazz) throws IOException, JSONException {
        return this.parse(reader, (Type)clazz);
    }

    public <T> T parse(Reader reader, Type type) throws IOException, JSONException {
        Context context = new Context();
        JSONReader jSONReader = new JSONReader(context, new ReaderInputSource(reader), false, true);
        Object object = jSONReader.next() != null ? jSONReader.getValue() : null;
        return context.convertInternal(object, type);
    }

    public JSONReader getReader(CharSequence charSequence) {
        return this.getReader(charSequence, true);
    }

    public JSONReader getReader(InputStream inputStream) {
        return this.getReader(inputStream, true);
    }

    public JSONReader getReader(Reader reader) {
        return this.getReader(reader, true);
    }

    public JSONReader getReader(CharSequence charSequence, boolean bl) {
        CharSequenceInputSource charSequenceInputSource = charSequence instanceof String ? new StringInputSource((String)charSequence) : (charSequence instanceof StringBuilder ? new StringBuilderInputSource((StringBuilder)charSequence) : (charSequence instanceof StringBuffer ? new StringBufferInputSource((StringBuffer)charSequence) : new CharSequenceInputSource(charSequence)));
        return new JSONReader(new Context(), charSequenceInputSource, true, bl);
    }

    public JSONReader getReader(InputStream inputStream, boolean bl) {
        return new JSONReader(new Context(), new ReaderInputSource(inputStream), true, bl);
    }

    public JSONReader getReader(Reader reader, boolean bl) {
        return new JSONReader(new Context(), new ReaderInputSource(reader), true, bl);
    }

    String getMessage(String string, Object ... objectArray) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("net.arnx.jsonic.Messages", this.locale);
        return MessageFormat.format(resourceBundle.getString(string), objectArray);
    }

    public Object convert(Object object, Type type) throws JSONException {
        return new Context().convertInternal(object, type);
    }

    protected <T> T postparse(Context context, Object object, Class<? extends T> clazz, Type type) throws Exception {
        Object object2;
        Converter converter = null;
        if (object == null) {
            if (!clazz.isPrimitive()) {
                converter = NullConverter.INSTANCE;
            }
        } else {
            object2 = context.getHint();
            if (object2 != null) {
                if (object2.serialized() && object2 != context.skipHint) {
                    converter = FormatConverter.INSTANCE;
                } else if (Serializable.class.equals(object2.type())) {
                    converter = SerializableConverter.INSTANCE;
                } else if (String.class.equals(object2.type())) {
                    converter = StringSerializableConverter.INSTANCE;
                }
            }
        }
        if (converter == null) {
            converter = object != null && clazz == type && clazz.isAssignableFrom(object.getClass()) ? PlainConverter.INSTANCE : CONVERT_MAP.get(clazz);
        }
        if (converter == null && context.memberCache != null) {
            converter = (Converter)context.memberCache.get(clazz);
        }
        if (converter == null) {
            for (Converter converter2 : CONVERT_LIST) {
                if (!converter2.accept(clazz)) continue;
                converter = converter2;
                break;
            }
            if (converter == null) {
                converter = new ObjectConverter(clazz);
            }
            if (context.memberCache == null) {
                context.memberCache = new HashMap();
            }
            context.memberCache.put(clazz, converter);
        }
        object2 = converter.convert(context, object, clazz, type);
        return (T)object2;
    }

    protected String normalize(String string) {
        return string;
    }

    protected boolean ignore(Context context, Class<?> clazz, Member member) {
        if (Modifier.isTransient(member.getModifiers())) {
            return true;
        }
        return member.getDeclaringClass().equals(Object.class);
    }

    protected <T> T create(Context context, Class<? extends T> clazz) throws Exception {
        Serializable serializable = null;
        JSONHint jSONHint = context.getHint();
        if (jSONHint != null && jSONHint.type() != Object.class) {
            clazz = jSONHint.type().asSubclass(clazz);
        }
        if (Collection.class.equals(clazz) || List.class.equals(clazz) || ArrayList.class.equals(clazz)) {
            serializable = context.createSizeHint >= 0 ? new ArrayList(context.createSizeHint) : new ArrayList();
        } else if (Map.class.equals(clazz)) {
            if (context.createSizeHint >= 0) {
                int n = Math.max((int)((float)context.createSizeHint / 0.75f) + 1, 16);
                serializable = new LinkedHashMap(n);
            } else {
                serializable = new LinkedHashMap();
            }
        } else if (clazz.isInterface()) {
            if (SortedMap.class.equals(clazz)) {
                serializable = new TreeMap();
            } else if (SortedSet.class.equals(clazz)) {
                serializable = new TreeSet();
            } else if (Set.class.equals(clazz)) {
                serializable = new LinkedHashSet();
            } else if (Appendable.class.equals(clazz)) {
                serializable = new StringBuilder();
            }
        } else if (Modifier.isAbstract(clazz.getModifiers())) {
            if (Calendar.class.equals(clazz)) {
                serializable = Calendar.getInstance();
            }
        } else if ((clazz.isMemberClass() || clazz.isAnonymousClass()) && !Modifier.isStatic(clazz.getModifiers())) {
            Class<?> clazz2 = clazz.getEnclosingClass();
            Constructor<T> constructor = clazz.getDeclaredConstructor(clazz2);
            constructor.setAccessible(true);
            serializable = context.contextObject != null && clazz2.isAssignableFrom(context.contextObject.getClass()) ? constructor.newInstance(context.contextObject) : constructor.newInstance(new Object[]{null});
        } else {
            Constructor<T> constructor;
            if (Date.class.isAssignableFrom(clazz)) {
                try {
                    constructor = clazz.getDeclaredConstructor(Long.TYPE);
                    constructor.setAccessible(true);
                    serializable = constructor.newInstance(0L);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (serializable == null) {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                serializable = constructor.newInstance(new Object[0]);
            }
        }
        return clazz.cast(serializable);
    }

    static {
        Object object;
        prototype = JSON.class;
        ROOT = Character.valueOf('$');
        FORMAT_MAP = new HashMap(50);
        FORMAT_LIST = new ArrayList<Formatter>(20);
        CONVERT_MAP = new HashMap(50);
        CONVERT_LIST = new ArrayList<Converter>(20);
        ClassLoader classLoader = JSON.class.getClassLoader();
        try {
            object = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader2 = object;
            do {
                if (classLoader2 != classLoader) continue;
                classLoader = object;
                break;
            } while ((classLoader2 = classLoader2.getParent()) != null);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        object = null;
        FORMAT_MAP.put(Boolean.TYPE, PlainFormatter.INSTANCE);
        FORMAT_MAP.put(Character.TYPE, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Byte.TYPE, ByteFormatter.INSTANCE);
        FORMAT_MAP.put(Short.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Integer.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Long.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Float.TYPE, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(Double.TYPE, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(boolean[].class, BooleanArrayFormatter.INSTANCE);
        FORMAT_MAP.put(char[].class, CharArrayFormatter.INSTANCE);
        FORMAT_MAP.put(byte[].class, ByteArrayFormatter.INSTANCE);
        FORMAT_MAP.put(short[].class, ShortArrayFormatter.INSTANCE);
        FORMAT_MAP.put(int[].class, IntArrayFormatter.INSTANCE);
        FORMAT_MAP.put(long[].class, LongArrayFormatter.INSTANCE);
        FORMAT_MAP.put(float[].class, FloatArrayFormatter.INSTANCE);
        FORMAT_MAP.put(double[].class, DoubleArrayFormatter.INSTANCE);
        FORMAT_MAP.put(Object[].class, ObjectArrayFormatter.INSTANCE);
        FORMAT_MAP.put(Boolean.class, PlainFormatter.INSTANCE);
        FORMAT_MAP.put(Character.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Byte.class, ByteFormatter.INSTANCE);
        FORMAT_MAP.put(Short.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Integer.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Long.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Float.class, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(Double.class, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(BigInteger.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(BigDecimal.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(String.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Date.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(java.sql.Date.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(Time.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(Timestamp.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(URI.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(URL.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(UUID.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Pattern.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Class.class, ClassFormatter.INSTANCE);
        FORMAT_MAP.put(Locale.class, LocaleFormatter.INSTANCE);
        FORMAT_MAP.put(ArrayList.class, ListFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedList.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(HashSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(TreeSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedHashSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(HashMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(IdentityHashMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(Properties.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(TreeMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedHashMap.class, MapFormatter.INSTANCE);
        FORMAT_LIST.add(EnumFormatter.INSTANCE);
        FORMAT_LIST.add(MapFormatter.INSTANCE);
        FORMAT_LIST.add(ListFormatter.INSTANCE);
        FORMAT_LIST.add(IterableFormatter.INSTANCE);
        FORMAT_LIST.add(ObjectArrayFormatter.INSTANCE);
        FORMAT_LIST.add(StringableFormmatter.INSTANCE);
        FORMAT_LIST.add(DateFormatter.INSTANCE);
        FORMAT_LIST.add(CalendarFormatter.INSTANCE);
        FORMAT_LIST.add(NumberFormatter.INSTANCE);
        FORMAT_LIST.add(IteratorFormatter.INSTANCE);
        FORMAT_LIST.add(EnumerationFormatter.INSTANCE);
        FORMAT_LIST.add(TimeZoneFormatter.INSTANCE);
        FORMAT_LIST.add(CharsetFormatter.INSTANCE);
        object = JSON.getInstance("net.arnx.jsonic.SQLArrayFormatter", classLoader);
        if (object != null) {
            FORMAT_LIST.add((Formatter)object);
        }
        if ((object = JSON.getInstance("net.arnx.jsonic.StructFormmatter", classLoader)) != null) {
            FORMAT_LIST.add((Formatter)object);
        }
        if ((object = JSON.getInstance("net.arnx.jsonic.RowIdFormatter", classLoader)) != null) {
            FORMAT_LIST.add((Formatter)object);
        }
        if ((object = JSON.getInstance("net.arnx.jsonic.ElementNodeFormatter", classLoader)) != null) {
            FORMAT_LIST.add((Formatter)object);
        }
        if ((object = JSON.getInstance("net.arnx.jsonic.TextNodeFormatter", classLoader)) != null) {
            FORMAT_LIST.add((Formatter)object);
        }
        if ((object = JSON.getInstance("net.arnx.jsonic.InetAddressFormatter", classLoader)) != null) {
            FORMAT_LIST.add((Formatter)object);
        }
        if ((object = JSON.getInstance("net.arnx.jsonic.DynaBeanFormatter", classLoader)) != null) {
            FORMAT_LIST.add((Formatter)object);
        }
        CONVERT_MAP.put(Boolean.TYPE, BooleanConverter.INSTANCE);
        CONVERT_MAP.put(Character.TYPE, CharacterConverter.INSTANCE);
        CONVERT_MAP.put(Byte.TYPE, ByteConverter.INSTANCE);
        CONVERT_MAP.put(Short.TYPE, ShortConverter.INSTANCE);
        CONVERT_MAP.put(Integer.TYPE, IntegerConverter.INSTANCE);
        CONVERT_MAP.put(Long.TYPE, LongConverter.INSTANCE);
        CONVERT_MAP.put(Float.TYPE, FloatConverter.INSTANCE);
        CONVERT_MAP.put(Double.TYPE, DoubleConverter.INSTANCE);
        CONVERT_MAP.put(boolean[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(char[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(byte[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(short[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(int[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(long[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(float[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(double[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(Object[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(Boolean.class, BooleanConverter.INSTANCE);
        CONVERT_MAP.put(Character.class, CharacterConverter.INSTANCE);
        CONVERT_MAP.put(Byte.class, ByteConverter.INSTANCE);
        CONVERT_MAP.put(Short.class, ShortConverter.INSTANCE);
        CONVERT_MAP.put(Integer.class, IntegerConverter.INSTANCE);
        CONVERT_MAP.put(Long.class, LongConverter.INSTANCE);
        CONVERT_MAP.put(Float.class, FloatConverter.INSTANCE);
        CONVERT_MAP.put(Double.class, DoubleConverter.INSTANCE);
        CONVERT_MAP.put(BigInteger.class, BigIntegerConverter.INSTANCE);
        CONVERT_MAP.put(BigDecimal.class, BigDecimalConverter.INSTANCE);
        CONVERT_MAP.put(Number.class, BigDecimalConverter.INSTANCE);
        CONVERT_MAP.put(Pattern.class, PatternConverter.INSTANCE);
        CONVERT_MAP.put(TimeZone.class, TimeZoneConverter.INSTANCE);
        CONVERT_MAP.put(Locale.class, LocaleConverter.INSTANCE);
        CONVERT_MAP.put(File.class, FileConverter.INSTANCE);
        CONVERT_MAP.put(URL.class, URLConverter.INSTANCE);
        CONVERT_MAP.put(URI.class, URIConverter.INSTANCE);
        CONVERT_MAP.put(UUID.class, UUIDConverter.INSTANCE);
        CONVERT_MAP.put(Charset.class, CharsetConverter.INSTANCE);
        CONVERT_MAP.put(Class.class, ClassConverter.INSTANCE);
        CONVERT_MAP.put(Date.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(java.sql.Date.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Time.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Timestamp.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Calendar.class, CalendarConverter.INSTANCE);
        CONVERT_MAP.put(Collection.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(Set.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(List.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(ArrayList.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(SortedSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(LinkedList.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(HashSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(TreeSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(LinkedHashSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(Map.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(SortedMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(HashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(IdentityHashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(TreeMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(LinkedHashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(Properties.class, PropertiesConverter.INSTANCE);
        CONVERT_LIST.add(PropertiesConverter.INSTANCE);
        CONVERT_LIST.add(MapConverter.INSTANCE);
        CONVERT_LIST.add(CollectionConverter.INSTANCE);
        CONVERT_LIST.add(ArrayConverter.INSTANCE);
        CONVERT_LIST.add(EnumConverter.INSTANCE);
        CONVERT_LIST.add(DateConverter.INSTANCE);
        CONVERT_LIST.add(CalendarConverter.INSTANCE);
        CONVERT_LIST.add(CalendarConverter.INSTANCE);
        CONVERT_LIST.add(CharSequenceConverter.INSTANCE);
        CONVERT_LIST.add(AppendableConverter.INSTANCE);
        object = JSON.getInstance("net.arnx.jsonic.InetAddressConverter", classLoader);
        if (object != null) {
            CONVERT_LIST.add((Converter)object);
        }
        if ((object = JSON.getInstance("net.arnx.jsonic.NullableConverter", classLoader)) != null) {
            CONVERT_LIST.add((Converter)object);
        }
    }

    private static class State {
        Object key;
        JSONHint hint;

        private State() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Context {
        private final Locale locale;
        private final TimeZone timeZone;
        private final Object contextObject;
        private final int maxDepth;
        private final boolean prettyPrint;
        private final int initialIndent;
        private final String indentText;
        private final boolean suppressNull;
        private final Mode mode;
        private final String numberFormat;
        private final String dateFormat;
        private final NamingStyle propertyStyle;
        private final NamingStyle enumStyle;
        private State[] path;
        private int depth = -1;
        private Map<Class<?>, Object> memberCache;
        private final LocalCache cache;
        JSONHint skipHint;
        int createSizeHint = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Context() {
            JSON jSON2 = JSON.this;
            synchronized (jSON2) {
                this.locale = JSON.this.locale;
                this.timeZone = JSON.this.timeZone;
                this.contextObject = JSON.this.contextObject;
                this.maxDepth = JSON.this.maxDepth;
                this.prettyPrint = JSON.this.prettyPrint;
                this.initialIndent = JSON.this.initialIndent;
                this.indentText = JSON.this.indentText;
                this.suppressNull = JSON.this.suppressNull;
                this.mode = JSON.this.mode;
                this.numberFormat = JSON.this.numberFormat;
                this.dateFormat = JSON.this.dateFormat;
                this.propertyStyle = JSON.this.propertyStyle;
                this.enumStyle = JSON.this.enumStyle;
                this.cache = new LocalCache("net.arnx.jsonic.Messages", this.locale, this.timeZone);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Context(Context context) {
            Context context2 = context;
            synchronized (context2) {
                this.locale = context.locale;
                this.timeZone = context.timeZone;
                this.contextObject = context.contextObject;
                this.maxDepth = context.maxDepth;
                this.prettyPrint = context.prettyPrint;
                this.initialIndent = context.initialIndent;
                this.indentText = context.indentText;
                this.suppressNull = context.suppressNull;
                this.mode = context.mode;
                this.numberFormat = context.numberFormat;
                this.dateFormat = context.dateFormat;
                this.propertyStyle = context.propertyStyle;
                this.enumStyle = context.enumStyle;
                this.depth = context.depth;
                this.path = new State[context.path.length];
                int n = Math.min(this.path.length, context.depth + 1);
                for (int i = 0; i < n; ++i) {
                    this.path[i] = new State();
                    this.path[i].key = context.path[i].key;
                    this.path[i].hint = context.path[i].hint;
                }
                this.cache = context.cache;
            }
        }

        Context copy() {
            return new Context(this);
        }

        public Locale getLocale() {
            return this.locale;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public boolean isPrettyPrint() {
            return this.prettyPrint;
        }

        public int getInitialIndent() {
            return this.initialIndent;
        }

        public String getIndentText() {
            return this.indentText;
        }

        public boolean isSuppressNull() {
            return this.suppressNull;
        }

        public Mode getMode() {
            return this.mode;
        }

        public NamingStyle getPropertyStyle() {
            return this.propertyStyle;
        }

        public NamingStyle getEnumStyle() {
            return this.enumStyle;
        }

        public LocalCache getLocalCache() {
            return this.cache;
        }

        @Deprecated
        public int getLevel() {
            return this.getDepth();
        }

        public int getDepth() {
            return this.depth;
        }

        public Object getKey() {
            return this.path[this.depth].key;
        }

        public Object getKey(int n) {
            if (n < 0) {
                n = this.getDepth() + n;
            }
            if (n <= this.depth) {
                return this.path[n].key;
            }
            return null;
        }

        public JSONHint getHint() {
            return this.path[this.depth].hint;
        }

        public <T> T convert(Object object, Object object2, Class<? extends T> clazz) throws Exception {
            this.enter(object, this.getHint());
            T t = JSON.this.postparse(this, object2, clazz, clazz);
            this.exit();
            return (T)(clazz.isPrimitive() ? PlainConverter.getDefaultValue(clazz).getClass() : clazz).cast(t);
        }

        public Object convert(Object object, Object object2, Type type) throws Exception {
            Class<?> clazz = ClassUtil.getRawType(type);
            this.enter(object, this.getHint());
            Object obj = JSON.this.postparse(this, object2, clazz, type);
            this.exit();
            return (clazz.isPrimitive() ? PlainConverter.getDefaultValue(clazz).getClass() : clazz).cast(obj);
        }

        void enter(Object object, JSONHint jSONHint) {
            Object object2;
            ++this.depth;
            if (this.path == null) {
                this.path = new State[4];
            }
            if (this.depth >= this.path.length) {
                object2 = new State[this.depth * 2];
                System.arraycopy(this.path, 0, object2, 0, this.path.length);
                this.path = object2;
            }
            if ((object2 = this.path[this.depth]) == null) {
                this.path[this.depth] = object2 = new State();
            }
            object2.key = object;
            object2.hint = jSONHint;
        }

        void enter(Object object) {
            this.enter(object, this.getHint());
        }

        void exit() {
            --this.depth;
        }

        void appendIndent(OutputSource outputSource, int n) throws IOException {
            int n2 = this.getInitialIndent() + n;
            for (int i = 0; i < n2; ++i) {
                outputSource.append(this.getIndentText());
            }
        }

        NumberFormat getNumberFormat() {
            JSONHint jSONHint = this.getHint();
            String string = jSONHint != null && jSONHint.format().length() > 0 ? jSONHint.format() : this.numberFormat;
            return string != null ? this.getLocalCache().getNumberFormat(string) : null;
        }

        DateFormat getDateFormat() {
            JSONHint jSONHint = this.getHint();
            String string = jSONHint != null && jSONHint.format().length() > 0 ? jSONHint.format() : this.dateFormat;
            return string != null ? this.getLocalCache().getDateFormat(string) : null;
        }

        Type getParameterType(Type type, Class<?> clazz, int n) {
            return this.getLocalCache().getParameterType(type, clazz, n);
        }

        public String toString() {
            StringBuilderOutputSource stringBuilderOutputSource = new StringBuilderOutputSource(new StringBuilder());
            int n = Math.min(this.depth + 1, this.path.length);
            for (int i = 0; i < n; ++i) {
                State state = this.path[i];
                if (state.key == null) {
                    stringBuilderOutputSource.append("[null]");
                    continue;
                }
                if (state.key instanceof Number) {
                    stringBuilderOutputSource.append('[');
                    stringBuilderOutputSource.append(state.key.toString());
                    stringBuilderOutputSource.append(']');
                    continue;
                }
                if (state.key instanceof Character) {
                    stringBuilderOutputSource.append(state.key.toString());
                    continue;
                }
                String string = state.key.toString();
                boolean bl = false;
                for (int j = 0; j < string.length(); ++j) {
                    if (j == 0) {
                        bl = !Character.isJavaIdentifierStart(string.charAt(j));
                    } else {
                        boolean bl2 = bl = !Character.isJavaIdentifierPart(string.charAt(j));
                    }
                    if (bl) break;
                }
                if (bl) {
                    stringBuilderOutputSource.append('[');
                    try {
                        StringFormatter.serialize(this, string, stringBuilderOutputSource);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    stringBuilderOutputSource.append(']');
                    continue;
                }
                stringBuilderOutputSource.append('.');
                stringBuilderOutputSource.append(string);
            }
            return stringBuilderOutputSource.toString();
        }

        final Object preformatInternal(Object object) {
            if (object == null) {
                return null;
            }
            if (this.getDepth() > this.getMaxDepth()) {
                return null;
            }
            if (JSON.this.getClass() != JSON.class) {
                try {
                    return JSON.this.preformat(this, object);
                }
                catch (Exception exception) {
                    throw new JSONException(this.getMessage("json.format.ConversionError", object, this), 150, exception);
                }
            }
            return object;
        }

        final Formatter formatInternal(Object object, OutputSource outputSource) throws IOException {
            Object object2 = object;
            Formatter formatter = null;
            if (object2 == null) {
                formatter = NullFormatter.INSTANCE;
            } else {
                JSONHint jSONHint = this.getHint();
                if (jSONHint != null) {
                    if (jSONHint.serialized() && jSONHint != this.skipHint) {
                        formatter = PlainFormatter.INSTANCE;
                    } else if (String.class.equals(jSONHint.type())) {
                        formatter = StringFormatter.INSTANCE;
                    } else if (Serializable.class.equals(jSONHint.type())) {
                        formatter = SerializableFormatter.INSTANCE;
                    }
                }
            }
            if (formatter == null) {
                formatter = (Formatter)FORMAT_MAP.get(object2.getClass());
            }
            if (formatter == null && this.memberCache != null) {
                formatter = (Formatter)this.memberCache.get(object2.getClass());
            }
            if (formatter == null) {
                for (Formatter formatter2 : FORMAT_LIST) {
                    if (!formatter2.accept(object2)) continue;
                    formatter = formatter2;
                    break;
                }
                if (formatter == null) {
                    formatter = new ObjectFormatter(object2.getClass());
                }
                if (this.memberCache == null) {
                    this.memberCache = new HashMap();
                }
                this.memberCache.put(object2.getClass(), formatter);
            }
            if (!formatter.isStruct() && this.getDepth() == 0 && this.getMode() != Mode.SCRIPT) {
                throw new JSONException(this.getMessage("json.format.IllegalRootTypeError", new Object[0]), 100);
            }
            try {
                formatter.format(this, object, object2, outputSource);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new JSONException(this.getMessage("json.format.ConversionError", object instanceof CharSequence ? "\"" + object + "\"" : object, this), 100, exception);
            }
            return formatter;
        }

        <T> T postparseInternal(Object object, Class<? extends T> clazz, Type type) throws Exception {
            return JSON.this.postparse(this, object, clazz, type);
        }

        <T> T convertInternal(Object object, Type type) throws JSONException {
            if (type instanceof TypeReference) {
                type = ((TypeReference)type).getType();
            }
            Class<?> clazz = ClassUtil.getRawType(type);
            T t = null;
            try {
                this.enter(ROOT, null);
                t = (T)JSON.this.postparse(this, object, clazz, type);
                this.exit();
            }
            catch (Exception exception) {
                String string;
                if (object instanceof CharSequence) {
                    string = "\"" + object + "\"";
                } else {
                    try {
                        string = object.toString();
                    }
                    catch (Exception exception2) {
                        string = object.getClass().toString();
                    }
                }
                throw new JSONException(this.getMessage("json.parse.ConversionError", string, type, this), 250, exception);
            }
            return t;
        }

        <T> T createInternal(Class<? extends T> clazz) throws Exception {
            return JSON.this.create(this, clazz);
        }

        boolean ignoreInternal(Class<?> clazz, Member member) {
            return JSON.this.ignore(this, clazz, member);
        }

        String normalizeInternal(String string) {
            return JSON.this.normalize(string);
        }

        String getMessage(String string, Object ... objectArray) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("net.arnx.jsonic.Messages", this.locale);
            return MessageFormat.format(resourceBundle.getString(string), objectArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        TRADITIONAL,
        STRICT,
        SCRIPT;

    }
}

