/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.web.ExternalContext;
import net.arnx.jsonic.web.GatewayFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container {
    public Boolean debug;
    public String init = "init";
    public String destroy = "destroy";
    public String encoding;
    public Boolean expire;
    public boolean namingConversion = true;
    public Class<? extends JSON> processor;
    protected ServletConfig config;
    protected ServletContext context;
    protected HttpServlet servlet;

    public void init(HttpServlet httpServlet) throws ServletException {
        this.servlet = httpServlet;
        this.config = httpServlet.getServletConfig();
        this.context = httpServlet.getServletContext();
    }

    public void start(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.encoding;
        Boolean bl = this.expire;
        GatewayFilter.Config config = (GatewayFilter.Config)httpServletRequest.getAttribute(GatewayFilter.GATEWAY_KEY);
        if (config != null) {
            if (string == null) {
                string = config.encoding;
            }
            if (bl == null) {
                bl = config.expire;
            }
        }
        if (string == null) {
            string = "UTF-8";
        }
        if (bl == null) {
            bl = true;
        }
        if (string != null) {
            httpServletRequest.setCharacterEncoding(string);
            httpServletResponse.setCharacterEncoding(string);
        }
        if (bl != null && bl.booleanValue()) {
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            httpServletResponse.setHeader("Pragma", "no-cache");
            httpServletResponse.setHeader("Expires", "Tue, 29 Feb 2000 12:00:00 GMT");
        }
    }

    public Object getComponent(String string) throws Exception {
        Object obj = this.findClass(string).newInstance();
        for (Field field : obj.getClass().getFields()) {
            Class<?> clazz = field.getType();
            if ("config".equals(field.getName()) && ServletConfig.class.equals(clazz)) {
                field.set(obj, ExternalContext.getConfig());
                continue;
            }
            if ("application".equals(field.getName()) && ServletContext.class.equals(clazz)) {
                field.set(obj, ExternalContext.getApplication());
                continue;
            }
            if ("request".equals(field.getName()) && HttpServletRequest.class.equals(clazz)) {
                field.set(obj, ExternalContext.getRequest());
                continue;
            }
            if ("response".equals(field.getName()) && HttpServletResponse.class.equals(clazz)) {
                field.set(obj, ExternalContext.getResponse());
                continue;
            }
            if (!"session".equals(field.getName()) || !HttpSession.class.equals(clazz)) continue;
            field.set(obj, ExternalContext.getSession());
        }
        return obj;
    }

    public Method getMethod(Object object, String string, List<?> list) throws NoSuchMethodException {
        if (list == null) {
            list = Collections.emptyList();
        }
        if (this.namingConversion) {
            string = ClassUtil.toLowerCamel(string);
        }
        if (string.equals(this.init) || string.equals(this.destroy)) {
            this.debug("Method name is same init or destroy method name.");
            return null;
        }
        Class<?> clazz = object.getClass();
        Method method = null;
        Class<?>[] classArray = null;
        Method method2 = null;
        Class<?>[] classArray2 = null;
        for (Method method3 : clazz.getMethods()) {
            if (Modifier.isStatic(method3.getModifiers()) || method3.isSynthetic() || method3.isBridge() || !method3.getName().equals(string)) continue;
            Class<?>[] classArray3 = method3.getParameterTypes();
            if (method3.isVarArgs()) {
                int n;
                if (classArray3.length - 1 > list.size()) continue;
                Class<?> clazz2 = classArray3[classArray3.length - 1].getComponentType();
                Class[] classArray4 = new Class[list.size()];
                System.arraycopy(classArray4, 0, classArray3, 0, classArray3.length - 1);
                for (n = classArray3.length - 1; n < classArray4.length; ++n) {
                    classArray4[n] = clazz2;
                }
                classArray3 = classArray4;
                if (method2 == null || classArray3.length > classArray2.length) {
                    method2 = method3;
                    classArray2 = classArray3;
                    continue;
                }
                n = Container.calcurateDistance(classArray2, list);
                int n2 = Container.calcurateDistance(classArray3, list);
                if (n2 > n) {
                    method2 = method3;
                    classArray2 = classArray3;
                    continue;
                }
                if (n2 != n) continue;
                method2 = null;
                continue;
            }
            if (classArray3.length > list.size() || classArray != null && classArray3.length < classArray.length) continue;
            if (method == null || classArray3.length > classArray.length) {
                method = method3;
                classArray = classArray3;
                continue;
            }
            int n = Container.calcurateDistance(classArray, list);
            int n3 = Container.calcurateDistance(classArray3, list);
            if (n3 > n) {
                method = method3;
                classArray = classArray3;
                continue;
            }
            if (n3 != n) continue;
            method = null;
        }
        if (method2 != null) {
            if (method == null) {
                method = method2;
            } else {
                int n = Container.calcurateDistance(classArray, list);
                int n4 = Container.calcurateDistance(classArray2, list);
                if (n4 > n) {
                    method = method2;
                }
            }
        }
        if (method == null || this.limit(clazz, method)) {
            this.debug("method missing: " + Container.toPrintString(clazz, string, list));
            return null;
        }
        return method;
    }

    public Object[] preinvoke(Object object, Method method, Object ... objectArray) throws Exception {
        return objectArray;
    }

    public Object execute(JSON jSON, Object object, Method method, List<?> list) throws Exception {
        Object object2 = null;
        Method method2 = null;
        Method method3 = null;
        if (this.init != null || this.destroy != null) {
            boolean bl = false;
            boolean bl2 = false;
            for (Method method4 : object.getClass().getMethods()) {
                if (Modifier.isStatic(method4.getModifiers()) || method4.isSynthetic() || method4.isBridge()) continue;
                if (method4.getName().equals(this.init)) {
                    if (method4.getReturnType().equals(Void.TYPE) && method4.getParameterTypes().length == 0) {
                        method2 = method4;
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (!method4.getName().equals(this.destroy)) continue;
                if (method4.getReturnType().equals(Void.TYPE) && method4.getParameterTypes().length == 0) {
                    method3 = method4;
                    continue;
                }
                bl2 = true;
            }
            if (bl) {
                this.debug("Notice: init method must have no arguments.");
            }
            if (bl2) {
                this.debug("Notice: destroy method must have no arguments.");
            }
        }
        Type[] typeArray = method.getGenericParameterTypes();
        Object[] objectArray = new Object[typeArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = i == objectArray.length - 1 && method.isVarArgs() ? jSON.convert(list.subList(i < list.size() ? i : list.size(), list.size()), typeArray[i]) : jSON.convert(i < list.size() ? list.get(i) : null, typeArray[i]);
        }
        if (this.isDebugMode()) {
            this.debug("Execute: " + Container.toPrintString(object.getClass(), method.getName(), Arrays.asList(objectArray)));
        }
        if (method2 != null) {
            if (this.isDebugMode()) {
                this.debug("Execute: " + Container.toPrintString(object.getClass(), method2.getName(), null));
            }
            method2.invoke(object, new Object[0]);
        }
        objectArray = this.preinvoke(object, method, objectArray);
        object2 = method.invoke(object, objectArray);
        object2 = this.postinvoke(object, method, object2);
        if (method3 != null) {
            if (this.isDebugMode()) {
                this.debug("Execute: " + Container.toPrintString(object.getClass(), method3.getName(), null));
            }
            method3.invoke(object, new Object[0]);
        }
        return object2;
    }

    public Object postinvoke(Object object, Method method, Object object2) throws Exception {
        return object2;
    }

    public void end(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    public void destory() {
    }

    protected Class<?> findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(string, true, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException2) {
                clazz = Class.forName(string);
            }
        }
        return clazz;
    }

    protected boolean limit(Class<?> clazz, Method method) {
        return method.getDeclaringClass().equals(Object.class);
    }

    public boolean isDebugMode() {
        return this.debug != null ? this.debug : false;
    }

    public void debug(String string) {
        this.debug(string, null);
    }

    public void debug(String string, Throwable throwable) {
        if (!this.isDebugMode()) {
            return;
        }
        if (throwable != null) {
            this.context.log("[DEBUG] " + string, throwable);
        } else {
            this.context.log("[DEBUG] " + string);
        }
    }

    public void warn(String string) {
        this.warn(string, null);
    }

    public void warn(String string, Throwable throwable) {
        if (!this.isDebugMode()) {
            return;
        }
        if (throwable != null) {
            this.context.log("[WARNING] " + string, throwable);
        } else {
            this.context.log("[WARNING] " + string);
        }
    }

    public void error(String string, Throwable throwable) {
        if (throwable != null) {
            this.context.log("[ERROR] " + string, throwable);
        } else {
            this.context.log("[ERROR] " + string);
        }
    }

    JSON createJSON(Locale locale) throws ServletException {
        try {
            JSON jSON = this.processor != null ? this.processor.newInstance() : new JSON(){

                @Override
                protected boolean ignore(JSON.Context context, Class<?> clazz, Member member) {
                    return member.getDeclaringClass().equals(Throwable.class) || super.ignore(context, clazz, member);
                }
            };
            jSON.setLocale(locale);
            return jSON;
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    static boolean isJSONType(String string) {
        if (string != null) {
            return (string = string.toLowerCase()).equals("application/json") || string.startsWith("application/json;");
        }
        return false;
    }

    static int calcurateDistance(Class<?>[] classArray, List<?> list) {
        int n = 0;
        for (int i = 0; i < classArray.length; ++i) {
            Object obj = list.get(i);
            if (obj == null) continue;
            if (obj instanceof String) {
                if (String.class.equals(classArray[i])) {
                    n += 10;
                    continue;
                }
                if (classArray[i].isAssignableFrom(String.class)) {
                    n += 9;
                    continue;
                }
                if (classArray[i].isPrimitive() || Boolean.class.equals(classArray[i]) || CharSequence.class.isAssignableFrom(classArray[i]) || Character.class.isAssignableFrom(classArray[i]) || Number.class.isAssignableFrom(classArray[i]) || Date.class.isAssignableFrom(classArray[i]) || Calendar.class.isAssignableFrom(classArray[i]) || Locale.class.equals(classArray[i]) || TimeZone.class.equals(classArray[i]) || Pattern.class.equals(classArray[i]) || Charset.class.equals(classArray[i]) || URI.class.equals(classArray[i]) || URL.class.equals(classArray[i]) || UUID.class.equals(classArray[i])) {
                    n += 8;
                    continue;
                }
                if (!Object.class.equals(classArray[i])) continue;
                ++n;
                continue;
            }
            if (obj instanceof Number) {
                if (Byte.TYPE.equals(classArray[i]) || Short.TYPE.equals(classArray[i]) || Integer.TYPE.equals(classArray[i]) || Long.TYPE.equals(classArray[i]) || Double.TYPE.equals(classArray[i]) || Number.class.isAssignableFrom(classArray[i])) {
                    n += 10;
                    continue;
                }
                if (classArray[i].isAssignableFrom(BigDecimal.class)) {
                    n += 9;
                    continue;
                }
                if (classArray[i].isPrimitive() || CharSequence.class.isAssignableFrom(classArray[i]) || Character.class.equals(classArray[i]) || Boolean.class.equals(classArray[i]) || Date.class.isAssignableFrom(classArray[i]) || Calendar.class.isAssignableFrom(classArray[i])) {
                    n += 8;
                    continue;
                }
                if (!Object.class.equals(classArray[i])) continue;
                ++n;
                continue;
            }
            if (obj instanceof Boolean) {
                if (Boolean.TYPE.equals(classArray[i]) || Boolean.class.equals(classArray[i])) {
                    n += 10;
                    continue;
                }
                if (classArray[i].isAssignableFrom(Boolean.class)) {
                    n += 9;
                    continue;
                }
                if (classArray[i].isPrimitive() || Number.class.isAssignableFrom(classArray[i]) || CharSequence.class.isAssignableFrom(classArray[i]) || Character.class.equals(classArray[i])) {
                    n += 8;
                    continue;
                }
                if (!Object.class.equals(classArray[i])) continue;
                ++n;
                continue;
            }
            if (obj instanceof List) {
                if (Collection.class.isAssignableFrom(classArray[i]) || classArray[i].isArray()) {
                    n += 10;
                    continue;
                }
                if (classArray[i].isAssignableFrom(ArrayList.class)) {
                    n += 9;
                    continue;
                }
                if (Map.class.isAssignableFrom(classArray[i])) {
                    n += 8;
                    continue;
                }
                if (!Object.class.equals(classArray[i])) continue;
                ++n;
                continue;
            }
            if (!(obj instanceof Map)) continue;
            if (Map.class.isAssignableFrom(classArray[i])) {
                n += 10;
                continue;
            }
            if (classArray[i].isAssignableFrom(LinkedHashMap.class)) {
                n += 9;
                continue;
            }
            if (List.class.isAssignableFrom(classArray[i]) || classArray[i].isArray()) {
                n += 8;
                continue;
            }
            if (!(classArray[i].isPrimitive() || Boolean.class.equals(classArray[i]) || CharSequence.class.isAssignableFrom(classArray[i]) || Character.class.isAssignableFrom(classArray[i]) || Number.class.isAssignableFrom(classArray[i]) || Date.class.isAssignableFrom(classArray[i]) || Calendar.class.isAssignableFrom(classArray[i]) || Locale.class.equals(classArray[i]) || TimeZone.class.equals(classArray[i]) || Pattern.class.equals(classArray[i]) || Charset.class.equals(classArray[i]) || URI.class.equals(classArray[i]) || URL.class.equals(classArray[i]) || UUID.class.equals(classArray[i]))) {
                n += 8;
                continue;
            }
            if (!Object.class.equals(classArray[i])) continue;
            ++n;
        }
        return n;
    }

    static String toPrintString(Class<?> clazz, String string, List<?> list) {
        StringBuilder stringBuilder = new StringBuilder(clazz.getName());
        stringBuilder.append('#').append(string).append('(');
        if (list != null) {
            String string2 = JSON.encode(list);
            stringBuilder.append(string2, 1, string2.length() - 1);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    static <T> T cast(Object object) {
        return (T)object;
    }
}

