/*
 * Decompiled with CFR 0.152.
 */
package com.kjetland.jackson.jsonSchema;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubclassesResolver {
    private static final Logger log = LoggerFactory.getLogger(SubclassesResolver.class);
    private ScanResult scanResult;

    public SubclassesResolver() {
        this(null);
    }

    public SubclassesResolver(List<String> packagesToScan, List<String> classesToScan) {
        this(SubclassesResolver.buildClassGraph(packagesToScan, classesToScan));
    }

    public SubclassesResolver(ClassGraph classGraph) {
        if (classGraph == null) {
            log.debug("Entire classpath will be scanned because SubclassesResolver is not configured. See https://github.com/mbknor/mbknor-jackson-jsonSchema#subclass-resolving-using-reflection");
            classGraph = new ClassGraph();
        }
        this.scanResult = classGraph.enableClassInfo().scan();
    }

    public List<Class<?>> getSubclasses(Class<?> clazz) {
        if (clazz.isInterface()) {
            return this.scanResult.getClassesImplementing(clazz.getName()).loadClasses();
        }
        return this.scanResult.getSubclasses(clazz.getName()).loadClasses();
    }

    private static ClassGraph buildClassGraph(List<String> packagesToScan, List<String> classesToScan) {
        if (packagesToScan == null && classesToScan == null) {
            return null;
        }
        ClassGraph classGraph = new ClassGraph();
        if (packagesToScan != null) {
            classGraph.whitelistPackages((String[])packagesToScan.toArray(String[]::new));
        }
        if (classesToScan != null) {
            classGraph.whitelistClasses((String[])classesToScan.toArray(String[]::new));
        }
        return classGraph;
    }
}

