<?xml version="1.0"?>
<!--
 Copyright (C) MX4J.
 All rights reserved.

 This software is distributed under the terms of the MX4J License version 1.0.
 See the terms of the MX4J License in the documentation provided with this software.

 Author: Carlos Quiroz (tibu@users.sourceforge.net)
 Revision: $Revision: 1.2 $
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" indent="yes" encoding="UTF-8"/>

	<xsl:param name="html.stylesheet">stylesheet.css</xsl:param>
	<xsl:param name="html.stylesheet.type">text/css</xsl:param>

	<xsl:template match="MBean" name="mbean">
		<xsl:for-each select="MBean">
			<tr>
			<xsl:if test="(position() mod 2)=1">
				<td class="darkline">
					<xsl:variable name="objectname" select="."/>
					<a href="mbean?objectname={$objectname}"><xsl:value-of select="$objectname"/></a>
				</td>
			</xsl:if>
			<xsl:if test="(position() mod 2)=0">
				<td class="clearline">
					<xsl:variable name="objectname" select="."/>
					<a href="mbean?objectname={$objectname}"><xsl:value-of select="$objectname"/></a>
				</td>
			</xsl:if>
			</tr>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="Server">
		<html>
			<xsl:call-template name="head"/>
			<body>
				<body>
				<xsl:call-template name="toprow"/>
				<xsl:call-template name="tabs">
					<xsl:with-param name="selection">mbean</xsl:with-param>
				</xsl:call-template>
				<table width="100%" cellpadding="0" cellspacing="0" border="0">
					<tr><td colspan="2" class="darker"/></tr>
					<tr>
						<td colspan="2" class="topheading">
							<div align="left">
								<img src="logo.gif" width="194" alt="MX4J logo"/>
							</div>
						</td>
					</tr>
					<tr>
						<td colspan="1" class="topheading">
							<div align="left" class="sectionheading">
								Server View
							</div>
						</td>
						<td colspan="1" class="topheading">
							<div align="right" class="sectionheading">
								<a href="#">Filter expression</a>
								<form action="server" align="right">
									<input type="text" name="filter"/>
									<input type="submit" value="Filter"/>
								</form>
							</div>
						</td>
					</tr>
					<tr><td colspan="2" class="darker"/></tr>
				</table>
				<div class="tocheading">MBean List:</div>
				<table width="100%" cellpadding="0" cellspacing="0" border="0">
					<xsl:call-template name="mbean"/>
					<tr><td colspan="2" class="darker"/></tr>
				</table>
			</body>
	</html>
</xsl:template>
</xsl:stylesheet>

