<?xml version="1.0"?>
<!--
 Copyright (C) MX4J.
 All rights reserved.

 This software is distributed under the terms of the MX4J License version 1.0.
 See the terms of the MX4J License in the documentation provided with this software.

 Author: Carlos Quiroz (tibu@users.sourceforge.net)
 Revision: $Revision: 1.2 $
 																																					-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" indent="yes" encoding="UTF-8"/>

	<xsl:template name="raw-input">
    <xsl:param name="type"/>
    <xsl:param name="value"/>
    <xsl:param name="name"/>

    <xsl:variable name="result">none</xsl:variable>
    <xsl:choose>
      <xsl:when test="$type='java.lang.String'
        or $type='java.lang.Double'
        or $type='java.lang.Short'
        or $type='java.lang.Integer'
        or $type='java.lang.Long'
        or $type='java.lang.Float'
        or $type='java.lang.Byte'
				or $type='javax.management.ObjectName'
        or $type='int'
        or $type='short'
        or $type='byte'
        or $type='double'
        or $type='float'">
        <input type="text" name="{$name}" value="{$value}"/>
      </xsl:when>
      <xsl:when test="$type='java.lang.Boolean'
        or $type='boolean'">
				<xsl:if test="$value='true'">checked
					<input name="{$name}" type="radio" checked="checked">true </input>
					<input name="{$name}" type="radio">false </input>
				</xsl:if>
				<xsl:if test="$value='false'">
					<input name="{$name}" type="radio">true </input>
					<input name="{$name}" type="radio" checked="checked">false </input>
				</xsl:if>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

	<xsl:template match="Attribute" name="RW">
		<xsl:param name="class">clearline</xsl:param>
		<td class="{$class}" align="right">
		<xsl:value-of select="@value"/>
		</td>
		<td align="right" class="{$class}">
			<p>
				<xsl:call-template name="form">
					<xsl:with-param name="value" select="@value"/>
				</xsl:call-template>
			</p>
		</td>
	</xsl:template>

	<xsl:template match="Attribute" name="RO">
		<xsl:param name="class">clearline</xsl:param>
		<td class="{$class}" align="right">
    	<xsl:value-of select="@value"/>
    </td>
    <td align="right" class="{$class}">
    	Read-only attribute
    </td>
	</xsl:template>

	<xsl:template match="Attribute[@type]" name="form">
		<xsl:param name="value"/>
		<xsl:choose>
			<xsl:when test="@type='java.lang.String'
				or @type='java.lang.String'
				or @type='java.lang.Double'
				or @type='java.lang.Short'
				or @type='java.lang.Integer'
				or @type='java.lang.Long'
				or @type='java.lang.Float'
				or @type='java.lang.Byte'
				or @type='java.lang.Booleam'
				or @type='javax.management.ObjectName'
				or @type='int'
				or @type='short'
				or @type='byte'
				or @type='double'
				or @type='boolean'
				or @type='float'">
				<xsl:variable name="name" select="@name"/>
				<form action="setattribute" method="get">
						<input type="hidden" name="attribute" value="{$name}"/>
						<input type="hidden" name="objectname" value="{$request.objectname}"/>
						<xsl:call-template name="raw-input">
							<xsl:with-param name="type" select="@type"/>
							<xsl:with-param name="value" select="$value"/>
							<xsl:with-param name="name">value</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="submit"/>
				</form>
			</xsl:when>
			<xsl:otherwise>
				Uknown type
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="Attribute[@type]" name="submit">
		<xsl:if test="@type='java.lang.String'
			or @type='java.lang.String'
			or @type='java.lang.Double'
			or @type='java.lang.Short'
			or @type='java.lang.Integer'
			or @type='java.lang.Long'
			or @type='java.lang.Float'
			or @type='java.lang.Byte'
			or @type='java.lang.Boolean'
			or @type='javax.management.ObjectName'
			or @type='int'
			or @type='short'
			or @type='boolean'
			or @type='byte'
			or @type='double'
			or @type='float'">
			<input type="submit" value="Set"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="Attribute" name="WO">
		<xsl:param name="class">clearline</xsl:param>

		<td align="right" class="{$class}">Write-only attribute</td>
			<td align="right" class="{$class}">
			<p><xsl:call-template name="form"/></p></td>
	</xsl:template>

  <xsl:template name="attribute">
  	<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td width="20%" align="left" class="darkline">
					<div class="tableheader">Name</div>
				</td>
				<td width="20%" align="left" class="darkline">
					<div class="tableheader">Description</div>
				</td>
				<td width="20%" align="left" class="darkline">
					<div class="tableheader">Type</div>
				</td>
				<td width="20%" align="right" class="darkline">
					<div class="tableheader">Value</div>
				</td>
				<td width="*" align="right" class="darkline">
					<div class="tableheader">New Value</div>
				</td>
			</tr>
      <xsl:for-each select="Attribute">
				<xsl:sort data-type="text" order="ascending" select="@name"/>
        <tr>
          <xsl:variable name="classtype">
            <xsl:if test="(position() mod 2)=1">clearline</xsl:if>
            <xsl:if test="(position() mod 2)=0">darkline</xsl:if>
          </xsl:variable>
          <td class="{$classtype}">
						<xsl:value-of select="@name"/>
          </td>
					<td class="{$classtype}">
            <xsl:value-of select="@description"/>
          </td>
          <td class="{$classtype}">
            <xsl:value-of select="@type"/>
          </td>
					<xsl:choose>
						<xsl:when test="@availability='RO'">
							<xsl:call-template name="RO">
								<xsl:with-param name="class" select="$classtype"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="@availability='RW'">
							<xsl:call-template name="RW">
								<xsl:with-param name="class" select="$classtype"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="@availability='WO'">
							<xsl:call-template name="WO">
								<xsl:with-param name="class" select="$classtype"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
        </tr>
      </xsl:for-each>
			<tr>
				<!--<td colspan="4" width="100%" class="fronttab" align="right">
					<form>
						<input type="submit" value="Set all"/>
					</form>
				</td>-->
			</tr>
    </table>
  </xsl:template>
</xsl:stylesheet>
