/*
 * Decompiled with CFR 0.152.
 */
package mx4j.examples.remote.interception;

import java.io.ObjectInputStream;
import java.security.AccessController;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.MBeanServerForwarder;
import javax.security.auth.Subject;

public class SubjectTrackingMBeanServer
implements MBeanServerForwarder {
    private MBeanServer server;

    public synchronized MBeanServer getMBeanServer() {
        return this.server;
    }

    public synchronized void setMBeanServer(MBeanServer server) throws IllegalArgumentException {
        if (server == null) {
            throw new IllegalArgumentException("Cannot forward to a null MBeanServer");
        }
        this.server = server;
    }

    private void trackSubject() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        System.out.println("Subject = " + subject);
    }

    public void addNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.trackSubject();
        this.getMBeanServer().addNotificationListener(observed, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.trackSubject();
        this.getMBeanServer().addNotificationListener(observed, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.trackSubject();
        this.getMBeanServer().removeNotificationListener(observed, listener);
    }

    public void removeNotificationListener(ObjectName observed, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.trackSubject();
        this.getMBeanServer().removeNotificationListener(observed, listener);
    }

    public void removeNotificationListener(ObjectName observed, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.trackSubject();
        this.getMBeanServer().removeNotificationListener(observed, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName observed, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.trackSubject();
        this.getMBeanServer().removeNotificationListener(observed, listener, filter, handback);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.trackSubject();
        return this.getMBeanServer().getMBeanInfo(objectName);
    }

    public boolean isInstanceOf(ObjectName objectName, String className) throws InstanceNotFoundException {
        this.trackSubject();
        return this.getMBeanServer().isInstanceOf(objectName, className);
    }

    public String[] getDomains() {
        this.trackSubject();
        return this.getMBeanServer().getDomains();
    }

    public String getDefaultDomain() {
        this.trackSubject();
        return this.getMBeanServer().getDefaultDomain();
    }

    public ObjectInstance createMBean(String className, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.trackSubject();
        return this.getMBeanServer().createMBean(className, objectName);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.trackSubject();
        return this.getMBeanServer().createMBean(className, objectName, loaderName);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.trackSubject();
        return this.getMBeanServer().createMBean(className, objectName, args, parameters);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.trackSubject();
        return this.getMBeanServer().createMBean(className, objectName, loaderName, args, parameters);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.trackSubject();
        this.getMBeanServer().unregisterMBean(objectName);
    }

    public Object getAttribute(ObjectName objectName, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        this.trackSubject();
        return this.getMBeanServer().getAttribute(objectName, attribute);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.trackSubject();
        this.getMBeanServer().setAttribute(objectName, attribute);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        this.trackSubject();
        return this.getMBeanServer().getAttributes(objectName, attributes);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        this.trackSubject();
        return this.getMBeanServer().setAttributes(objectName, attributes);
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] parameters) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.trackSubject();
        return this.getMBeanServer().invoke(objectName, methodName, args, parameters);
    }

    public Integer getMBeanCount() {
        this.trackSubject();
        return this.getMBeanServer().getMBeanCount();
    }

    public boolean isRegistered(ObjectName objectname) {
        this.trackSubject();
        return this.getMBeanServer().isRegistered(objectname);
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        this.trackSubject();
        return this.getMBeanServer().getObjectInstance(objectName);
    }

    public Set queryMBeans(ObjectName patternName, QueryExp filter) {
        this.trackSubject();
        return this.getMBeanServer().queryMBeans(patternName, filter);
    }

    public Set queryNames(ObjectName patternName, QueryExp filter) {
        this.trackSubject();
        return this.getMBeanServer().queryNames(patternName, filter);
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        this.trackSubject();
        return this.getMBeanServer().instantiate(className);
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        this.trackSubject();
        return this.getMBeanServer().instantiate(className, loaderName);
    }

    public Object instantiate(String className, Object[] args, String[] parameters) throws ReflectionException, MBeanException {
        this.trackSubject();
        return this.getMBeanServer().instantiate(className, args, parameters);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, MBeanException, InstanceNotFoundException {
        this.trackSubject();
        return this.getMBeanServer().instantiate(className, loaderName, args, parameters);
    }

    public ObjectInstance registerMBean(Object mbean, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.trackSubject();
        return this.registerMBean(mbean, objectName);
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] bytes) throws InstanceNotFoundException, OperationsException, ReflectionException {
        this.trackSubject();
        return this.getMBeanServer().deserialize(className, loaderName, bytes);
    }

    public ObjectInputStream deserialize(String className, byte[] bytes) throws OperationsException, ReflectionException {
        this.trackSubject();
        return this.getMBeanServer().deserialize(className, bytes);
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] bytes) throws InstanceNotFoundException, OperationsException {
        this.trackSubject();
        return this.getMBeanServer().deserialize(objectName, bytes);
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        this.trackSubject();
        return this.getMBeanServer().getClassLoaderFor(mbeanName);
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        this.trackSubject();
        return this.getMBeanServer().getClassLoader(loaderName);
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        this.trackSubject();
        return this.getMBeanServer().getClassLoaderRepository();
    }
}

