/*
 * Decompiled with CFR 0.152.
 */
package mx4j.examples.mbeans.rmi;

import java.rmi.RemoteException;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import javax.naming.InitialContext;
import mx4j.examples.mbeans.rmi.MyRemoteService;
import mx4j.examples.mbeans.rmi.MyRemoteServiceObjectMBean;

public class MyRemoteServiceObject
extends RemoteServer
implements MyRemoteService,
MyRemoteServiceObjectMBean {
    private boolean m_running;

    public void sayHello(String name) throws RemoteException {
        System.out.println("Hello, " + name);
    }

    public void start() throws Exception {
        if (!this.m_running) {
            UnicastRemoteObject.exportObject(this);
            InitialContext ctx = new InitialContext();
            ctx.rebind("rmi://localhost:1099/my-service", (Object)this);
            this.m_running = true;
            System.out.println("My remote service started successfully");
        }
    }

    public void stop() throws Exception {
        if (this.m_running) {
            InitialContext ctx = new InitialContext();
            ctx.unbind("rmi://localhost:1099/my-service");
            UnicastRemoteObject.unexportObject(this, false);
            this.m_running = false;
            System.out.println("My remote service stopped successfully");
        }
    }

    public boolean isRunning() {
        return this.m_running;
    }
}

