/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.preference;

import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.RestrictTo;
import moe.shizuku.preference.EditTextPreference;
import moe.shizuku.preference.PreferenceDialogFragment;

public class EditTextPreferenceDialogFragment
extends PreferenceDialogFragment {
    private EditText mEditText;

    @Override
    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
        this.mEditText = (EditText)view.findViewById(16908291);
        if (this.mEditText == null) {
            throw new IllegalStateException("Dialog view must contain an EditText with id @android:id/edit");
        }
        this.mEditText.setSingleLine(this.getEditTextPreference().isSingleLine());
        this.mEditText.setSelectAllOnFocus(this.getEditTextPreference().isSelectAllOnFocus());
        if (this.getEditTextPreference().getInputType() != 1) {
            this.mEditText.setInputType(this.getEditTextPreference().getInputType());
        }
        this.mEditText.setHint((CharSequence)this.getEditTextPreference().getHint());
        this.mEditText.setText((CharSequence)this.getEditTextPreference().getText());
        this.mEditText.requestFocus();
        this.mEditText.post(new Runnable(){

            @Override
            public void run() {
                InputMethodManager imm = (InputMethodManager)EditTextPreferenceDialogFragment.this.getActivity().getSystemService("input_method");
                imm.showSoftInput((View)EditTextPreferenceDialogFragment.this.mEditText, 1);
            }
        });
        if (this.getEditTextPreference().isCommitOnEnter()) {
            this.mEditText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView v, int keyCode, KeyEvent event) {
                    if (keyCode == 6) {
                        EditTextPreferenceDialogFragment.this.onClick((DialogInterface)EditTextPreferenceDialogFragment.this.getDialog(), -1);
                        EditTextPreferenceDialogFragment.this.dismiss();
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private EditTextPreference getEditTextPreference() {
        return (EditTextPreference)this.getPreference();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean needInputMethod() {
        return true;
    }

    @Override
    public void onDialogClosed(boolean positiveResult) {
        if (positiveResult) {
            String value = this.mEditText.getText().toString();
            if (this.getEditTextPreference().callChangeListener(value)) {
                this.getEditTextPreference().setText(value);
            }
        }
    }
}

