/*
 * Decompiled with CFR 0.152.
 */
package moe.feng.common.stepperview;

import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.view.View;

class ViewUtils {
    ViewUtils() {
    }

    @ColorInt
    static int getColorFromAttr(Context context, @AttrRes int attr) {
        TypedArray array = context.getTheme().obtainStyledAttributes(new int[]{attr});
        int color = array.getColor(0, 0);
        array.recycle();
        return color;
    }

    static ObjectAnimator createArgbAnimator(View view, String propertyName, int startColor, int endColor) {
        if (Build.VERSION.SDK_INT < 21) {
            return ObjectAnimator.ofObject((Object)view, (String)propertyName, (TypeEvaluator)new TypeEvaluator(){

                public Object evaluate(float fraction, Object startValue, Object endValue) {
                    int startInt = (Integer)startValue;
                    int startA = startInt >> 24 & 0xFF;
                    int startR = startInt >> 16 & 0xFF;
                    int startG = startInt >> 8 & 0xFF;
                    int startB = startInt & 0xFF;
                    int endInt = (Integer)endValue;
                    int endA = endInt >> 24 & 0xFF;
                    int endR = endInt >> 16 & 0xFF;
                    int endG = endInt >> 8 & 0xFF;
                    int endB = endInt & 0xFF;
                    return startA + (int)(fraction * (float)(endA - startA)) << 24 | startR + (int)(fraction * (float)(endR - startR)) << 16 | startG + (int)(fraction * (float)(endG - startG)) << 8 | startB + (int)(fraction * (float)(endB - startB));
                }
            }, (Object[])new Object[]{startColor, endColor});
        }
        return ObjectAnimator.ofArgb((Object)view, (String)propertyName, (int[])new int[]{startColor, endColor});
    }
}

