/*
 * Decompiled with CFR 0.152.
 */
package moe.feng.common.stepperview;

import android.animation.LayoutTransition;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.ViewTreeObserver;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import moe.feng.common.stepperview.R;
import moe.feng.common.stepperview.ViewUtils;

public class VerticalStepperItemView
extends FrameLayout {
    private View mPointBackground;
    private View mLineView;
    private TextView mPointNumber;
    private TextView mTitleText;
    private TextView mSummaryText;
    private FrameLayout mCustomView;
    private FrameLayout mPointFrame;
    private LinearLayout mRightContainer;
    private ImageView mDoneIconView;
    private ImageView mErrorIconView;
    private View mMarginBottomView;
    private ValueAnimator mTitleColorAnimator;
    private ValueAnimator mSummaryColorAnimator;
    private ValueAnimator mPointColorAnimator;
    private ViewPropertyAnimator mPointAnimator;
    private ViewPropertyAnimator mErrorIconAnimator;
    private CharSequence mTitle;
    @Nullable
    private CharSequence mSummary;
    @Nullable
    private CharSequence mSummaryFinished = null;
    private int mIndex = 1;
    private boolean isLastStep = false;
    private int mState = 0;
    private CharSequence mErrorText = null;
    private int mAnimationDuration;
    private int mNormalColor;
    private int mActivatedColor;
    private int mLineColor;
    private int mErrorColor;
    private Drawable mDoneIcon;
    private boolean mAnimationEnabled = true;
    private boolean mAlwaysShowSummary = false;
    @Nullable
    private VerticalStepperItemView mPrevItemView;
    @Nullable
    private VerticalStepperItemView mNextItemView;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_SELECTED = 1;
    public static final int STATE_DONE = 2;
    private final int DP;

    public VerticalStepperItemView(@NonNull Context context) {
        this(context, null);
    }

    public VerticalStepperItemView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VerticalStepperItemView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.prepareViews(context);
        this.DP = this.getResources().getDimensionPixelSize(R.dimen.dp1);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.VerticalStepperItemView, defStyleAttr, R.style.Widget_Stepper);
            this.mTitle = a.getString(R.styleable.VerticalStepperItemView_step_title);
            this.mSummary = a.getString(R.styleable.VerticalStepperItemView_step_summary);
            this.mSummaryFinished = a.getString(R.styleable.VerticalStepperItemView_step_summary_done);
            this.mIndex = a.getInt(R.styleable.VerticalStepperItemView_step_index, 1);
            this.mState = a.getInt(R.styleable.VerticalStepperItemView_step_state, 0);
            this.isLastStep = a.getBoolean(R.styleable.VerticalStepperItemView_step_is_last, false);
            this.mNormalColor = a.getColor(R.styleable.VerticalStepperItemView_step_normal_color, this.mNormalColor);
            this.mActivatedColor = a.getColor(R.styleable.VerticalStepperItemView_step_activated_color, this.mActivatedColor);
            this.mAnimationDuration = a.getInt(R.styleable.VerticalStepperItemView_step_animation_duration, this.mAnimationDuration);
            this.mAnimationEnabled = a.getBoolean(R.styleable.VerticalStepperItemView_step_enable_animation, true);
            this.mLineColor = a.getColor(R.styleable.VerticalStepperItemView_step_line_color, this.mLineColor);
            this.mErrorColor = a.getColor(R.styleable.VerticalStepperItemView_step_error_highlight_color, this.mErrorColor);
            this.mAlwaysShowSummary = a.getBoolean(R.styleable.VerticalStepperItemView_step_show_summary_always, this.mAlwaysShowSummary);
            if (a.hasValue(R.styleable.VerticalStepperItemView_step_done_icon)) {
                this.mDoneIcon = a.getDrawable(R.styleable.VerticalStepperItemView_step_done_icon);
            }
            a.recycle();
        }
        this.setTitle(this.mTitle);
        this.updateSummaryView();
        this.setIndex(this.mIndex);
        this.setState(this.mState);
        this.setIsLastStep(this.isLastStep);
        this.setDoneIcon(this.mDoneIcon);
        this.setAnimationEnabled(this.mAnimationEnabled);
        this.setLineColor(this.mLineColor);
        this.setErrorColor(this.mErrorColor);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams layoutParams) {
        if (child.getId() == R.id.vertical_stepper_item_view_layout) {
            super.addView(child, index, layoutParams);
        } else {
            this.mCustomView.addView(child, index, layoutParams);
        }
    }

    FrameLayout getCustomView() {
        return this.mCustomView;
    }

    public void removeCustomView() {
        this.mCustomView.removeAllViews();
    }

    private void prepareViews(@NonNull Context context) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View inflateView = inflater.inflate(R.layout.vertical_stepper_item_view_layout, null);
        this.mPointBackground = inflateView.findViewById(R.id.stepper_point_background);
        this.mLineView = inflateView.findViewById(R.id.stepper_line);
        this.mPointNumber = (TextView)inflateView.findViewById(R.id.stepper_number);
        this.mTitleText = (TextView)inflateView.findViewById(R.id.stepper_title);
        this.mSummaryText = (TextView)inflateView.findViewById(R.id.stepper_summary);
        this.mCustomView = (FrameLayout)inflateView.findViewById(R.id.stepper_custom_view);
        this.mPointFrame = (FrameLayout)inflateView.findViewById(R.id.stepper_point_frame);
        this.mRightContainer = (LinearLayout)inflateView.findViewById(R.id.stepper_right_layout);
        this.mDoneIconView = (ImageView)inflateView.findViewById(R.id.stepper_done_icon);
        this.mMarginBottomView = inflateView.findViewById(R.id.stepper_margin_bottom);
        this.mErrorIconView = (ImageView)inflateView.findViewById(R.id.stepper_error_icon);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -2);
        this.addView(inflateView, (ViewGroup.LayoutParams)lp);
        this.mTitleText.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int singleLineHeight = VerticalStepperItemView.this.mTitleText.getMeasuredHeight();
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)VerticalStepperItemView.this.mTitleText.getLayoutParams();
                mlp.topMargin = (VerticalStepperItemView.this.mPointFrame.getMeasuredHeight() - singleLineHeight) / 2;
            }
        });
    }

    private void updateMarginBottom() {
        this.mMarginBottomView.getLayoutParams().height = (!this.isLastStep ? (this.mState != 1 ? 28 : 36) : 12) * this.DP;
    }

    public synchronized void setState(int state) {
        if (this.mPointColorAnimator != null) {
            this.mPointColorAnimator.cancel();
        }
        if (state != 0 && this.mState == 0) {
            this.mPointColorAnimator = ViewUtils.createArgbAnimator(this.mPointBackground, "backgroundColor", this.mNormalColor, this.mActivatedColor);
            this.mPointColorAnimator.setDuration((long)this.mAnimationDuration);
            this.mPointColorAnimator.start();
        } else if (state == 0 && this.mState != 0) {
            this.mPointColorAnimator = ViewUtils.createArgbAnimator(this.mPointBackground, "backgroundColor", this.mActivatedColor, this.mNormalColor);
            this.mPointColorAnimator.setDuration((long)this.mAnimationDuration);
            this.mPointColorAnimator.start();
        } else {
            this.mPointBackground.setBackgroundColor(state == 0 ? this.mNormalColor : this.mActivatedColor);
        }
        if (state == 2 && this.mState != 2) {
            this.mDoneIconView.animate().alpha(1.0f).setDuration((long)this.mAnimationDuration).start();
            this.mPointNumber.animate().alpha(0.0f).setDuration((long)this.mAnimationDuration).start();
        } else if (state != 2 && this.mState == 2) {
            this.mDoneIconView.animate().alpha(0.0f).setDuration((long)this.mAnimationDuration).start();
            this.mPointNumber.animate().alpha(1.0f).setDuration((long)this.mAnimationDuration).start();
        } else {
            this.mDoneIconView.setAlpha(state == 2 ? 1.0f : 0.0f);
            this.mPointNumber.setAlpha(state == 2 ? 0.0f : 1.0f);
        }
        int lastTitleTextColor = this.mTitleText.getCurrentTextColor();
        if (this.mTitleColorAnimator != null) {
            this.mTitleColorAnimator.cancel();
        }
        this.mTitleText.setTextAppearance(this.getContext(), state == 2 ? R.style.TextAppearance_Widget_Stepper_Done : (state == 0 ? R.style.TextAppearance_Widget_Stepper_Normal : R.style.TextAppearance_Widget_Stepper_Selected));
        if (this.mErrorText != null) {
            this.mTitleColorAnimator = ViewUtils.createArgbAnimator((View)this.mTitleText, "textColor", lastTitleTextColor, this.mErrorColor);
            this.mTitleColorAnimator.setDuration((long)this.mAnimationDuration);
            this.mTitleColorAnimator.start();
            if (this.mSummaryColorAnimator != null) {
                this.mSummaryColorAnimator.cancel();
            }
            this.mSummaryColorAnimator = ViewUtils.createArgbAnimator((View)this.mSummaryText, "textColor", this.mSummaryText.getCurrentTextColor(), this.mErrorColor);
            this.mSummaryColorAnimator.setDuration((long)this.mAnimationDuration);
            this.mSummaryColorAnimator.start();
            if (this.mErrorIconView.getAlpha() < 1.0f) {
                if (this.mPointAnimator != null) {
                    this.mPointAnimator.cancel();
                }
                this.mPointAnimator = this.mPointFrame.animate().alpha(0.0f).setDuration((long)this.mAnimationDuration);
                this.mPointAnimator.start();
                this.mErrorIconView.setScaleX(0.6f);
                this.mErrorIconView.setScaleY(0.6f);
                if (this.mErrorIconAnimator != null) {
                    this.mErrorIconAnimator.cancel();
                }
                this.mErrorIconAnimator = this.mErrorIconView.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setDuration((long)this.mAnimationDuration).setInterpolator((TimeInterpolator)new OvershootInterpolator());
                this.mErrorIconAnimator.start();
            }
        } else {
            if (this.mSummaryColorAnimator != null) {
                this.mSummaryColorAnimator.cancel();
            }
            this.mSummaryColorAnimator = ViewUtils.createArgbAnimator((View)this.mSummaryText, "textColor", this.mSummaryText.getCurrentTextColor(), this.mLineColor);
            this.mSummaryColorAnimator.setDuration((long)this.mAnimationDuration);
            this.mSummaryColorAnimator.start();
            if (this.mPointFrame.getAlpha() < 1.0f) {
                this.mPointFrame.setScaleX(0.6f);
                this.mPointFrame.setScaleY(0.6f);
                if (this.mPointAnimator != null) {
                    this.mPointAnimator.cancel();
                }
                this.mPointAnimator = this.mPointFrame.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setDuration((long)this.mAnimationDuration);
                this.mPointAnimator.start();
                if (this.mErrorIconAnimator != null) {
                    this.mErrorIconAnimator.cancel();
                }
                this.mErrorIconAnimator = this.mErrorIconView.animate().alpha(0.0f).setDuration((long)this.mAnimationDuration);
                this.mErrorIconAnimator.start();
            }
        }
        this.mSummaryText.setVisibility(state != 1 && !TextUtils.isEmpty((CharSequence)this.mSummary) ? 0 : 8);
        this.mCustomView.setVisibility(state == 1 ? 0 : 8);
        this.mState = state;
        this.updateMarginBottom();
        this.updateSummaryView();
    }

    public int getState() {
        return this.mState;
    }

    public void setTitle(CharSequence title) {
        this.mTitle = title;
        this.mTitleText.setText(title);
    }

    public void setTitle(@StringRes int titleRes) {
        this.setTitle(this.getResources().getString(titleRes));
    }

    @NonNull
    public CharSequence getTitle() {
        return this.mTitle;
    }

    public void setAlwaysShowSummary(boolean alwaysShowSummary) {
        this.mAlwaysShowSummary = alwaysShowSummary;
        this.updateSummaryView();
    }

    public boolean isAlwaysShowSummary() {
        return this.mAlwaysShowSummary;
    }

    public void setErrorText(@Nullable CharSequence errorText) {
        this.mErrorText = errorText;
        this.mSummaryText.setText(this.mErrorText != null ? this.mErrorText : this.mSummary);
        this.setState(this.mState);
    }

    public void setErrorText(@StringRes int errorTextRes) {
        if (errorTextRes != 0) {
            this.setErrorText(this.getResources().getString(errorTextRes));
        } else {
            this.setErrorText(null);
        }
    }

    @Nullable
    public CharSequence getErrorText() {
        return this.mErrorText;
    }

    public void setSummary(@Nullable CharSequence summary) {
        this.mSummary = summary;
        this.updateSummaryView();
    }

    public void setSummary(@StringRes int summaryRes) {
        this.setSummary(this.getResources().getString(summaryRes));
    }

    @Nullable
    public CharSequence getSummary() {
        return this.mSummary;
    }

    public void setSummaryFinished(@Nullable CharSequence summary) {
        this.mSummaryFinished = summary;
        this.updateSummaryView();
    }

    public void setSummaryFinished(@StringRes int summaryRes) {
        this.setSummaryFinished(this.getResources().getString(summaryRes));
    }

    @Nullable
    public CharSequence getSummaryFinished() {
        return this.mSummaryFinished;
    }

    private void updateSummaryView() {
        this.mSummaryText.setText(this.mErrorText != null ? this.mErrorText : (this.mSummaryFinished != null && this.mState == 2 ? this.mSummaryFinished : this.mSummary));
        this.mSummaryText.setVisibility((this.mState != 1 || this.mAlwaysShowSummary) && !TextUtils.isEmpty((CharSequence)this.mSummaryText.getText()) ? 0 : 8);
    }

    public void setIndex(int index) {
        this.mIndex = index;
        this.mPointNumber.setText((CharSequence)String.valueOf(index));
    }

    public int getIndex() {
        return this.mIndex;
    }

    public void setIsLastStep(boolean isLastStep) {
        this.isLastStep = isLastStep;
        this.mLineView.setVisibility(isLastStep ? 4 : 0);
        this.updateMarginBottom();
    }

    public boolean isLastStep() {
        return this.isLastStep;
    }

    public void setAnimationEnabled(boolean shouldAnimate) {
        this.mAnimationEnabled = shouldAnimate;
        if (shouldAnimate) {
            this.mRightContainer.setLayoutTransition(new LayoutTransition());
        } else {
            this.mRightContainer.setLayoutTransition(null);
        }
    }

    public boolean isAnimationEnabled() {
        return this.mAnimationEnabled;
    }

    public void setDoneIcon(@NonNull Drawable drawable) {
        this.mDoneIcon = drawable;
        this.mDoneIconView.setImageDrawable(drawable);
    }

    public void setDoneIconResource(@DrawableRes int drawableRes) {
        this.setDoneIcon(this.getResources().getDrawable(drawableRes));
    }

    @NonNull
    public Drawable getDoneIcon() {
        return this.mDoneIcon;
    }

    public void setAnimationDuration(int duration) {
        this.mAnimationDuration = duration;
    }

    public int getAnimationDuration() {
        return this.mAnimationDuration;
    }

    public void bindSteppers(@Nullable VerticalStepperItemView prevItem, @Nullable VerticalStepperItemView nextItem) {
        if (prevItem != null) {
            this.mPrevItemView = prevItem;
            if (this.mPrevItemView.mNextItemView != this) {
                this.mPrevItemView.bindSteppers(null, this);
            }
        }
        if (nextItem != null) {
            this.mNextItemView = nextItem;
            if (this.mNextItemView.mPrevItemView != this) {
                this.mNextItemView.bindSteppers(this, null);
            }
        }
    }

    public static void bindSteppers(VerticalStepperItemView ... items) {
        for (int i = 0; i < items.length - 1; ++i) {
            if (i != 0) {
                items[i].bindSteppers(items[i - 1], null);
            }
            items[i].bindSteppers(null, items[i + 1]);
        }
    }

    public boolean canPrevStep() {
        return this.mPrevItemView != null;
    }

    public boolean prevStep() {
        if (this.canPrevStep()) {
            this.setState(0);
            if (this.mPrevItemView != null) {
                this.mPrevItemView.setState(1);
            }
            return true;
        }
        return false;
    }

    public boolean canNextStep() {
        return this.mNextItemView != null;
    }

    public boolean nextStep() {
        if (this.canNextStep()) {
            this.setState(2);
            if (this.mNextItemView != null) {
                this.mNextItemView.setState(1);
            }
            return true;
        }
        return false;
    }

    public void setNormalColor(@ColorInt int color) {
        this.mNormalColor = color;
        if (this.mState == 0) {
            this.mPointBackground.setBackgroundColor(color);
        }
    }

    public void setNormalColorResource(@ColorRes int colorRes) {
        this.setNormalColor(this.getResources().getColor(colorRes));
    }

    @ColorInt
    public int getNormalColor() {
        return this.mNormalColor;
    }

    public void setActivatedColor(@ColorInt int color) {
        this.mActivatedColor = color;
        if (this.mState != 0) {
            this.mPointBackground.setBackgroundColor(color);
        }
    }

    public void setActivatedColorResource(@ColorRes int colorRes) {
        this.setActivatedColor(this.getResources().getColor(colorRes));
    }

    @ColorInt
    public int getLineColor() {
        return this.mLineColor;
    }

    public void setLineColor(@ColorInt int color) {
        this.mLineColor = color;
        this.mLineView.setBackgroundColor(color);
    }

    public void setLineColorResource(@ColorRes int colorRes) {
        this.setLineColor(this.getResources().getColor(colorRes));
    }

    @ColorInt
    public int getErrorColor() {
        return this.mErrorColor;
    }

    public void setErrorColor(@ColorInt int color) {
        if (VerticalStepperItemView.isPreLollipop()) {
            this.mErrorIconView.getDrawable().setColorFilter(color, PorterDuff.Mode.DST_IN);
        } else {
            this.mErrorIconView.getDrawable().setTint(color);
        }
        if (this.mErrorText != null && color != this.mErrorColor) {
            if (this.mTitleColorAnimator != null && this.mTitleColorAnimator.isRunning()) {
                this.mTitleColorAnimator.cancel();
            }
            if (this.mSummaryColorAnimator != null && this.mSummaryColorAnimator.isRunning()) {
                this.mSummaryColorAnimator.cancel();
            }
            this.mTitleText.setTextColor(color);
            this.mSummaryText.setTextColor(color);
        }
        this.mErrorColor = color;
    }

    public void setErrorColorResource(@ColorRes int colorRes) {
        this.setErrorColor(this.getResources().getColor(colorRes));
    }

    @ColorInt
    public int getActivatedColor() {
        return this.mActivatedColor;
    }

    public Parcelable onSaveInstanceState() {
        ItemViewState state = new ItemViewState(super.onSaveInstanceState());
        state.title = this.mTitle;
        state.summary = this.mSummary;
        state.summaryFinished = this.mSummaryFinished;
        state.index = this.mIndex;
        state.isLastStep = this.isLastStep;
        state.state = this.mState;
        state.errorText = this.mErrorText;
        return state;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof ItemViewState) {
            ItemViewState viewState = (ItemViewState)state;
            super.onRestoreInstanceState(viewState.getSuperState());
            this.setTitle(viewState.title);
            this.setSummary(viewState.summary);
            this.setSummaryFinished(viewState.summaryFinished);
            this.setIndex(viewState.index);
            this.setIsLastStep(viewState.isLastStep);
            this.setState(viewState.state);
            this.setErrorText(viewState.errorText);
            return;
        }
        super.onRestoreInstanceState((Parcelable)View.BaseSavedState.EMPTY_STATE);
    }

    private static boolean isPreLollipop() {
        return Build.VERSION.SDK_INT < 21;
    }

    protected static class ItemViewState
    extends View.BaseSavedState {
        CharSequence title;
        CharSequence summary;
        CharSequence summaryFinished;
        int index = 1;
        boolean isLastStep = false;
        int state = 0;
        CharSequence errorText;
        public static final Parcelable.Creator<ItemViewState> CREATOR = new Parcelable.Creator<ItemViewState>(){

            public ItemViewState createFromParcel(Parcel source) {
                return new ItemViewState(source);
            }

            public ItemViewState[] newArray(int size) {
                return new ItemViewState[size];
            }
        };

        ItemViewState(Parcelable superState) {
            super(superState);
        }

        private ItemViewState(Parcel in) {
            super(in);
            this.title = in.readString();
            this.summary = in.readString();
            this.summaryFinished = in.readString();
            this.index = in.readInt();
            this.isLastStep = in.readByte() != 0;
            this.state = in.readInt();
            this.errorText = in.readString();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.title != null ? this.title.toString() : null);
            out.writeString(this.summary != null ? this.summary.toString() : null);
            out.writeString(this.summaryFinished != null ? this.summaryFinished.toString() : null);
            out.writeInt(this.index);
            out.writeByte(this.isLastStep ? (byte)1 : 0);
            out.writeInt(this.state);
            out.writeString(this.errorText != null ? this.errorText.toString() : null);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

