/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects;

import com.mockobjects.Expectation;
import com.mockobjects.Verifiable;
import junit.framework.Assert;

public abstract class AbstractExpectation
implements Verifiable,
Expectation {
    protected boolean myFailureModeIsImmediate = true;
    protected String myName;
    private boolean myHasExpectations = false;

    public AbstractExpectation(String name) {
        this.myName = name;
    }

    protected void assertEquals(String msg, int expectedValue, int actualValue) {
        this.assertEquals(msg, new Integer(expectedValue), new Integer(actualValue));
    }

    protected void assertEquals(String msg, Object expectedValue, Object actualValue) {
        if (!this.myHasExpectations) {
            return;
        }
        if (expectedValue == null && actualValue == null) {
            return;
        }
        if (expectedValue != null && expectedValue.equals(actualValue)) {
            return;
        }
        Assert.fail((String)(this.myName + " " + msg + "\nExpected: " + expectedValue + "\nReceived: " + actualValue));
    }

    public abstract void clearActual();

    public boolean hasExpectations() {
        return this.myHasExpectations;
    }

    public void setFailOnVerify() {
        this.myFailureModeIsImmediate = false;
    }

    protected void setHasExpectations() {
        this.clearActual();
        this.myHasExpectations = true;
    }

    protected boolean shouldCheckImmediately() {
        return this.myFailureModeIsImmediate && this.myHasExpectations;
    }

    public abstract void verify();
}

