/*
 * Decompiled with CFR 0.152.
 */
package ml.rugal.sshcommon.springmvc.method.annotation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import ml.rugal.sshcommon.springmvc.bind.annotation.FormModel;
import ml.rugal.sshcommon.springmvc.method.annotation.BaseMethodArgumentResolver;
import ml.rugal.sshcommon.springmvc.util.MapWapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockMultipartHttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.util.WebUtils;

public class FormModelMethodArgumentResolver
extends BaseMethodArgumentResolver {
    private static final Logger LOG = LoggerFactory.getLogger((String)FormModelMethodArgumentResolver.class.getName());
    private final Pattern INDEX_PATTERN = Pattern.compile("\\[(\\d+)\\]\\.?");
    private final int autoGrowCollectionLimit = Integer.MAX_VALUE;

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(FormModel.class);
    }

    public final Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) throws BindException, Exception {
        String name = ((FormModel)parameter.getParameterAnnotation(FormModel.class)).value();
        Object target = mavContainer.containsAttribute(name) ? mavContainer.getModel().get((Object)name) : this.createAttribute(name, parameter, binderFactory, request);
        WebDataBinder binder = binderFactory.createBinder(request, target, name);
        if ((target = binder.getTarget()) != null) {
            LOG.debug("Request HTTP Binding to form model parameter: " + name);
            this.bindRequestParameters(mavContainer, binderFactory, binder, request, parameter);
            this.validateIfApplicable(binder, parameter);
            if (binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
                throw new BindException(binder.getBindingResult());
            }
        }
        target = binder.convertIfNecessary(binder.getTarget(), parameter.getParameterType());
        mavContainer.addAttribute(name, target);
        return target;
    }

    protected Object createAttribute(String attributeName, MethodParameter parameter, WebDataBinderFactory binderFactory, NativeWebRequest request) throws Exception {
        Object attribute;
        String value = this.getRequestValueForAttribute(attributeName, request);
        if (value != null && (attribute = this.createAttributeFromRequestValue(value, attributeName, parameter, binderFactory, request)) != null) {
            return attribute;
        }
        Class parameterType = parameter.getParameterType();
        if (parameterType.isArray() || List.class.isAssignableFrom(parameterType)) {
            return ArrayList.class.newInstance();
        }
        if (Set.class.isAssignableFrom(parameterType)) {
            return HashSet.class.newInstance();
        }
        if (MapWapper.class.isAssignableFrom(parameterType)) {
            return MapWapper.class.newInstance();
        }
        return BeanUtils.instantiateClass((Class)parameter.getParameterType());
    }

    protected String getRequestValueForAttribute(String attributeName, NativeWebRequest request) {
        Map<String, String> variables = this.getUriTemplateVariables(request);
        if (StringUtils.hasText((String)variables.get(attributeName))) {
            return variables.get(attributeName);
        }
        if (StringUtils.hasText((String)request.getParameter(attributeName))) {
            return request.getParameter(attributeName);
        }
        return null;
    }

    protected Object createAttributeFromRequestValue(String sourceValue, String attributeName, MethodParameter parameter, WebDataBinderFactory binderFactory, NativeWebRequest request) throws Exception {
        TypeDescriptor target;
        TypeDescriptor source;
        WebDataBinder binder = binderFactory.createBinder(request, null, attributeName);
        ConversionService conversionService = binder.getConversionService();
        if (conversionService != null && conversionService.canConvert(source = TypeDescriptor.valueOf(String.class), target = new TypeDescriptor(parameter))) {
            return binder.convertIfNecessary((Object)sourceValue, parameter.getParameterType(), parameter);
        }
        return null;
    }

    protected void bindRequestParameters(ModelAndViewContainer mavContainer, WebDataBinderFactory binderFactory, WebDataBinder binder, NativeWebRequest request, MethodParameter parameter) throws Exception {
        HashMap<String, Boolean> hasProcessedPrefixMap = new HashMap<String, Boolean>();
        Class<?> targetType = binder.getTarget().getClass();
        ServletRequest servletRequest = this.prepareServletRequest(binder.getTarget(), request, parameter);
        WebDataBinder simpleBinder = binderFactory.createBinder(request, null, null);
        if (Collection.class.isAssignableFrom(targetType)) {
            Type type = parameter.getGenericParameterType();
            Class<?> componentType = Object.class;
            Collection target = (Collection)binder.getTarget();
            ArrayList<Object> targetList = new ArrayList<Object>(target);
            if (type instanceof ParameterizedType) {
                componentType = (Class<?>)((ParameterizedType)type).getActualTypeArguments()[0];
            }
            if (parameter.getParameterType().isArray()) {
                componentType = parameter.getParameterType().getComponentType();
            }
            for (Object key : servletRequest.getParameterMap().keySet()) {
                Matcher matcher;
                String prefixName = this.getPrefixName((String)key);
                if (hasProcessedPrefixMap.containsKey(prefixName)) continue;
                hasProcessedPrefixMap.put(prefixName, Boolean.TRUE);
                if (this.isSimpleComponent(prefixName)) {
                    Map paramValues = WebUtils.getParametersStartingWith((ServletRequest)servletRequest, (String)prefixName);
                    matcher = this.INDEX_PATTERN.matcher(prefixName);
                    if (!matcher.matches()) {
                        for (Object value : paramValues.values()) {
                            targetList.add(simpleBinder.convertIfNecessary(value, componentType));
                        }
                    } else {
                        int index = Integer.valueOf(matcher.group(1));
                        if (targetList.size() <= index) {
                            this.growCollectionIfNecessary(targetList, index);
                        }
                        targetList.set(index, simpleBinder.convertIfNecessary(paramValues.values(), componentType));
                    }
                } else {
                    WebDataBinder componentBinder;
                    Object component = null;
                    matcher = this.INDEX_PATTERN.matcher(prefixName);
                    if (!matcher.matches()) {
                        throw new IllegalArgumentException("bind collection error, need integer index, key:" + key);
                    }
                    int index = Integer.valueOf(matcher.group(1));
                    if (targetList.size() <= index) {
                        this.growCollectionIfNecessary(targetList, index);
                    }
                    Iterator iterator = targetList.iterator();
                    for (int i = 0; i < index; ++i) {
                        iterator.next();
                    }
                    component = iterator.next();
                    if (component == null) {
                        component = BeanUtils.instantiate(componentType);
                    }
                    if ((component = (componentBinder = binderFactory.createBinder(request, component, null)).getTarget()) != null) {
                        ServletRequestParameterPropertyValues pvs = new ServletRequestParameterPropertyValues(servletRequest, prefixName, "");
                        componentBinder.bind((PropertyValues)pvs);
                        this.validateIfApplicable(componentBinder, parameter);
                        if (componentBinder.getBindingResult().hasErrors() && this.isBindExceptionRequired(componentBinder, parameter)) {
                            throw new BindException(componentBinder.getBindingResult());
                        }
                        targetList.set(index, component);
                    }
                }
                target.clear();
                target.addAll(targetList);
            }
        } else if (MapWapper.class.isAssignableFrom(targetType)) {
            MapWapper mapWapper;
            Map<Object, Object> target;
            Type type = parameter.getGenericParameterType();
            Class keyType = Object.class;
            Class valueType = Object.class;
            if (type instanceof ParameterizedType) {
                keyType = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                valueType = (Class)((ParameterizedType)type).getActualTypeArguments()[1];
            }
            if ((target = (mapWapper = (MapWapper)binder.getTarget()).getInnerMap()) == null) {
                target = new HashMap();
                mapWapper.setInnerMap(target);
            }
            for (Object key : servletRequest.getParameterMap().keySet()) {
                WebDataBinder componentBinder;
                String prefixName = this.getPrefixName((String)key);
                if (hasProcessedPrefixMap.containsKey(prefixName)) continue;
                hasProcessedPrefixMap.put(prefixName, Boolean.TRUE);
                Object keyValue = simpleBinder.convertIfNecessary(this.getMapKey(prefixName), keyType);
                if (this.isSimpleComponent(prefixName)) {
                    Map paramValues = WebUtils.getParametersStartingWith((ServletRequest)servletRequest, (String)prefixName);
                    for (Object value : paramValues.values()) {
                        target.put(keyValue, simpleBinder.convertIfNecessary(value, valueType));
                    }
                    continue;
                }
                Object component = target.get(keyValue);
                if (component == null) {
                    component = BeanUtils.instantiate((Class)valueType);
                }
                if ((component = (componentBinder = binderFactory.createBinder(request, component, null)).getTarget()) == null) continue;
                ServletRequestParameterPropertyValues pvs = new ServletRequestParameterPropertyValues(servletRequest, prefixName, "");
                componentBinder.bind((PropertyValues)pvs);
                this.validateComponent(componentBinder, parameter);
                target.put(keyValue, component);
            }
        } else {
            ServletRequestDataBinder servletBinder = (ServletRequestDataBinder)binder;
            servletBinder.bind(servletRequest);
        }
    }

    private void growCollectionIfNecessary(Collection collection, int index) {
        if (index >= collection.size() && index < this.autoGrowCollectionLimit) {
            for (int i = collection.size(); i <= index; ++i) {
                collection.add(null);
            }
        }
    }

    private Object getMapKey(String prefixName) {
        String key = prefixName;
        if (key.startsWith("['")) {
            key = key.replaceAll("\\['", "").replaceAll("'\\]", "");
        }
        if (key.startsWith("[\"")) {
            key = key.replaceAll("\\[\"", "").replaceAll("\"\\]", "");
        }
        if (key.endsWith(".")) {
            key = key.substring(0, key.length() - 1);
        }
        return key;
    }

    private boolean isSimpleComponent(String prefixName) {
        return !prefixName.endsWith(".");
    }

    private String getPrefixName(String name) {
        int begin = 0;
        int end = name.indexOf("]") + 1;
        if (name.indexOf("].") >= 0) {
            ++end;
        }
        return name.substring(begin, end);
    }

    private ServletRequest prepareServletRequest(Object target, NativeWebRequest request, MethodParameter parameter) {
        String modelPrefixName = ((FormModel)parameter.getParameterAnnotation(FormModel.class)).value();
        HttpServletRequest nativeRequest = (HttpServletRequest)request.getNativeRequest();
        MultipartRequest multipartRequest = (MultipartRequest)WebUtils.getNativeRequest((ServletRequest)nativeRequest, MultipartRequest.class);
        MockHttpServletRequest mockRequest = null;
        if (multipartRequest != null) {
            MockMultipartHttpServletRequest mockMultipartRequest = new MockMultipartHttpServletRequest();
            for (MultipartFile file : multipartRequest.getFileMap().values()) {
                mockMultipartRequest.addFile((MultipartFile)new MultipartFileWrapper(this.getNewParameterName(file.getName(), modelPrefixName), file));
            }
            mockRequest = mockMultipartRequest;
        } else {
            mockRequest = new MockHttpServletRequest();
        }
        for (Map.Entry<String, String> entry : this.getUriTemplateVariables(request).entrySet()) {
            String parameterName = entry.getKey();
            String value = entry.getValue();
            if (!this.isFormModelAttribute(parameterName, modelPrefixName)) continue;
            mockRequest.setParameter(this.getNewParameterName(parameterName, modelPrefixName), value);
        }
        Iterator<Map.Entry<String, String>> iterator = nativeRequest.getParameterMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> parameterEntry;
            Map.Entry<String, String> entry = parameterEntry = iterator.next();
            String parameterName = entry.getKey();
            String[] value = (String[])entry.getValue();
            if (!this.isFormModelAttribute(parameterName, modelPrefixName)) continue;
            mockRequest.setParameter(this.getNewParameterName(parameterName, modelPrefixName), value);
        }
        return mockRequest;
    }

    private String getNewParameterName(String parameterName, String modelPrefixName) {
        int modelPrefixNameLength = modelPrefixName.length();
        if (parameterName.charAt(modelPrefixNameLength) == '.') {
            return parameterName.substring(modelPrefixNameLength + 1);
        }
        if (parameterName.charAt(modelPrefixNameLength) == '[') {
            return parameterName.substring(modelPrefixNameLength);
        }
        throw new IllegalArgumentException("illegal request parameter, can not binding to @FormBean(" + modelPrefixName + ")");
    }

    private boolean isFormModelAttribute(String parameterName, String modelPrefixName) {
        int modelPrefixNameLength = modelPrefixName.length();
        if (parameterName.length() == modelPrefixNameLength) {
            return false;
        }
        if (!parameterName.startsWith(modelPrefixName)) {
            return false;
        }
        char ch = parameterName.charAt(modelPrefixNameLength);
        return ch == '.' || ch == '[';
    }

    protected void validateComponent(WebDataBinder binder, MethodParameter parameter) throws BindException {
        Annotation[] annotations;
        boolean validateParameter = this.validateParameter(parameter);
        for (Annotation annot : annotations = binder.getTarget().getClass().getAnnotations()) {
            Object[] objectArray;
            if (!annot.annotationType().getSimpleName().startsWith("Valid") || !validateParameter) continue;
            Object hints = AnnotationUtils.getValue((Annotation)annot);
            if (hints instanceof Object[]) {
                objectArray = (Object[])hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            binder.validate(objectArray);
        }
        if (binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
            throw new BindException(binder.getBindingResult());
        }
    }

    private boolean validateParameter(MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation annot : annotations = parameter.getParameterAnnotations()) {
            if (!annot.annotationType().getSimpleName().startsWith("Valid")) continue;
            return true;
        }
        return false;
    }

    protected void validateIfApplicable(WebDataBinder binder, MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation annot : annotations = parameter.getParameterAnnotations()) {
            Object[] objectArray;
            if (!annot.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object hints = AnnotationUtils.getValue((Annotation)annot);
            if (hints instanceof Object[]) {
                objectArray = (Object[])hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            binder.validate(objectArray);
        }
    }

    protected boolean isBindExceptionRequired(WebDataBinder binder, MethodParameter parameter) {
        int i = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getMethod().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
        return !hasBindingResult;
    }

    private static class MultipartFileWrapper
    implements MultipartFile {
        private String name;
        private MultipartFile delegate;

        private MultipartFileWrapper(String name, MultipartFile delegate) {
            this.name = name;
            this.delegate = delegate;
        }

        public String getName() {
            return this.name;
        }

        public String getOriginalFilename() {
            return this.delegate.getOriginalFilename();
        }

        public String getContentType() {
            return this.delegate.getContentType();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public long getSize() {
            return this.delegate.getSize();
        }

        public byte[] getBytes() throws IOException {
            return this.delegate.getBytes();
        }

        public InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        public void transferTo(File dest) throws IOException, IllegalStateException {
            this.delegate.transferTo(dest);
        }
    }
}

