/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar.internal;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ValueAnimatorCompat {
    @NonNull
    private static final Object sValueAnimatorGetDurationScaleMethodLock = new Object();
    private static boolean sValueAnimatorGetDurationScaleMethodInitialized;
    @Nullable
    private static Method sValueAnimatorGetDurationScaleMethod;
    @NonNull
    private static final Object sValueAnimatorSDurationScaleFieldLock;
    private static boolean sValueAnimatorSDurationScaleFieldInitialized;
    @Nullable
    private static Field sValueAnimatorSDurationScaleField;

    private ValueAnimatorCompat() {
    }

    public static boolean areAnimatorsEnabled() {
        Field valueAnimatorSDurationScaleField;
        Method valueAnimatorGetDurationScaleMethod;
        if (Build.VERSION.SDK_INT >= 26) {
            return ValueAnimator.areAnimatorsEnabled();
        }
        if (Build.VERSION.SDK_INT >= 17 && (valueAnimatorGetDurationScaleMethod = ValueAnimatorCompat.getValueAnimatorGetDurationScaleMethod()) != null) {
            try {
                float durationScale = ((Float)valueAnimatorGetDurationScaleMethod.invoke(null, new Object[0])).floatValue();
                return durationScale != 0.0f;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Build.VERSION.SDK_INT >= 16 && (valueAnimatorSDurationScaleField = ValueAnimatorCompat.getValueAnimatorSDurationScaleField()) != null) {
            try {
                float durationScale = ((Float)valueAnimatorSDurationScaleField.get(null)).floatValue();
                return durationScale != 0.0f;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @SuppressLint(value={"PrivateApi"})
    private static Method getValueAnimatorGetDurationScaleMethod() {
        Object object = sValueAnimatorGetDurationScaleMethodLock;
        synchronized (object) {
            if (!sValueAnimatorGetDurationScaleMethodInitialized) {
                try {
                    sValueAnimatorGetDurationScaleMethod = ValueAnimator.class.getDeclaredMethod("getDurationScale", new Class[0]);
                    sValueAnimatorGetDurationScaleMethod.setAccessible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                sValueAnimatorGetDurationScaleMethodInitialized = true;
            }
            return sValueAnimatorGetDurationScaleMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Field getValueAnimatorSDurationScaleField() {
        Object object = sValueAnimatorSDurationScaleFieldLock;
        synchronized (object) {
            if (!sValueAnimatorSDurationScaleFieldInitialized) {
                try {
                    sValueAnimatorSDurationScaleField = ValueAnimator.class.getDeclaredField("sDurationScale");
                    sValueAnimatorSDurationScaleField.setAccessible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                sValueAnimatorSDurationScaleFieldInitialized = true;
            }
            return sValueAnimatorSDurationScaleField;
        }
    }

    static {
        sValueAnimatorSDurationScaleFieldLock = new Object();
    }
}

