/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.ColorUtils;
import android.util.Log;
import me.zhanghai.android.materialprogressbar.IntrinsicPaddingDrawable;
import me.zhanghai.android.materialprogressbar.MaterialProgressDrawable;
import me.zhanghai.android.materialprogressbar.R;
import me.zhanghai.android.materialprogressbar.ShowBackgroundDrawable;
import me.zhanghai.android.materialprogressbar.TintableDrawable;
import me.zhanghai.android.materialprogressbar.internal.ThemeUtils;

class BaseProgressLayerDrawable<ProgressDrawableType extends IntrinsicPaddingDrawable & ShowBackgroundDrawable, BackgroundDrawableType extends IntrinsicPaddingDrawable & ShowBackgroundDrawable>
extends LayerDrawable
implements IntrinsicPaddingDrawable,
MaterialProgressDrawable,
ShowBackgroundDrawable,
TintableDrawable {
    private float mBackgroundAlpha;
    private BackgroundDrawableType mBackgroundDrawable;
    private ProgressDrawableType mSecondaryProgressDrawable;
    private ProgressDrawableType mProgressDrawable;

    public BaseProgressLayerDrawable(Drawable[] layers, Context context) {
        super(layers);
        this.mBackgroundAlpha = ThemeUtils.getFloatFromAttrRes(0x1010033, 0.0f, context);
        this.setId(0, 0x1020000);
        this.mBackgroundDrawable = (IntrinsicPaddingDrawable)this.getDrawable(0);
        this.setId(1, 16908303);
        this.mSecondaryProgressDrawable = (IntrinsicPaddingDrawable)this.getDrawable(1);
        this.setId(2, 16908301);
        this.mProgressDrawable = (IntrinsicPaddingDrawable)this.getDrawable(2);
        int controlActivatedColor = ThemeUtils.getColorFromAttrRes(R.attr.colorControlActivated, -16777216, context);
        this.setTint(controlActivatedColor);
    }

    @Override
    public boolean getShowBackground() {
        return ((ShowBackgroundDrawable)this.mBackgroundDrawable).getShowBackground();
    }

    @Override
    public void setShowBackground(boolean show) {
        if (((ShowBackgroundDrawable)this.mBackgroundDrawable).getShowBackground() != show) {
            ((ShowBackgroundDrawable)this.mBackgroundDrawable).setShowBackground(show);
            ((ShowBackgroundDrawable)this.mSecondaryProgressDrawable).setShowBackground(!show);
        }
    }

    @Override
    public boolean getUseIntrinsicPadding() {
        return this.mBackgroundDrawable.getUseIntrinsicPadding();
    }

    @Override
    public void setUseIntrinsicPadding(boolean useIntrinsicPadding) {
        this.mBackgroundDrawable.setUseIntrinsicPadding(useIntrinsicPadding);
        this.mSecondaryProgressDrawable.setUseIntrinsicPadding(useIntrinsicPadding);
        this.mProgressDrawable.setUseIntrinsicPadding(useIntrinsicPadding);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void setTint(@ColorInt int tintColor) {
        int backgroundTintColor = ColorUtils.setAlphaComponent((int)tintColor, (int)Math.round((float)Color.alpha((int)tintColor) * this.mBackgroundAlpha));
        ((TintableDrawable)this.mBackgroundDrawable).setTint(backgroundTintColor);
        ((TintableDrawable)this.mSecondaryProgressDrawable).setTint(backgroundTintColor);
        ((TintableDrawable)this.mProgressDrawable).setTint(tintColor);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void setTintList(@Nullable ColorStateList tint) {
        ColorStateList backgroundTint;
        if (tint != null) {
            if (!tint.isOpaque()) {
                Log.w((String)this.getClass().getSimpleName(), (String)"setTintList() called with a non-opaque ColorStateList, its original alpha will be discarded");
            }
            backgroundTint = tint.withAlpha(Math.round(255.0f * this.mBackgroundAlpha));
        } else {
            backgroundTint = null;
        }
        ((TintableDrawable)this.mBackgroundDrawable).setTintList(backgroundTint);
        ((TintableDrawable)this.mSecondaryProgressDrawable).setTintList(backgroundTint);
        ((TintableDrawable)this.mProgressDrawable).setTintList(tint);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        ((TintableDrawable)this.mBackgroundDrawable).setTintMode(tintMode);
        ((TintableDrawable)this.mSecondaryProgressDrawable).setTintMode(tintMode);
        ((TintableDrawable)this.mProgressDrawable).setTintMode(tintMode);
    }
}

