/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import me.zhanghai.android.materialprogressbar.IntrinsicPaddingDrawable;
import me.zhanghai.android.materialprogressbar.ShowTrackDrawable;
import me.zhanghai.android.materialprogressbar.SingleHorizontalProgressDrawable;
import me.zhanghai.android.materialprogressbar.TintableDrawable;
import me.zhanghai.android.materialprogressbar.internal.ThemeUtils;

public class HorizontalProgressDrawable
extends LayerDrawable
implements IntrinsicPaddingDrawable,
ShowTrackDrawable,
TintableDrawable {
    private int mSecondaryAlpha;
    private SingleHorizontalProgressDrawable mTrackDrawable;
    private SingleHorizontalProgressDrawable mSecondaryProgressDrawable;
    private SingleHorizontalProgressDrawable mProgressDrawable;

    public HorizontalProgressDrawable(Context context) {
        super(new Drawable[]{new SingleHorizontalProgressDrawable(context), new SingleHorizontalProgressDrawable(context), new SingleHorizontalProgressDrawable(context)});
        this.setId(0, 0x1020000);
        this.mTrackDrawable = (SingleHorizontalProgressDrawable)this.getDrawable(0);
        this.setId(1, 16908303);
        this.mSecondaryProgressDrawable = (SingleHorizontalProgressDrawable)this.getDrawable(1);
        float disabledAlpha = ThemeUtils.getFloatFromAttrRes(0x1010033, context);
        this.mSecondaryAlpha = Math.round(disabledAlpha * 255.0f);
        this.mSecondaryProgressDrawable.setAlpha(this.mSecondaryAlpha);
        this.mSecondaryProgressDrawable.setShowTrack(false);
        this.setId(2, 16908301);
        this.mProgressDrawable = (SingleHorizontalProgressDrawable)this.getDrawable(2);
        this.mProgressDrawable.setShowTrack(false);
    }

    @Override
    public boolean getShowTrack() {
        return this.mTrackDrawable.getShowTrack();
    }

    @Override
    public void setShowTrack(boolean showTrack) {
        if (this.mTrackDrawable.getShowTrack() != showTrack) {
            this.mTrackDrawable.setShowTrack(showTrack);
            this.mSecondaryProgressDrawable.setAlpha(showTrack ? this.mSecondaryAlpha : 2 * this.mSecondaryAlpha);
        }
    }

    @Override
    public boolean getUseIntrinsicPadding() {
        return this.mTrackDrawable.getUseIntrinsicPadding();
    }

    @Override
    public void setUseIntrinsicPadding(boolean useIntrinsicPadding) {
        this.mTrackDrawable.setUseIntrinsicPadding(useIntrinsicPadding);
        this.mSecondaryProgressDrawable.setUseIntrinsicPadding(useIntrinsicPadding);
        this.mProgressDrawable.setUseIntrinsicPadding(useIntrinsicPadding);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void setTint(@ColorInt int tintColor) {
        this.mTrackDrawable.setTint(tintColor);
        this.mSecondaryProgressDrawable.setTint(tintColor);
        this.mProgressDrawable.setTint(tintColor);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void setTintList(@Nullable ColorStateList tint) {
        this.mTrackDrawable.setTintList(tint);
        this.mSecondaryProgressDrawable.setTintList(tint);
        this.mProgressDrawable.setTintList(tint);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        this.mTrackDrawable.setTintMode(tintMode);
        this.mSecondaryProgressDrawable.setTintMode(tintMode);
        this.mProgressDrawable.setTintMode(tintMode);
    }
}

