/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import me.zhanghai.android.materialprogressbar.R;
import me.zhanghai.android.materialprogressbar.internal.ThemeUtils;

abstract class ProgressDrawableBase
extends Drawable {
    protected boolean mUseIntrinsicPadding = true;
    protected int mAlpha = 255;
    protected ColorFilter mColorFilter;
    protected ColorStateList mTint;
    protected PorterDuff.Mode mTintMode = PorterDuff.Mode.SRC_IN;
    protected PorterDuffColorFilter mTintFilter;
    protected int mLayoutDirection;
    protected boolean mAutoMirrored = true;
    private Paint mPaint;

    public ProgressDrawableBase(Context context) {
        int colorControlActivated = ThemeUtils.getAttrColor(context, R.attr.colorControlActivated);
        this.setTint(colorControlActivated);
    }

    public boolean getUseIntrinsicPadding() {
        return this.mUseIntrinsicPadding;
    }

    public void setUseIntrinsicPadding(boolean useIntrinsicPadding) {
        if (this.mUseIntrinsicPadding != useIntrinsicPadding) {
            this.mUseIntrinsicPadding = useIntrinsicPadding;
            this.invalidateSelf();
        }
    }

    public void setAlpha(int alpha) {
        if (this.mAlpha != alpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public void setTint(int tint) {
        this.setTintList(ColorStateList.valueOf((int)tint));
    }

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mColorFilter = colorFilter;
        this.invalidateSelf();
    }

    public void setTintList(ColorStateList tint) {
        this.mTint = tint;
        this.mTintFilter = this.makeTintFilter(tint, this.mTintMode);
        this.invalidateSelf();
    }

    public void setTintMode(PorterDuff.Mode tintMode) {
        this.mTintMode = tintMode;
        this.mTintFilter = this.makeTintFilter(this.mTint, tintMode);
        this.invalidateSelf();
    }

    private PorterDuffColorFilter makeTintFilter(ColorStateList tint, PorterDuff.Mode tintMode) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color = tint.getColorForState(this.getState(), 0);
        return new PorterDuffColorFilter(color, tintMode);
    }

    public int getLayoutDirection() {
        return this.mLayoutDirection;
    }

    public void setLayoutDirection(int layoutDirection) {
        if (this.getLayoutDirection() != layoutDirection) {
            this.mLayoutDirection = layoutDirection;
        }
    }

    public boolean isAutoMirrored() {
        return this.mAutoMirrored;
    }

    public void setAutoMirrored(boolean autoMirrored) {
        if (this.mAutoMirrored != autoMirrored) {
            this.mAutoMirrored = autoMirrored;
            this.invalidateSelf();
        }
    }

    private boolean needMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        if (bounds.width() == 0 || bounds.height() == 0) {
            return;
        }
        if (this.mPaint == null) {
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setColor(-16777216);
            this.onPreparePaint(this.mPaint);
        }
        this.mPaint.setAlpha(this.mAlpha);
        ColorFilter colorFilter = this.mColorFilter != null ? this.mColorFilter : this.mTintFilter;
        this.mPaint.setColorFilter(colorFilter);
        int saveCount = canvas.save();
        canvas.translate((float)bounds.left, (float)bounds.top);
        if (this.needMirroring()) {
            canvas.translate((float)bounds.width(), 0.0f);
            canvas.scale(-1.0f, 1.0f);
        }
        this.onDraw(canvas, bounds.width(), bounds.height(), this.mPaint);
        canvas.restoreToCount(saveCount);
    }

    protected abstract void onPreparePaint(Paint var1);

    protected abstract void onDraw(Canvas var1, int var2, int var3, Paint var4);
}

