/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.template.metric;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.mixer.template.metric.Metric;
import me.snowdrop.istio.mixer.template.metric.MetricFluent;
import me.snowdrop.istio.mixer.template.metric.MetricFluentImpl;

public class MetricBuilder
extends MetricFluentImpl<MetricBuilder>
implements VisitableBuilder<Metric, MetricBuilder> {
    MetricFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public MetricBuilder() {
        this(true);
    }

    public MetricBuilder(Boolean validationEnabled) {
        this(new Metric(), validationEnabled);
    }

    public MetricBuilder(MetricFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public MetricBuilder(MetricFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Metric(), validationEnabled);
    }

    public MetricBuilder(MetricFluent<?> fluent, Metric instance) {
        this(fluent, instance, true);
    }

    public MetricBuilder(MetricFluent<?> fluent, Metric instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public MetricBuilder(Metric instance) {
        this(instance, (Boolean)true);
    }

    public MetricBuilder(Metric instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public MetricBuilder(Validator validator) {
        this(new Metric(), (Boolean)true);
    }

    public MetricBuilder(MetricFluent<?> fluent, Metric instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public MetricBuilder(Metric instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public Metric build() {
        Metric buildable = new Metric(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable, (Validator)this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetricBuilder that = (MetricBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

