/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.statsd;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import me.snowdrop.istio.mixer.adapter.statsd.MetricInfo;
import me.snowdrop.istio.mixer.adapter.statsd.StatsdSpec;
import me.snowdrop.istio.mixer.adapter.statsd.StatsdSpecFluent;

public class StatsdSpecFluentImpl<A extends StatsdSpecFluent<A>>
extends BaseFluent<A>
implements StatsdSpecFluent<A> {
    private String address;
    private Integer flushBytes;
    private Integer flushDuration;
    private Map<String, MetricInfo> metrics;
    private String prefix;
    private Double samplingRate;

    public StatsdSpecFluentImpl() {
    }

    public StatsdSpecFluentImpl(StatsdSpec instance) {
        this.withAddress(instance.getAddress());
        this.withFlushBytes(instance.getFlushBytes());
        this.withFlushDuration(instance.getFlushDuration());
        this.withMetrics(instance.getMetrics());
        this.withPrefix(instance.getPrefix());
        this.withSamplingRate(instance.getSamplingRate());
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public A withAddress(String address) {
        this.address = address;
        return (A)this;
    }

    @Override
    public Boolean hasAddress() {
        return this.address != null;
    }

    @Override
    public A withNewAddress(String arg1) {
        return this.withAddress(new String(arg1));
    }

    @Override
    public A withNewAddress(StringBuilder arg1) {
        return this.withAddress(new String(arg1));
    }

    @Override
    public A withNewAddress(StringBuffer arg1) {
        return this.withAddress(new String(arg1));
    }

    @Override
    public Integer getFlushBytes() {
        return this.flushBytes;
    }

    @Override
    public A withFlushBytes(Integer flushBytes) {
        this.flushBytes = flushBytes;
        return (A)this;
    }

    @Override
    public Boolean hasFlushBytes() {
        return this.flushBytes != null;
    }

    @Override
    public Integer getFlushDuration() {
        return this.flushDuration;
    }

    @Override
    public A withFlushDuration(Integer flushDuration) {
        this.flushDuration = flushDuration;
        return (A)this;
    }

    @Override
    public Boolean hasFlushDuration() {
        return this.flushDuration != null;
    }

    @Override
    public A addToMetrics(String key, MetricInfo value) {
        if (this.metrics == null && key != null && value != null) {
            this.metrics = new LinkedHashMap<String, MetricInfo>();
        }
        if (key != null && value != null) {
            this.metrics.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMetrics(Map<String, MetricInfo> map) {
        if (this.metrics == null && map != null) {
            this.metrics = new LinkedHashMap<String, MetricInfo>();
        }
        if (map != null) {
            this.metrics.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(String key) {
        if (this.metrics == null) {
            return (A)this;
        }
        if (key != null && this.metrics != null) {
            this.metrics.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(Map<String, MetricInfo> map) {
        if (this.metrics == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.metrics == null) continue;
                this.metrics.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, MetricInfo> getMetrics() {
        return this.metrics;
    }

    @Override
    public A withMetrics(Map<String, MetricInfo> metrics) {
        this.metrics = metrics == null ? null : new LinkedHashMap<String, MetricInfo>(metrics);
        return (A)this;
    }

    @Override
    public Boolean hasMetrics() {
        return this.metrics != null;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public A withPrefix(String prefix) {
        this.prefix = prefix;
        return (A)this;
    }

    @Override
    public Boolean hasPrefix() {
        return this.prefix != null;
    }

    @Override
    public A withNewPrefix(String arg1) {
        return this.withPrefix(new String(arg1));
    }

    @Override
    public A withNewPrefix(StringBuilder arg1) {
        return this.withPrefix(new String(arg1));
    }

    @Override
    public A withNewPrefix(StringBuffer arg1) {
        return this.withPrefix(new String(arg1));
    }

    @Override
    public Double getSamplingRate() {
        return this.samplingRate;
    }

    @Override
    public A withSamplingRate(Double samplingRate) {
        this.samplingRate = samplingRate;
        return (A)this;
    }

    @Override
    public Boolean hasSamplingRate() {
        return this.samplingRate != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatsdSpecFluentImpl that = (StatsdSpecFluentImpl)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.flushBytes != null ? !this.flushBytes.equals(that.flushBytes) : that.flushBytes != null) {
            return false;
        }
        if (this.flushDuration != null ? !this.flushDuration.equals(that.flushDuration) : that.flushDuration != null) {
            return false;
        }
        if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) {
            return false;
        }
        if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) {
            return false;
        }
        return !(this.samplingRate != null ? !this.samplingRate.equals(that.samplingRate) : that.samplingRate != null);
    }
}

