/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import me.snowdrop.istio.mixer.adapter.stackdriver.ApiKeyCreds;
import me.snowdrop.istio.mixer.adapter.stackdriver.ApiKeyCredsBuilder;
import me.snowdrop.istio.mixer.adapter.stackdriver.ApiKeyCredsFluentImpl;
import me.snowdrop.istio.mixer.adapter.stackdriver.AppCredentialsCreds;
import me.snowdrop.istio.mixer.adapter.stackdriver.AppCredentialsCredsBuilder;
import me.snowdrop.istio.mixer.adapter.stackdriver.AppCredentialsCredsFluentImpl;
import me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo;
import me.snowdrop.istio.mixer.adapter.stackdriver.MetricInfo;
import me.snowdrop.istio.mixer.adapter.stackdriver.ServiceAccountPathCreds;
import me.snowdrop.istio.mixer.adapter.stackdriver.ServiceAccountPathCredsBuilder;
import me.snowdrop.istio.mixer.adapter.stackdriver.ServiceAccountPathCredsFluentImpl;
import me.snowdrop.istio.mixer.adapter.stackdriver.StackdriverSpec;
import me.snowdrop.istio.mixer.adapter.stackdriver.StackdriverSpecFluent;
import me.snowdrop.istio.mixer.adapter.stackdriver.Trace;
import me.snowdrop.istio.mixer.adapter.stackdriver.TraceBuilder;
import me.snowdrop.istio.mixer.adapter.stackdriver.TraceFluentImpl;

public class StackdriverSpecFluentImpl<A extends StackdriverSpecFluent<A>>
extends BaseFluent<A>
implements StackdriverSpecFluent<A> {
    private VisitableBuilder<? extends StackdriverSpec.Creds, ?> creds;
    private String endpoint;
    private Map<String, LogInfo> logInfo;
    private Map<String, MetricInfo> metricInfo;
    private String projectId;
    private Integer pushInterval;
    private TraceBuilder trace;

    public StackdriverSpecFluentImpl() {
    }

    public StackdriverSpecFluentImpl(StackdriverSpec instance) {
        this.withCreds(instance.getCreds());
        this.withEndpoint(instance.getEndpoint());
        this.withLogInfo(instance.getLogInfo());
        this.withMetricInfo(instance.getMetricInfo());
        this.withProjectId(instance.getProjectId());
        this.withPushInterval(instance.getPushInterval());
        this.withTrace(instance.getTrace());
    }

    @Override
    @Deprecated
    public StackdriverSpec.Creds getCreds() {
        return this.creds != null ? (StackdriverSpec.Creds)this.creds.build() : null;
    }

    @Override
    public StackdriverSpec.Creds buildCreds() {
        return this.creds != null ? (StackdriverSpec.Creds)this.creds.build() : null;
    }

    @Override
    public A withCreds(StackdriverSpec.Creds creds) {
        if (creds instanceof ApiKeyCreds) {
            this.creds = new ApiKeyCredsBuilder((ApiKeyCreds)creds);
            this._visitables.get((Object)"creds").add(this.creds);
        }
        if (creds instanceof AppCredentialsCreds) {
            this.creds = new AppCredentialsCredsBuilder((AppCredentialsCreds)creds);
            this._visitables.get((Object)"creds").add(this.creds);
        }
        if (creds instanceof ServiceAccountPathCreds) {
            this.creds = new ServiceAccountPathCredsBuilder((ServiceAccountPathCreds)creds);
            this._visitables.get((Object)"creds").add(this.creds);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCreds() {
        return this.creds != null;
    }

    @Override
    public A withApiKeyCreds(ApiKeyCreds apiKeyCreds) {
        this._visitables.get((Object)"creds").remove(this.creds);
        if (apiKeyCreds != null) {
            this.creds = new ApiKeyCredsBuilder(apiKeyCreds);
            this._visitables.get((Object)"creds").add(this.creds);
        }
        return (A)this;
    }

    @Override
    public StackdriverSpecFluent.ApiKeyCredsNested<A> withNewApiKeyCreds() {
        return new ApiKeyCredsNestedImpl();
    }

    @Override
    public StackdriverSpecFluent.ApiKeyCredsNested<A> withNewApiKeyCredsLike(ApiKeyCreds item) {
        return new ApiKeyCredsNestedImpl(item);
    }

    @Override
    public A withNewApiKeyCreds(String apiKey) {
        return this.withApiKeyCreds(new ApiKeyCreds(apiKey));
    }

    @Override
    public A withAppCredentialsCreds(AppCredentialsCreds appCredentialsCreds) {
        this._visitables.get((Object)"creds").remove(this.creds);
        if (appCredentialsCreds != null) {
            this.creds = new AppCredentialsCredsBuilder(appCredentialsCreds);
            this._visitables.get((Object)"creds").add(this.creds);
        }
        return (A)this;
    }

    @Override
    public StackdriverSpecFluent.AppCredentialsCredsNested<A> withNewAppCredentialsCreds() {
        return new AppCredentialsCredsNestedImpl();
    }

    @Override
    public StackdriverSpecFluent.AppCredentialsCredsNested<A> withNewAppCredentialsCredsLike(AppCredentialsCreds item) {
        return new AppCredentialsCredsNestedImpl(item);
    }

    @Override
    public A withNewAppCredentialsCreds(Boolean appCredentials) {
        return this.withAppCredentialsCreds(new AppCredentialsCreds(appCredentials));
    }

    @Override
    public A withServiceAccountPathCreds(ServiceAccountPathCreds serviceAccountPathCreds) {
        this._visitables.get((Object)"creds").remove(this.creds);
        if (serviceAccountPathCreds != null) {
            this.creds = new ServiceAccountPathCredsBuilder(serviceAccountPathCreds);
            this._visitables.get((Object)"creds").add(this.creds);
        }
        return (A)this;
    }

    @Override
    public StackdriverSpecFluent.ServiceAccountPathCredsNested<A> withNewServiceAccountPathCreds() {
        return new ServiceAccountPathCredsNestedImpl();
    }

    @Override
    public StackdriverSpecFluent.ServiceAccountPathCredsNested<A> withNewServiceAccountPathCredsLike(ServiceAccountPathCreds item) {
        return new ServiceAccountPathCredsNestedImpl(item);
    }

    @Override
    public A withNewServiceAccountPathCreds(String serviceAccountPath) {
        return this.withServiceAccountPathCreds(new ServiceAccountPathCreds(serviceAccountPath));
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public A withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return (A)this;
    }

    @Override
    public Boolean hasEndpoint() {
        return this.endpoint != null;
    }

    @Override
    public A withNewEndpoint(String arg1) {
        return this.withEndpoint(new String(arg1));
    }

    @Override
    public A withNewEndpoint(StringBuilder arg1) {
        return this.withEndpoint(new String(arg1));
    }

    @Override
    public A withNewEndpoint(StringBuffer arg1) {
        return this.withEndpoint(new String(arg1));
    }

    @Override
    public A addToLogInfo(String key, LogInfo value) {
        if (this.logInfo == null && key != null && value != null) {
            this.logInfo = new LinkedHashMap<String, LogInfo>();
        }
        if (key != null && value != null) {
            this.logInfo.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLogInfo(Map<String, LogInfo> map) {
        if (this.logInfo == null && map != null) {
            this.logInfo = new LinkedHashMap<String, LogInfo>();
        }
        if (map != null) {
            this.logInfo.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLogInfo(String key) {
        if (this.logInfo == null) {
            return (A)this;
        }
        if (key != null && this.logInfo != null) {
            this.logInfo.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLogInfo(Map<String, LogInfo> map) {
        if (this.logInfo == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.logInfo == null) continue;
                this.logInfo.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, LogInfo> getLogInfo() {
        return this.logInfo;
    }

    @Override
    public A withLogInfo(Map<String, LogInfo> logInfo) {
        this.logInfo = logInfo == null ? null : new LinkedHashMap<String, LogInfo>(logInfo);
        return (A)this;
    }

    @Override
    public Boolean hasLogInfo() {
        return this.logInfo != null;
    }

    @Override
    public A addToMetricInfo(String key, MetricInfo value) {
        if (this.metricInfo == null && key != null && value != null) {
            this.metricInfo = new LinkedHashMap<String, MetricInfo>();
        }
        if (key != null && value != null) {
            this.metricInfo.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMetricInfo(Map<String, MetricInfo> map) {
        if (this.metricInfo == null && map != null) {
            this.metricInfo = new LinkedHashMap<String, MetricInfo>();
        }
        if (map != null) {
            this.metricInfo.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetricInfo(String key) {
        if (this.metricInfo == null) {
            return (A)this;
        }
        if (key != null && this.metricInfo != null) {
            this.metricInfo.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetricInfo(Map<String, MetricInfo> map) {
        if (this.metricInfo == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.metricInfo == null) continue;
                this.metricInfo.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, MetricInfo> getMetricInfo() {
        return this.metricInfo;
    }

    @Override
    public A withMetricInfo(Map<String, MetricInfo> metricInfo) {
        this.metricInfo = metricInfo == null ? null : new LinkedHashMap<String, MetricInfo>(metricInfo);
        return (A)this;
    }

    @Override
    public Boolean hasMetricInfo() {
        return this.metricInfo != null;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public A withProjectId(String projectId) {
        this.projectId = projectId;
        return (A)this;
    }

    @Override
    public Boolean hasProjectId() {
        return this.projectId != null;
    }

    @Override
    public A withNewProjectId(String arg1) {
        return this.withProjectId(new String(arg1));
    }

    @Override
    public A withNewProjectId(StringBuilder arg1) {
        return this.withProjectId(new String(arg1));
    }

    @Override
    public A withNewProjectId(StringBuffer arg1) {
        return this.withProjectId(new String(arg1));
    }

    @Override
    public Integer getPushInterval() {
        return this.pushInterval;
    }

    @Override
    public A withPushInterval(Integer pushInterval) {
        this.pushInterval = pushInterval;
        return (A)this;
    }

    @Override
    public Boolean hasPushInterval() {
        return this.pushInterval != null;
    }

    @Override
    @Deprecated
    public Trace getTrace() {
        return this.trace != null ? this.trace.build() : null;
    }

    @Override
    public Trace buildTrace() {
        return this.trace != null ? this.trace.build() : null;
    }

    @Override
    public A withTrace(Trace trace) {
        this._visitables.get((Object)"trace").remove(this.trace);
        if (trace != null) {
            this.trace = new TraceBuilder(trace);
            this._visitables.get((Object)"trace").add(this.trace);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTrace() {
        return this.trace != null;
    }

    @Override
    public A withNewTrace(Double sampleProbability) {
        return this.withTrace(new Trace(sampleProbability));
    }

    @Override
    public StackdriverSpecFluent.TraceNested<A> withNewTrace() {
        return new TraceNestedImpl();
    }

    @Override
    public StackdriverSpecFluent.TraceNested<A> withNewTraceLike(Trace item) {
        return new TraceNestedImpl(item);
    }

    @Override
    public StackdriverSpecFluent.TraceNested<A> editTrace() {
        return this.withNewTraceLike(this.getTrace());
    }

    @Override
    public StackdriverSpecFluent.TraceNested<A> editOrNewTrace() {
        return this.withNewTraceLike(this.getTrace() != null ? this.getTrace() : new TraceBuilder().build());
    }

    @Override
    public StackdriverSpecFluent.TraceNested<A> editOrNewTraceLike(Trace item) {
        return this.withNewTraceLike(this.getTrace() != null ? this.getTrace() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StackdriverSpecFluentImpl that = (StackdriverSpecFluentImpl)o;
        if (this.creds != null ? !this.creds.equals(that.creds) : that.creds != null) {
            return false;
        }
        if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) {
            return false;
        }
        if (this.logInfo != null ? !this.logInfo.equals(that.logInfo) : that.logInfo != null) {
            return false;
        }
        if (this.metricInfo != null ? !this.metricInfo.equals(that.metricInfo) : that.metricInfo != null) {
            return false;
        }
        if (this.projectId != null ? !this.projectId.equals(that.projectId) : that.projectId != null) {
            return false;
        }
        if (this.pushInterval != null ? !this.pushInterval.equals(that.pushInterval) : that.pushInterval != null) {
            return false;
        }
        return !(this.trace != null ? !this.trace.equals(that.trace) : that.trace != null);
    }

    public class TraceNestedImpl<N>
    extends TraceFluentImpl<StackdriverSpecFluent.TraceNested<N>>
    implements StackdriverSpecFluent.TraceNested<N>,
    Nested<N> {
        private final TraceBuilder builder;

        TraceNestedImpl(Trace item) {
            this.builder = new TraceBuilder(this, item);
        }

        TraceNestedImpl() {
            this.builder = new TraceBuilder(this);
        }

        @Override
        public N and() {
            return (N)StackdriverSpecFluentImpl.this.withTrace(this.builder.build());
        }

        @Override
        public N endTrace() {
            return this.and();
        }
    }

    public class ServiceAccountPathCredsNestedImpl<N>
    extends ServiceAccountPathCredsFluentImpl<StackdriverSpecFluent.ServiceAccountPathCredsNested<N>>
    implements StackdriverSpecFluent.ServiceAccountPathCredsNested<N>,
    Nested<N> {
        private final ServiceAccountPathCredsBuilder builder;

        ServiceAccountPathCredsNestedImpl(ServiceAccountPathCreds item) {
            this.builder = new ServiceAccountPathCredsBuilder(this, item);
        }

        ServiceAccountPathCredsNestedImpl() {
            this.builder = new ServiceAccountPathCredsBuilder(this);
        }

        @Override
        public N and() {
            return (N)StackdriverSpecFluentImpl.this.withServiceAccountPathCreds(this.builder.build());
        }

        @Override
        public N endServiceAccountPathCreds() {
            return this.and();
        }
    }

    public class AppCredentialsCredsNestedImpl<N>
    extends AppCredentialsCredsFluentImpl<StackdriverSpecFluent.AppCredentialsCredsNested<N>>
    implements StackdriverSpecFluent.AppCredentialsCredsNested<N>,
    Nested<N> {
        private final AppCredentialsCredsBuilder builder;

        AppCredentialsCredsNestedImpl(AppCredentialsCreds item) {
            this.builder = new AppCredentialsCredsBuilder(this, item);
        }

        AppCredentialsCredsNestedImpl() {
            this.builder = new AppCredentialsCredsBuilder(this);
        }

        @Override
        public N and() {
            return (N)StackdriverSpecFluentImpl.this.withAppCredentialsCreds(this.builder.build());
        }

        @Override
        public N endAppCredentialsCreds() {
            return this.and();
        }
    }

    public class ApiKeyCredsNestedImpl<N>
    extends ApiKeyCredsFluentImpl<StackdriverSpecFluent.ApiKeyCredsNested<N>>
    implements StackdriverSpecFluent.ApiKeyCredsNested<N>,
    Nested<N> {
        private final ApiKeyCredsBuilder builder;

        ApiKeyCredsNestedImpl(ApiKeyCreds item) {
            this.builder = new ApiKeyCredsBuilder(this, item);
        }

        ApiKeyCredsNestedImpl() {
            this.builder = new ApiKeyCredsBuilder(this);
        }

        @Override
        public N and() {
            return (N)StackdriverSpecFluentImpl.this.withApiKeyCreds(this.builder.build());
        }

        @Override
        public N endApiKeyCreds() {
            return this.and();
        }
    }
}

