/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.cloudwatch;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.mixer.adapter.cloudwatch.Cloudwatch;
import me.snowdrop.istio.mixer.adapter.cloudwatch.CloudwatchFluent;
import me.snowdrop.istio.mixer.adapter.cloudwatch.CloudwatchFluentImpl;

public class CloudwatchBuilder
extends CloudwatchFluentImpl<CloudwatchBuilder>
implements VisitableBuilder<Cloudwatch, CloudwatchBuilder> {
    CloudwatchFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CloudwatchBuilder() {
        this(true);
    }

    public CloudwatchBuilder(Boolean validationEnabled) {
        this(new Cloudwatch(), validationEnabled);
    }

    public CloudwatchBuilder(CloudwatchFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CloudwatchBuilder(CloudwatchFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Cloudwatch(), validationEnabled);
    }

    public CloudwatchBuilder(CloudwatchFluent<?> fluent, Cloudwatch instance) {
        this(fluent, instance, true);
    }

    public CloudwatchBuilder(CloudwatchFluent<?> fluent, Cloudwatch instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public CloudwatchBuilder(Cloudwatch instance) {
        this(instance, (Boolean)true);
    }

    public CloudwatchBuilder(Cloudwatch instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public CloudwatchBuilder(Validator validator) {
        this(new Cloudwatch(), (Boolean)true);
    }

    public CloudwatchBuilder(CloudwatchFluent<?> fluent, Cloudwatch instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public CloudwatchBuilder(Cloudwatch instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public Cloudwatch build() {
        Cloudwatch buildable = new Cloudwatch(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable, (Validator)this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudwatchBuilder that = (CloudwatchBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

